/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleAmmoExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(VehicleAmmoExtractor.class);
    private static final Map<String, List<String>> AMMO_CACHE = new HashMap<String, List<String>>();

    public static Set<String> getRequiredAmmo(String vehicleId) {
        return new LinkedHashSet<String>(VehicleAmmoExtractor.getRequiredAmmoSorted(vehicleId));
    }

    public static List<String> getRequiredAmmoSorted(String vehicleId) {
        if (AMMO_CACHE.containsKey(vehicleId)) {
            return AMMO_CACHE.get(vehicleId);
        }
        LinkedHashMap<String, Double> ammoDamageMap = new LinkedHashMap<String, Double>();
        String[] parts = vehicleId.split(":");
        if (parts.length != 2) {
            return Collections.emptyList();
        }
        String namespace = parts[0];
        String path = parts[1];
        String resourcePath = "/data/" + namespace + "/sbw/vehicles/" + path + ".json";
        try {
            InputStream stream = VehicleAmmoExtractor.class.getResourceAsStream(resourcePath);
            if (stream == null) {
                LOGGER.debug("Resource not found: {}", (Object)resourcePath);
                return Collections.emptyList();
            }
            JsonObject root = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
            stream.close();
            if (root.has("Weapons")) {
                JsonObject weapons = root.getAsJsonObject("Weapons");
                for (String weaponName : weapons.keySet()) {
                    if (weaponName.startsWith("@")) continue;
                    JsonObject weapon = weapons.getAsJsonObject(weaponName);
                    VehicleAmmoExtractor.extractAmmoFromWeapon(weapon, ammoDamageMap);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to load vehicle data for {}: {}", (Object)vehicleId, (Object)e.getMessage());
        }
        ArrayList<String> sortedAmmo = new ArrayList<String>(ammoDamageMap.keySet());
        sortedAmmo.sort((a, b) -> Double.compare((Double)ammoDamageMap.get(b), (Double)ammoDamageMap.get(a)));
        AMMO_CACHE.put(vehicleId, sortedAmmo);
        return sortedAmmo;
    }

    private static void extractAmmoFromWeapon(JsonObject weapon, Map<String, Double> ammoDamageMap) {
        if (!weapon.has("AmmoType")) {
            return;
        }
        double damage = VehicleAmmoExtractor.getDouble(weapon, "Damage", 0.0);
        double explosionDamage = VehicleAmmoExtractor.getDouble(weapon, "ExplosionDamage", 0.0);
        double totalDamage = damage + explosionDamage;
        JsonElement ammoElement = weapon.get("AmmoType");
        if (ammoElement.isJsonPrimitive()) {
            String ammo = ammoElement.getAsString();
            VehicleAmmoExtractor.addIfValidItem(ammo, totalDamage, ammoDamageMap);
        } else if (ammoElement.isJsonArray()) {
            for (JsonElement elem : ammoElement.getAsJsonArray()) {
                JsonObject ammoObj;
                if (elem.isJsonPrimitive()) {
                    VehicleAmmoExtractor.addIfValidItem(elem.getAsString(), totalDamage, ammoDamageMap);
                    continue;
                }
                if (!elem.isJsonObject() || !(ammoObj = elem.getAsJsonObject()).has("Ammo")) continue;
                VehicleAmmoExtractor.addIfValidItem(ammoObj.get("Ammo").getAsString(), totalDamage, ammoDamageMap);
            }
        }
    }

    private static double getDouble(JsonObject obj, String key, double defaultValue) {
        if (obj.has(key) && obj.get(key).isJsonPrimitive()) {
            try {
                return obj.get(key).getAsDouble();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static void addIfValidItem(String ammo, double damage, Map<String, Double> ammoDamageMap) {
        if (ammo == null || ammo.isEmpty()) {
            return;
        }
        if (ammo.startsWith("@") || ammo.startsWith("#")) {
            return;
        }
        if (ammo.equals("empty") || ammo.equals("infinity") || ammo.equals("infinite")) {
            return;
        }
        if (ammo.equals("fe") || ammo.equals("rf") || ammo.equals("energy")) {
            return;
        }
        if (ammo.contains(":")) {
            ammoDamageMap.merge(ammo, damage, Math::max);
        }
    }

    public static void clearCache() {
        AMMO_CACHE.clear();
    }
}

