/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import tech.mcsp.mcsp.client.overlay.APSWarningOverlay;

public class APSWarningPacket {
    private final Component message;
    private final int duration;

    public APSWarningPacket(Component message, int duration) {
        this.message = message;
        this.duration = duration;
    }

    public static void encode(APSWarningPacket packet, FriendlyByteBuf buf) {
        buf.m_130083_(packet.message);
        buf.writeInt(packet.duration);
    }

    public static APSWarningPacket decode(FriendlyByteBuf buf) {
        return new APSWarningPacket(buf.m_130238_(), buf.readInt());
    }

    public static void handle(APSWarningPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> APSWarningOverlay.show(packet.message, packet.duration)));
        ctx.get().setPacketHandled(true);
    }
}

