/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.mixin;

import com.atsuishio.superbwarfare.entity.projectile.MissileProjectile;
import com.atsuishio.superbwarfare.entity.projectile.WireGuideMissileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tech.mcsp.mcsp.data.OESData;
import tech.mcsp.mcsp.network.APSWarningPacket;
import tech.mcsp.mcsp.network.MCSPNetwork;

@Mixin(value={WireGuideMissileEntity.class})
public abstract class WireGuideMissileMixin
extends MissileProjectile {
    @Shadow(remap=false)
    public UUID launcherVehicle;
    @Unique
    private boolean mcsp$deflected = false;

    public WireGuideMissileMixin(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, remap=true)
    private void mcsp$checkOES(CallbackInfo ci) {
        if (this.m_9236_().m_5776_() || this.mcsp$deflected || this.f_19797_ < 10) {
            return;
        }
        List nearbyVehicles = this.m_9236_().m_45976_(VehicleEntity.class, new AABB(this.m_20182_(), this.m_20182_()).m_82400_(80.0));
        VehicleEntity targetVehicle = null;
        double bestApproachDot = 0.9;
        Vec3 missileDir = this.m_20184_().m_82541_();
        for (VehicleEntity vehicle : nearbyVehicles) {
            Vec3 toVehicle;
            double approachDot;
            double distance;
            OESData oes = OESData.get(vehicle);
            if (!oes.enabled || (distance = (double)this.m_20270_((Entity)vehicle)) > oes.range || distance < oes.minDistance || !((approachDot = missileDir.m_82526_(toVehicle = vehicle.m_20182_().m_82546_(this.m_20182_()).m_82541_())) > bestApproachDot)) continue;
            bestApproachDot = approachDot;
            targetVehicle = vehicle;
        }
        if (targetVehicle == null) {
            return;
        }
        OESData oes = OESData.get(targetVehicle);
        Entity owner = this.m_19749_();
        if (owner == null) {
            return;
        }
        if (oes.canDeflect(targetVehicle, owner.m_20182_())) {
            this.mcsp$deflectMissile(targetVehicle);
        }
    }

    @Unique
    private void mcsp$deflectMissile(VehicleEntity vehicle) {
        this.mcsp$deflected = true;
        this.distracted = true;
        this.lost = true;
        this.launcherVehicle = null;
        float yawOffset = (this.f_19796_.m_188501_() - 0.5f) * 30.0f;
        float pitchOffset = this.f_19796_.m_188501_() * 10.0f;
        this.m_146922_(this.m_146908_() + yawOffset);
        this.m_146926_(this.m_146909_() + pitchOffset);
        Vec3 lookAngle = this.m_20154_();
        double speed = this.m_20184_().m_82553_();
        Vec3 deflection = new Vec3((this.f_19796_.m_188500_() - 0.5) * 0.8, -0.1 - this.f_19796_.m_188500_() * 0.15, (this.f_19796_.m_188500_() - 0.5) * 0.8);
        this.m_20256_(lookAngle.m_82490_(speed * 0.7).m_82549_(deflection));
        Entity owner = this.m_19749_();
        if (owner instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)owner;
            MCSPNetwork.sendToPlayer(player, new APSWarningPacket((Component)Component.m_237115_((String)"message.mcsp.oes_deflected"), 60));
        }
    }
}

