/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.mixin;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tech.mcsp.mcsp.mixin.VehicleEntityAccessor;

@Mixin(value={VehicleEntity.class})
public abstract class VehicleEntityMixin
extends Entity {
    @Unique
    private static final Logger MCSP_LOGGER = LogManager.getLogger((String)"VehicleMixin-Perf");
    @Shadow(remap=false)
    protected static EntityDataAccessor<Map<String, GunData>> GUN_DATA_MAP;
    @Unique
    private int mcsp$gunDataSyncCounter = 0;
    @Unique
    private Map<String, GunData> mcsp$lastGunDataMap = null;
    @Unique
    private static long mcsp$lastProfileLog;
    @Unique
    private static int mcsp$profileTicks;
    @Unique
    private static long mcsp$totalGunDataTime;
    @Unique
    private static long mcsp$totalSuperTickTime;
    @Unique
    private static long mcsp$totalTravelTime;
    @Unique
    private static long mcsp$totalFullTickTime;
    @Unique
    private static long mcsp$totalGetGunDataMapTime;
    @Unique
    private static long mcsp$totalEntityDataSetTime;
    @Unique
    private static int mcsp$entityDataSetCalls;
    @Unique
    private static long mcsp$totalPreventStackingTime;
    @Unique
    private static long mcsp$totalSupportEntitiesTime;
    @Unique
    private static long mcsp$totalCrushEntitiesTime;
    @Unique
    private long mcsp$tickStartTime = 0L;

    public VehicleEntityMixin() {
        super(null, null);
    }

    @Inject(method={"baseTick()V"}, at={@At(value="HEAD")})
    private void mcsp$tickStart(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_) {
            this.mcsp$tickStartTime = System.nanoTime();
        }
    }

    @Redirect(method={"baseTick()V"}, at=@At(value="INVOKE", target="Lcom/atsuishio/superbwarfare/entity/vehicle/base/VehicleEntity;getGunDataMap()Ljava/util/Map;", remap=false))
    private Map<String, GunData> mcsp$profileGetGunDataMap(VehicleEntity vehicle) {
        long start = System.nanoTime();
        Map<String, GunData> result = ((VehicleEntityAccessor)vehicle).invokeGetGunDataMap();
        mcsp$totalGetGunDataMapTime += System.nanoTime() - start;
        return result;
    }

    @Redirect(method={"baseTick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;baseTick()V", remap=true))
    private void mcsp$profileSuperBaseTick(Entity entity) {
        long start = System.nanoTime();
        super.m_6075_();
        mcsp$totalSuperTickTime += System.nanoTime() - start;
    }

    @Redirect(method={"baseTick()V"}, at=@At(value="INVOKE", target="Lcom/atsuishio/superbwarfare/entity/vehicle/base/VehicleEntity;travel()V", remap=false))
    private void mcsp$profileTravel(VehicleEntity vehicle) {
        long start = System.nanoTime();
        ((VehicleEntityAccessor)vehicle).invokeTravel();
        mcsp$totalTravelTime += System.nanoTime() - start;
    }

    @Redirect(method={"baseTick()V"}, at=@At(value="INVOKE", target="Lcom/atsuishio/superbwarfare/entity/vehicle/base/VehicleEntity;preventStacking()V", remap=false))
    private void mcsp$profilePreventStacking(VehicleEntity vehicle) {
        long start = System.nanoTime();
        ((VehicleEntityAccessor)vehicle).invokePreventStacking();
        mcsp$totalPreventStackingTime += System.nanoTime() - start;
    }

    @Redirect(method={"baseTick()V"}, at=@At(value="INVOKE", target="Lcom/atsuishio/superbwarfare/entity/vehicle/base/VehicleEntity;supportEntities()V", remap=false))
    private void mcsp$profileSupportEntities(VehicleEntity vehicle) {
        long start = System.nanoTime();
        ((VehicleEntityAccessor)vehicle).invokeSupportEntities();
        mcsp$totalSupportEntitiesTime += System.nanoTime() - start;
    }

    @Redirect(method={"baseTick()V"}, at=@At(value="INVOKE", target="Lcom/atsuishio/superbwarfare/entity/vehicle/base/VehicleEntity;crushEntities()V", remap=false))
    private void mcsp$profileCrushEntities(VehicleEntity vehicle) {
        long start = System.nanoTime();
        ((VehicleEntityAccessor)vehicle).invokeCrushEntities();
        mcsp$totalCrushEntitiesTime += System.nanoTime() - start;
    }

    @Inject(method={"baseTick()V"}, at={@At(value="TAIL")})
    private void mcsp$logProfile(CallbackInfo ci) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        mcsp$totalFullTickTime += System.nanoTime() - this.mcsp$tickStartTime;
        ++mcsp$profileTicks;
        long now = System.currentTimeMillis();
        if (now - mcsp$lastProfileLog > 10000L) {
            if (mcsp$profileTicks > 0) {
                double avgFull = (double)mcsp$totalFullTickTime / (double)mcsp$profileTicks / 1000000.0;
                double avgSuper = (double)mcsp$totalSuperTickTime / (double)mcsp$profileTicks / 1000000.0;
                double avgTravel = (double)mcsp$totalTravelTime / (double)mcsp$profileTicks / 1000000.0;
                double avgGetGunDataMap = (double)mcsp$totalGetGunDataMapTime / (double)mcsp$profileTicks / 1000000.0;
                double avgEntityDataSet = (double)mcsp$totalEntityDataSetTime / (double)mcsp$profileTicks / 1000000.0;
                double avgPrevent = (double)mcsp$totalPreventStackingTime / (double)mcsp$profileTicks / 1000000.0;
                double avgSupport = (double)mcsp$totalSupportEntitiesTime / (double)mcsp$profileTicks / 1000000.0;
                double avgCrush = (double)mcsp$totalCrushEntitiesTime / (double)mcsp$profileTicks / 1000000.0;
                double other = avgFull - avgSuper - avgTravel - avgGetGunDataMap - avgEntityDataSet - avgPrevent - avgSupport - avgCrush;
                MCSP_LOGGER.info("[VehicleProfile] FULL:{}ms Super:{}ms Travel:{}ms Prevent:{}ms Support:{}ms Crush:{}ms Other:{}ms", (Object)String.format("%.2f", avgFull), (Object)String.format("%.2f", avgSuper), (Object)String.format("%.2f", avgTravel), (Object)String.format("%.2f", avgPrevent), (Object)String.format("%.2f", avgSupport), (Object)String.format("%.2f", avgCrush), (Object)String.format("%.2f", other));
            }
            mcsp$lastProfileLog = now;
            mcsp$profileTicks = 0;
            mcsp$totalFullTickTime = 0L;
            mcsp$totalSuperTickTime = 0L;
            mcsp$totalTravelTime = 0L;
            mcsp$totalGetGunDataMapTime = 0L;
            mcsp$totalEntityDataSetTime = 0L;
            mcsp$entityDataSetCalls = 0;
            mcsp$totalPreventStackingTime = 0L;
            mcsp$totalSupportEntitiesTime = 0L;
            mcsp$totalCrushEntitiesTime = 0L;
        }
    }

    @Redirect(method={"baseTick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/syncher/SynchedEntityData;set(Lnet/minecraft/network/syncher/EntityDataAccessor;Ljava/lang/Object;Z)V", remap=true))
    private <T> void mcsp$profileAndThrottleEntityDataSet(SynchedEntityData entityData, EntityDataAccessor<T> accessor, T value, boolean force) {
        ++mcsp$entityDataSetCalls;
        long start = System.nanoTime();
        if (accessor == GUN_DATA_MAP) {
            boolean shouldSync;
            ++this.mcsp$gunDataSyncCounter;
            Map newMap = (Map)value;
            boolean bl = shouldSync = this.mcsp$gunDataSyncCounter >= 10 || this.mcsp$hasGunDataChanged(newMap);
            if (shouldSync) {
                entityData.m_276349_(accessor, value, force);
                this.mcsp$gunDataSyncCounter = 0;
                this.mcsp$lastGunDataMap = new HashMap<String, GunData>(newMap);
            }
        } else {
            entityData.m_276349_(accessor, value, force);
        }
        mcsp$totalEntityDataSetTime += System.nanoTime() - start;
    }

    @Unique
    private boolean mcsp$hasGunDataChanged(Map<String, GunData> newMap) {
        if (this.mcsp$lastGunDataMap == null) {
            return true;
        }
        if (newMap.size() != this.mcsp$lastGunDataMap.size()) {
            return true;
        }
        for (Map.Entry<String, GunData> entry : newMap.entrySet()) {
            GunData oldData = this.mcsp$lastGunDataMap.get(entry.getKey());
            if (oldData == null) {
                return true;
            }
            GunData newData = entry.getValue();
            if (oldData.ammo.get() != newData.ammo.get()) {
                return true;
            }
            if (oldData.heat.get() != newData.heat.get()) {
                return true;
            }
            if (oldData.reload.stage.get() != newData.reload.stage.get()) {
                return true;
            }
            if (oldData.reload.time() != newData.reload.time()) {
                return true;
            }
            if (oldData.reload.state() == newData.reload.state()) continue;
            return true;
        }
        return false;
    }

    static {
        mcsp$lastProfileLog = 0L;
        mcsp$profileTicks = 0;
        mcsp$totalGunDataTime = 0L;
        mcsp$totalSuperTickTime = 0L;
        mcsp$totalTravelTime = 0L;
        mcsp$totalFullTickTime = 0L;
        mcsp$totalGetGunDataMapTime = 0L;
        mcsp$totalEntityDataSetTime = 0L;
        mcsp$entityDataSetCalls = 0;
        mcsp$totalPreventStackingTime = 0L;
        mcsp$totalSupportEntitiesTime = 0L;
        mcsp$totalCrushEntitiesTime = 0L;
    }
}

