/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class VehicleSpawnItem<T extends Entity>
extends Item {
    private final RegistryObject<EntityType<T>> entityTypeRegistryObject;

    public VehicleSpawnItem(RegistryObject<EntityType<T>> entityTypeRegistryObject, Item.Properties properties) {
        super(properties);
        this.entityTypeRegistryObject = entityTypeRegistryObject;
    }

    public String getVehicleId() {
        EntityType type = (EntityType)this.entityTypeRegistryObject.get();
        return EntityType.m_20613_((EntityType)type).toString();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.m_43722_();
        BlockPos blockpos = context.m_8083_();
        EntityType entitytype = (EntityType)this.entityTypeRegistryObject.get();
        Entity vehicle = entitytype.m_20615_(level);
        if (vehicle != null) {
            Vec3 spawnPos = Vec3.m_82539_((Vec3i)blockpos).m_82520_(0.0, 1.0, 0.0);
            vehicle.m_146884_(spawnPos);
            level.m_7967_(vehicle);
            if (!context.m_43723_().m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            level.m_142346_((Entity)context.m_43723_(), GameEvent.f_157810_, blockpos);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        String baseKey;
        String descriptionKey;
        MutableComponent description;
        String fullText;
        super.m_7373_(stack, level, tooltip, flag);
        String itemId = stack.m_41720_().m_5524_();
        if (itemId.startsWith("item.")) {
            itemId = itemId.substring(5);
        }
        if (((fullText = (description = Component.m_237115_((String)(descriptionKey = "des." + itemId))).getString()).equals(descriptionKey) || fullText.isEmpty()) && (baseKey = this.getBaseDescriptionKey(itemId)) != null && (fullText = (description = Component.m_237115_((String)baseKey)).getString()).equals(baseKey)) {
            fullText = "";
        }
        if (!fullText.isEmpty()) {
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237113_((String)fullText).m_130940_(ChatFormatting.GRAY));
            } else {
                String preview = fullText.length() > 15 ? fullText.substring(0, 15) + "..." : fullText;
                tooltip.add((Component)Component.m_237113_((String)preview).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.mcsp.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack);
    }

    private String getBaseDescriptionKey(String itemId) {
        String[] camoSuffixes;
        if (itemId.contains("humvee_carc") || itemId.contains("humvee_sand")) {
            return "des.mcsp.humvee_standart_spawn_item";
        }
        if (itemId.contains("m3a3_bradley") && !itemId.equals("mcsp.m3a3_bradley_spawn_item")) {
            return "des.mcsp.m3a3_bradley_spawn_item";
        }
        if (itemId.contains("m1a2") && !itemId.equals("mcsp.m1a2_spawn_item")) {
            return "des.mcsp.m1a2_spawn_item";
        }
        if (itemId.contains("ural_tricolor")) {
            return "des.mcsp.ural_green_spawn_item";
        }
        for (String suffix : camoSuffixes = new String[]{"_camo_spawn_item", "_sand_spawn_item", "_tricolor_spawn_item", "_tricolor_30_spawn_item", "_green_spawn_item"}) {
            String[] baseSuffixes;
            if (!itemId.endsWith(suffix)) continue;
            String base = itemId.substring(0, itemId.length() - suffix.length());
            for (String baseSuffix : baseSuffixes = new String[]{"_spawn_item", "_30_spawn_item"}) {
                String baseKey = "des." + base + baseSuffix;
                MutableComponent test = Component.m_237115_((String)baseKey);
                if (test.getString().equals(baseKey) || test.getString().isEmpty()) continue;
                return baseKey;
            }
        }
        return null;
    }
}

