/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.entity;

import com.atsuishio.superbwarfare.entity.mixin.OBBHitter;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.tools.OBB;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class UralGreenEntity
extends GeoVehicleEntity {
    private static final EntityDataAccessor<Integer> HURT_TICK = SynchedEntityData.m_135353_(UralGreenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> HIT_DIR_X = SynchedEntityData.m_135353_(UralGreenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HIT_DIR_Z = SynchedEntityData.m_135353_(UralGreenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float ornamentAngleX;
    public float ornamentAngleXO;
    public float ornamentAngleZ;
    public float ornamentAngleZO;
    private float ornamentVelocityX;
    private float ornamentVelocityZ;
    private Vec3 prevVelocity = Vec3.f_82478_;
    private int lastProcessedHurtTick = -1;

    public UralGreenEntity(EntityType<UralGreenEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HURT_TICK, (Object)-1);
        this.f_19804_.m_135372_(HIT_DIR_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HIT_DIR_Z, (Object)Float.valueOf(0.0f));
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.4f) * damage.floatValue()));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Projectile projectile;
        OBBHitter acc;
        OBB.Part part;
        Entity entity;
        if (!this.m_9236_().f_46443_ && amount > 0.0f && (entity = source.m_7640_()) instanceof Projectile && (part = (acc = OBBHitter.getInstance((Entity)(projectile = (Projectile)entity))).sbw$getCurrentHitPart()) == OBB.Part.INTERACTIVE) {
            Vec3 projVel = projectile.m_20184_().m_82541_();
            float vehYaw = (float)Math.toRadians(-this.m_146908_());
            float hitDirX = (float)(projVel.f_82479_ * Math.cos(vehYaw) - projVel.f_82481_ * Math.sin(vehYaw));
            float hitDirZ = (float)(projVel.f_82479_ * Math.sin(vehYaw) + projVel.f_82481_ * Math.cos(vehYaw));
            this.f_19804_.m_135381_(HIT_DIR_X, (Object)Float.valueOf(hitDirX));
            this.f_19804_.m_135381_(HIT_DIR_Z, (Object)Float.valueOf(hitDirZ));
            this.f_19804_.m_135381_(HURT_TICK, (Object)this.f_19797_);
        }
        return super.m_6469_(source, amount);
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_9236_().f_46443_) {
            this.tickOrnamentPhysics();
        } else {
            this.checkOrnamentPunch();
        }
    }

    private void checkOrnamentPunch() {
        float yaw = (float)Math.toRadians(-this.m_146908_());
        double localZ = 2.125;
        double worldOffsetX = localZ * Math.sin(yaw);
        double worldOffsetZ = localZ * Math.cos(yaw);
        Vec3 ornamentPos = this.m_20182_().m_82520_(worldOffsetX, 3.1, worldOffsetZ);
        for (Player player : this.m_9236_().m_6907_()) {
            Vec3 toOrnament;
            Vec3 lookVec;
            double dot;
            Vec3 playerEye;
            double dist;
            if (!player.f_20911_ || player.f_20913_ != 1 || !((dist = (playerEye = player.m_146892_()).m_82554_(ornamentPos)) < 2.0) || !((dot = (lookVec = player.m_20154_()).m_82526_(toOrnament = ornamentPos.m_82546_(playerEye).m_82541_())) > 0.7)) continue;
            float vehYaw = (float)Math.toRadians(-this.m_146908_());
            float hitDirX = (float)(lookVec.f_82479_ * Math.cos(vehYaw) - lookVec.f_82481_ * Math.sin(vehYaw));
            float hitDirZ = (float)(lookVec.f_82479_ * Math.sin(vehYaw) + lookVec.f_82481_ * Math.cos(vehYaw));
            this.f_19804_.m_135381_(HIT_DIR_X, (Object)Float.valueOf(-hitDirX));
            this.f_19804_.m_135381_(HIT_DIR_Z, (Object)Float.valueOf(-hitDirZ));
            this.f_19804_.m_135381_(HURT_TICK, (Object)this.f_19797_);
        }
    }

    private void tickOrnamentPhysics() {
        this.ornamentAngleXO = this.ornamentAngleX;
        this.ornamentAngleZO = this.ornamentAngleZ;
        Vec3 currentVel = this.m_20184_();
        Vec3 accel = currentVel.m_82546_(this.prevVelocity);
        this.prevVelocity = currentVel;
        float yawRad = (float)Math.toRadians(-this.m_146908_());
        float localAccelX = (float)(accel.f_82479_ * Math.cos(yawRad) - accel.f_82481_ * Math.sin(yawRad));
        float localAccelZ = (float)(accel.f_82479_ * Math.sin(yawRad) + accel.f_82481_ * Math.cos(yawRad));
        this.ornamentVelocityX += localAccelZ * 120.0f;
        this.ornamentVelocityZ += localAccelX * 120.0f;
        float time = (float)this.f_19797_ * 0.1f;
        this.ornamentVelocityX += (float)Math.sin(time * 0.7f) * 0.02f;
        this.ornamentVelocityZ += (float)Math.sin(time * 0.5f + 1.3f) * 0.015f;
        int hurtTick = (Integer)this.f_19804_.m_135370_(HURT_TICK);
        if (hurtTick >= 0 && hurtTick != this.lastProcessedHurtTick) {
            this.lastProcessedHurtTick = hurtTick;
            float impactForce = 18.0f;
            float hitDirX = ((Float)this.f_19804_.m_135370_(HIT_DIR_X)).floatValue();
            float hitDirZ = ((Float)this.f_19804_.m_135370_(HIT_DIR_Z)).floatValue();
            this.ornamentVelocityX += hitDirZ * impactForce + (this.f_19796_.m_188501_() - 0.5f) * 3.0f;
            this.ornamentVelocityZ += hitDirX * impactForce + (this.f_19796_.m_188501_() - 0.5f) * 3.0f;
        }
        this.ornamentVelocityX -= this.ornamentAngleX * 0.18f;
        this.ornamentVelocityZ -= this.ornamentAngleZ * 0.18f;
        this.ornamentVelocityX *= 0.94f;
        this.ornamentVelocityZ *= 0.94f;
        this.ornamentAngleX += this.ornamentVelocityX;
        this.ornamentAngleZ += this.ornamentVelocityZ;
        this.ornamentAngleX = Mth.m_14036_((float)this.ornamentAngleX, (float)-35.0f, (float)35.0f);
        this.ornamentAngleZ = Mth.m_14036_((float)this.ornamentAngleZ, (float)-35.0f, (float)35.0f);
    }
}

