/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.entity;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArtilleryEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSerializers;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.ArtilleryIndicator;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.VectorTool;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4d;
import tech.mcsp.mcsp.init.MCSPMenuTypes;
import tech.mcsp.mcsp.item.MlrsRocketItem;
import tech.mcsp.mcsp.menu.Tos1aMenu;

public class Tos1aEntity
extends ArtilleryEntity {
    public static final int SHELL_COUNT = 21;
    public static final EntityDataAccessor<IntList> LOADED_AMMO = SynchedEntityData.m_135353_(Tos1aEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModSerializers.INT_LIST_SERIALIZER.get()));
    private static final double OBB_Z = 2.8125;
    private static final double[][] OBB_POSITIONS = new double[][]{{0.9375, 0.71875, 2.8125}, {0.625, 0.71875, 2.8125}, {0.3125, 0.71875, 2.8125}, {0.0, 0.71875, 2.8125}, {-0.3125, 0.71875, 2.8125}, {-0.625, 0.71875, 2.8125}, {-0.9375, 0.71875, 2.8125}, {0.9375, 1.03125, 2.8125}, {0.625, 1.03125, 2.8125}, {0.3125, 1.03125, 2.8125}, {0.0, 1.03125, 2.8125}, {-0.3125, 1.03125, 2.8125}, {-0.625, 1.03125, 2.8125}, {-0.9375, 1.03125, 2.8125}, {0.9375, 1.34375, 2.8125}, {0.625, 1.34375, 2.8125}, {0.3125, 1.34375, 2.8125}, {0.0, 1.34375, 2.8125}, {-0.3125, 1.34375, 2.8125}, {-0.625, 1.34375, 2.8125}, {-0.9375, 1.34375, 2.8125}};
    public OBB[] barrelOBB = new OBB[21];
    public int interactCooldown;
    private int currentShootSlot = -1;
    private List<OBB> cachedOBBList = null;
    private final Vector4d tempWorldPos = new Vector4d();
    private final Vector3f tempCenter = new Vector3f();
    public static final int BATTERY_SLOT_START = 21;
    public static final int BATTERY_SLOT_COUNT = 9;
    private int shellObbUpdateCounter = 0;
    private static final int SHELL_OBB_UPDATE_INTERVAL = 2;

    public Tos1aEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.initBarrelOBBs();
        this.f_19804_.m_135381_(BARREL_ANIM, (Object)IntList.of((int[])new int[21]));
        this.resizeItems();
    }

    public int getMaxBarrel() {
        return 21;
    }

    private void initBarrelOBBs() {
        Vector3d halfSize = new Vector3d(0.125, 0.125, 2.03125);
        for (int i = 0; i < 21; ++i) {
            this.barrelOBB[i] = new OBB(OBB.vec3ToVector3d((Vec3)this.m_20182_()), halfSize, new Quaterniond(), OBB.Part.INTERACTIVE);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        IntArrayList list = new IntArrayList();
        for (int i = 0; i < 21; ++i) {
            list.add(-1);
        }
        this.f_19804_.m_135372_(LOADED_AMMO, (Object)list);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128385_("LoadedAmmo", ((IntList)this.f_19804_.m_135370_(LOADED_AMMO)).toIntArray());
    }

    protected void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("LoadedAmmo")) {
            this.f_19804_.m_135381_(LOADED_AMMO, (Object)IntList.of((int[])compound.m_128465_("LoadedAmmo")));
        }
        this.syncAmmoFromItems();
    }

    public int m_6643_() {
        return 30;
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        if (slot < 21) {
            return false;
        }
        return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
    }

    public boolean m_271862_(@NotNull Container target, int slot, @NotNull ItemStack stack) {
        return slot >= 21;
    }

    public boolean hasMenu() {
        return true;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (!pPlayer.m_5833_()) {
            return new Tos1aMenu((MenuType)MCSPMenuTypes.TOS1A_MENU.get(), pContainerId, pPlayerInventory, new Tos1aBatteryContainer(this));
        }
        return null;
    }

    private IntArrayList buildLoadedAmmoList() {
        IntArrayList list = new IntArrayList(21);
        for (int i = 0; i < 21; ++i) {
            ItemStack stack = this.m_8020_(i);
            Item item = stack.m_41720_();
            if (item instanceof MlrsRocketItem) {
                MlrsRocketItem rocketItem = (MlrsRocketItem)item;
                list.add(rocketItem.type.ordinal());
                continue;
            }
            list.add(-1);
        }
        return list;
    }

    public void syncAmmoFromItems() {
        this.f_19804_.m_135381_(LOADED_AMMO, (Object)this.buildLoadedAmmoList());
        int loadedCount = 0;
        for (int i = 0; i < 21; ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            ++loadedCount;
        }
        int count = loadedCount;
        this.modifyGunData("TOS", data -> data.ammo.set(count));
    }

    public void m_6596_() {
        this.syncAmmoFromItems();
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        boolean lookingAtInteractive;
        Level pos;
        ServerLevel serverLevel;
        if (player.m_20202_() == this) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21205_();
        if (player.m_6144_() && stack.m_204117_(ModTags.Items.TOOLS_CROWBAR) && this.m_20197_().isEmpty()) {
            for (ItemStack item : this.getRetrieveItems()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)item);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        OBB lookingShellObb = null;
        int lookingShellIndex = -1;
        double reach = player.getEntityReach();
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20154_();
        Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_(reach));
        Vector3d start = new Vector3d(eyePos.f_82479_, eyePos.f_82480_, eyePos.f_82481_);
        Vector3d end = new Vector3d(endPos.f_82479_, endPos.f_82480_, endPos.f_82481_);
        double closestDist = Double.MAX_VALUE;
        for (int i = 0; i < 21; ++i) {
            double dist;
            Optional hit = this.barrelOBB[i].clip(start, end);
            if (!hit.isPresent() || !((dist = ((Vector3d)hit.get()).distanceSquared((Vector3dc)start)) < closestDist)) continue;
            closestDist = dist;
            lookingShellObb = this.barrelOBB[i];
            lookingShellIndex = i;
        }
        OBB lookingObb = OBB.getLookingObb((Player)player, (double)reach);
        Item dist = stack.m_41720_();
        if (dist instanceof ArtilleryIndicator) {
            ArtilleryIndicator indicator = (ArtilleryIndicator)dist;
            if (player.m_6144_()) {
                if (player.m_20201_() == this) {
                    return InteractionResult.FAIL;
                }
                return indicator.bind(stack, player, (Entity)this);
            }
        }
        if (stack.m_41720_() instanceof MlrsRocketItem && this.interactCooldown == 0 && lookingShellIndex >= 0 && this.m_8020_(lookingShellIndex).m_41619_()) {
            dist = this.m_9236_();
            if (dist instanceof ServerLevel) {
                serverLevel = (ServerLevel)dist;
                this.m_6836_(lookingShellIndex, stack.m_255036_(1));
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                pos = OBB.vector3dToVec3((Vector3d)this.barrelOBB[lookingShellIndex].center());
                serverLevel.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)ModSounds.TYPE_63_RELOAD.get(), SoundSource.PLAYERS, 1.0f, this.f_19796_.m_188501_() * 0.1f + 0.9f);
                this.interactCooldown = 5;
                this.m_6596_();
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41619_() && !player.m_6144_() && this.interactCooldown == 0 && lookingShellIndex >= 0 && !this.m_8020_(lookingShellIndex).m_41619_()) {
            pos = this.m_9236_();
            if (pos instanceof ServerLevel) {
                serverLevel = (ServerLevel)pos;
                player.m_36356_(this.m_8020_(lookingShellIndex).m_255036_(1));
                pos = OBB.vector3dToVec3((Vector3d)this.barrelOBB[lookingShellIndex].center());
                serverLevel.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, (SoundEvent)ModSounds.TYPE_63_RELOAD.get(), SoundSource.PLAYERS, 1.0f, this.f_19796_.m_188501_() * 0.1f + 0.9f);
                this.interactCooldown = 5;
                this.m_6836_(lookingShellIndex, ItemStack.f_41583_);
                this.m_6596_();
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            return InteractionResult.SUCCESS;
        }
        if (player.m_21205_().m_41720_() == ModItems.FIRING_PARAMETERS.get() && player.m_6144_()) {
            this.setTarget(player.m_21205_(), (Entity)player, "TOS");
            return InteractionResult.SUCCESS;
        }
        if (player.m_21206_().m_41720_() == ModItems.FIRING_PARAMETERS.get() && player.m_6144_()) {
            this.setTarget(player.m_21206_(), (Entity)player, "TOS");
            return InteractionResult.SUCCESS;
        }
        boolean bl = lookingAtInteractive = lookingShellIndex >= 0;
        if (!(lookingAtInteractive || lookingObb == null || lookingObb.part() != OBB.Part.TURRET && lookingObb.part() != OBB.Part.INTERACTIVE)) {
            lookingAtInteractive = true;
        }
        if (!lookingAtInteractive && !player.m_6144_() && this.getMaxPassengers() > 0 && this.m_146895_() == null) {
            if (player instanceof FakePlayer) {
                return InteractionResult.PASS;
            }
            VehicleVecUtils.setDriverAngle((VehicleEntity)this, (Player)player);
            player.m_6858_(false);
            if (player.m_9236_() instanceof ServerLevel) {
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.interactCooldown > 0) {
            --this.interactCooldown;
        }
        this.updateOBB();
    }

    public List<OBB> getOBBs() {
        return super.getOBBs();
    }

    public List<OBB> getAllOBBsForRender() {
        if (this.cachedOBBList == null) {
            List parentOBBs = super.getOBBs();
            this.cachedOBBList = new ArrayList<OBB>(parentOBBs.size() + 21);
            this.cachedOBBList.addAll(parentOBBs);
            for (int i = 0; i < 21; ++i) {
                this.cachedOBBList.add(this.barrelOBB[i]);
            }
        }
        return this.cachedOBBList;
    }

    public OBB getShellOBB(int index) {
        if (index >= 0 && index < 21) {
            return this.barrelOBB[index];
        }
        return null;
    }

    public void updateOBB() {
        super.updateOBB();
        this.cachedOBBList = null;
        if (!this.m_9236_().f_46443_) {
            ++this.shellObbUpdateCounter;
            if (this.shellObbUpdateCounter < 2) {
                return;
            }
            this.shellObbUpdateCounter = 0;
        }
        Matrix4d transform = this.getBarrelTransform(1.0f);
        Quaterniond rotation = VectorTool.combineRotationsBarrel((float)1.0f, (VehicleEntity)this);
        for (int i = 0; i < 21; ++i) {
            this.transformPositionInto(transform, OBB_POSITIONS[i][0], OBB_POSITIONS[i][1], OBB_POSITIONS[i][2], this.tempWorldPos);
            this.tempCenter.set((float)this.tempWorldPos.x, (float)this.tempWorldPos.y, (float)this.tempWorldPos.z);
            this.barrelOBB[i].center().set((Vector3fc)this.tempCenter);
            this.barrelOBB[i].setRotation(rotation);
        }
    }

    private void transformPositionInto(Matrix4d transform, double x, double y, double z, Vector4d dest) {
        dest.set(x, y, z, 1.0);
        transform.transform(dest);
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.35f) * damage.floatValue()));
    }

    public boolean canBind() {
        return true;
    }

    @NotNull
    public List<ItemStack> getRetrieveItems() {
        return List.of(ContainerBlockItem.createInstance((Entity)this));
    }

    public int getFirstLoadedSlot() {
        for (int i = 0; i < 21; ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public Vec3 getShootPos(Entity entity, float ticks) {
        int slot;
        int n = slot = this.currentShootSlot >= 0 ? this.currentShootSlot : this.getFirstLoadedSlot();
        if (slot >= 0) {
            return this.getShootPosForSlot(slot, ticks);
        }
        return super.getShootPos(entity, ticks);
    }

    public Vec3 getShootPos(String weaponName, float ticks) {
        int slot;
        int n = slot = this.currentShootSlot >= 0 ? this.currentShootSlot : this.getFirstLoadedSlot();
        if (slot >= 0) {
            return this.getShootPosForSlot(slot, ticks);
        }
        return super.getShootPos(weaponName, ticks);
    }

    private Vec3 getShootPosForSlot(int slot, float ticks) {
        GunData data = this.getGunData("TOS");
        if (data != null && data.compute().shootPos.positions.size() > slot) {
            Vec3 vec3 = (Vec3)data.compute().shootPos.positions.get(slot);
            Vector4d worldPosition = this.transformPosition(this.getTransformFromString(data.compute().shootPos.transform, ticks), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        }
        return this.m_20299_(ticks);
    }

    public void beforeShoot(LivingEntity living) {
        GunData data = this.getGunData("TOS");
        if (data == null) {
            return;
        }
        this.currentShootSlot = this.getFirstLoadedSlot();
        if (this.currentShootSlot < 0) {
            return;
        }
        this.items.set(this.currentShootSlot, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135381_(LOADED_AMMO, (Object)this.buildLoadedAmmoList());
        int[] barrelAnim = ((IntList)this.f_19804_.m_135370_(BARREL_ANIM)).toIntArray();
        if (this.currentShootSlot < barrelAnim.length) {
            barrelAnim[this.currentShootSlot] = data.compute().shootAnimationTime;
            this.f_19804_.m_135381_(BARREL_ANIM, (Object)IntList.of((int[])barrelAnim));
        }
    }

    public void afterShoot(GunData gunData, Vec3 shootVec) {
        super.afterShoot(gunData, shootVec);
        this.currentShootSlot = -1;
    }

    public static class Tos1aBatteryContainer
    implements Container {
        private final Tos1aEntity vehicle;

        public Tos1aBatteryContainer(Tos1aEntity vehicle) {
            this.vehicle = vehicle;
        }

        public int m_6643_() {
            return 9;
        }

        public boolean m_7983_() {
            for (int i = 0; i < 9; ++i) {
                if (this.m_8020_(i).m_41619_()) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public ItemStack m_8020_(int slot) {
            return this.vehicle.m_8020_(21 + slot);
        }

        @NotNull
        public ItemStack m_7407_(int slot, int amount) {
            return this.vehicle.m_7407_(21 + slot, amount);
        }

        @NotNull
        public ItemStack m_8016_(int slot) {
            return this.vehicle.m_8016_(21 + slot);
        }

        public void m_6836_(int slot, @NotNull ItemStack stack) {
            this.vehicle.m_6836_(21 + slot, stack);
        }

        public void m_6596_() {
            this.vehicle.m_6596_();
        }

        public boolean m_6542_(@NotNull Player player) {
            return this.vehicle.m_6542_(player);
        }

        public void m_6211_() {
            for (int i = 0; i < 9; ++i) {
                this.m_6836_(i, ItemStack.f_41583_);
            }
        }
    }
}

