/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.data;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class OESData {
    private static final Map<String, OESData> CACHE = new ConcurrentHashMap<String, OESData>();
    private static final Gson GSON = new Gson();
    public final boolean enabled;
    public final double coneAngle;
    public final double range;
    public final double minDistance;
    public static final OESData DISABLED = new OESData(false, 0.0, 0.0, 0.0);

    public OESData(boolean enabled, double coneAngle, double range, double minDistance) {
        this.enabled = enabled;
        this.coneAngle = coneAngle;
        this.range = range;
        this.minDistance = minDistance;
    }

    public static OESData get(VehicleEntity vehicle) {
        String id = EntityType.m_20613_((EntityType)vehicle.m_6095_()).toString();
        return CACHE.getOrDefault(id, DISABLED);
    }

    public static void register(String vehicleId, OESData data) {
        CACHE.put(vehicleId, data);
    }

    public static void clear() {
        CACHE.clear();
    }

    public static OESData fromJson(JsonObject json) {
        boolean enabled;
        if (json == null || !json.has("OES")) {
            return null;
        }
        JsonElement oesElement = json.get("OES");
        if (!oesElement.isJsonObject()) {
            return null;
        }
        JsonObject oes = oesElement.getAsJsonObject();
        boolean bl = enabled = oes.has("Enabled") && oes.get("Enabled").getAsBoolean();
        if (!enabled) {
            return null;
        }
        double coneAngle = oes.has("ConeAngle") ? oes.get("ConeAngle").getAsDouble() : 35.0;
        double range = oes.has("Range") ? oes.get("Range").getAsDouble() : 80.0;
        double minDistance = oes.has("MinDistance") ? oes.get("MinDistance").getAsDouble() : 8.0;
        return new OESData(true, coneAngle, range, minDistance);
    }

    public boolean canDeflect(VehicleEntity vehicle, Vec3 shooterPos) {
        if (!this.enabled) {
            return false;
        }
        Vec3 turretDir3D = vehicle.getTurretVector(1.0f);
        Vec3 turretDir = new Vec3(turretDir3D.f_82479_, 0.0, turretDir3D.f_82481_).m_82541_();
        Vec3 turretPos = vehicle.m_20182_().m_82520_(0.0, 2.0, 0.0);
        Vec3 toShooter = new Vec3(shooterPos.f_82479_ - turretPos.f_82479_, 0.0, shooterPos.f_82481_ - turretPos.f_82481_).m_82541_();
        double dot = turretDir.m_82526_(toShooter);
        double angle = Math.toDegrees(Math.acos(dot = Math.max(-1.0, Math.min(1.0, dot))));
        return angle <= this.coneAngle;
    }

    public static class Loader
    extends SimplePreparableReloadListener<Map<String, OESData>> {
        @NotNull
        protected Map<String, OESData> prepare(@NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
            ConcurrentHashMap<String, OESData> result = new ConcurrentHashMap<String, OESData>();
            FileToIdConverter converter = FileToIdConverter.m_246568_((String)"sbw/vehicles");
            for (Map.Entry entry : converter.m_247457_(manager).entrySet()) {
                ResourceLocation resourceLoc = (ResourceLocation)entry.getKey();
                ResourceLocation pathLoc = converter.m_245273_(resourceLoc);
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                    try {
                        JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        String id = json.has("ID") && !json.get("ID").getAsString().isEmpty() ? json.get("ID").getAsString() : pathLoc.toString();
                        OESData oes = OESData.fromJson(json);
                        if (oes == null) continue;
                        result.put(id, oes);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception e) {
                    System.err.println("[OES] Error parsing " + resourceLoc + ": " + e.getMessage());
                }
            }
            return result;
        }

        protected void apply(@NotNull Map<String, OESData> data, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
            OESData.clear();
            data.forEach(OESData::register);
        }
    }
}

