/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.client.overlay;

import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import tech.mcsp.mcsp.entity.Tos1aEntity;
import tech.mcsp.mcsp.init.ModItems;

@OnlyIn(value=Dist.CLIENT)
public class Tos1aBarrelOverlay
implements IGuiOverlay {
    public static final String ID = "mcsp_tos1a_barrel";
    private static final ItemStack MLRS = ((Item)ModItems.MLRS_SHELLS.get()).m_7968_();
    private static final double MAX_DISPLAY_DISTANCE = 4.0;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_20202_() instanceof Tos1aEntity) {
            return;
        }
        Entity lookingEntity = TraceTool.findLookingEntity((Entity)player, (double)player.getEntityReach());
        if (!(lookingEntity instanceof Tos1aEntity)) {
            return;
        }
        Tos1aEntity tos = (Tos1aEntity)lookingEntity;
        IntList items = (IntList)tos.m_20088_().m_135370_(Tos1aEntity.LOADED_AMMO);
        int lookingIndex = this.getLookingShellIndex((Player)player, tos);
        if (lookingIndex >= 0) {
            double halfLength;
            Vec3 barrelDir;
            int i = lookingIndex;
            int type = items.getInt(i);
            ItemStack stack = type >= 0 ? MLRS : ItemStack.f_41583_;
            OBB obb = tos.barrelOBB[i];
            Vec3 center = OBB.vector3dToVec3((Vector3d)obb.center());
            Vec3 pos = center.m_82546_((barrelDir = tos.getBarrelVector(mc.m_91296_())).m_82490_(halfLength = obb.extents().z));
            double distToPlayer = pos.m_82554_(player.m_146892_());
            if (distToPlayer > 4.0) {
                return;
            }
            Vec3 point = VectorUtil.worldToScreen((Vec3)pos);
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            float x = (float)point.f_82479_;
            float y = (float)point.f_82480_;
            Component component = stack.m_41786_();
            if (stack.m_41619_()) {
                component = Component.m_237115_((String)"tips.superbwarfare.barrel_empty");
                int width = mc.f_91062_.m_92852_((FormattedText)component);
                poseStack.m_252880_(x - (float)width / 2.0f, y, 0.0f);
                guiGraphics.m_280614_(mc.f_91062_, component, 0, 0, -1, false);
            } else {
                int width = mc.f_91062_.m_92852_((FormattedText)component) + 20;
                poseStack.m_252880_(x - (float)width / 2.0f, y, 0.0f);
                guiGraphics.m_280203_(stack, 0, 0);
                poseStack.m_252880_(20.0f, 4.0f, 0.0f);
                guiGraphics.m_280614_(mc.f_91062_, component, 0, 0, -1, false);
            }
            poseStack.m_85849_();
        }
    }

    private int getLookingShellIndex(Player player, Tos1aEntity tos) {
        double reach = player.getEntityReach();
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20154_();
        Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_(reach));
        Vector3d start = new Vector3d(eyePos.f_82479_, eyePos.f_82480_, eyePos.f_82481_);
        Vector3d end = new Vector3d(endPos.f_82479_, endPos.f_82480_, endPos.f_82481_);
        double closestDist = Double.MAX_VALUE;
        int closestIndex = -1;
        for (int i = 0; i < 21; ++i) {
            double dist;
            Optional hit = tos.barrelOBB[i].clip(start, end);
            if (!hit.isPresent() || !((dist = ((Vector3d)hit.get()).distanceSquared((Vector3dc)start)) < closestDist)) continue;
            closestDist = dist;
            closestIndex = i;
        }
        return closestIndex;
    }
}

