/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.client.model;

import com.atsuishio.superbwarfare.client.model.entity.VehicleModel;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import tech.mcsp.mcsp.entity.Tos1aEntity;

public class Tos1aModel<T extends Tos1aEntity>
extends VehicleModel<T> {
    private ResourceLocation lastModel = null;
    private static final Pattern SHELL_PATTERN = Pattern.compile("^shell(?<id>\\d+)$");
    private static final int TRACK_COUNT = 60;
    private static final int MAX_IDX = 60;
    private static final float[][] KEYFRAMES = new float[][]{{176.94f, 19.5f, 47.0f}, {143.28f, 18.21f, 50.72f}, {104.12f, 14.89f, 52.83f}, {64.95f, 10.97f, 52.44f}, {31.97f, 8.12f, 49.71f}, {31.97f, 6.0f, 46.31f}, {31.97f, 3.87f, 42.91f}, {31.67f, 1.75f, 39.5f}, {2.96f, 0.51f, 35.75f}, {0.0f, 0.5f, 31.74f}, {0.0f, 0.5f, 27.72f}, {0.0f, 0.5f, 23.71f}, {0.0f, 0.5f, 19.7f}, {0.0f, 0.5f, 15.69f}, {0.0f, 0.5f, 11.68f}, {0.0f, 0.5f, 7.67f}, {0.0f, 0.5f, 3.66f}, {0.0f, 0.5f, -0.35f}, {0.0f, 0.5f, -4.36f}, {0.0f, 0.5f, -8.37f}, {0.0f, 0.5f, -12.39f}, {0.0f, 0.5f, -16.4f}, {0.0f, 0.5f, -20.41f}, {0.0f, 0.5f, -24.42f}, {0.0f, 0.5f, -28.43f}, {0.0f, 0.5f, -32.44f}, {0.0f, 0.5f, -36.45f}, {-15.89f, 0.78f, -40.44f}, {-34.83f, 2.74f, -43.91f}, {-34.83f, 5.03f, -47.2f}, {-34.83f, 7.32f, -50.49f}, {-34.83f, 9.61f, -53.79f}, {-43.75f, 11.96f, -57.03f}, {-93.29f, 15.58f, -58.5f}, {-137.89f, 19.15f, -56.92f}, {-179.94f, 20.46f, -53.25f}, {177.31f, 20.29f, -49.24f}, {177.14f, 20.09f, -45.24f}, {177.14f, 19.89f, -41.23f}, {177.14f, 19.69f, -37.23f}, {179.28f, 19.5f, -33.22f}, {-180.0f, 19.5f, -29.21f}, {-180.0f, 19.5f, -25.2f}, {-180.0f, 19.5f, -21.19f}, {-180.0f, 19.5f, -17.18f}, {-180.0f, 19.5f, -13.16f}, {-180.0f, 19.5f, -9.15f}, {-180.0f, 19.5f, -5.14f}, {-180.0f, 19.5f, -1.13f}, {-180.0f, 19.5f, 2.88f}, {-180.0f, 19.5f, 6.89f}, {-180.0f, 19.5f, 10.9f}, {-180.0f, 19.5f, 14.91f}, {-180.0f, 19.5f, 18.92f}, {-180.0f, 19.5f, 22.93f}, {-180.0f, 19.5f, 26.95f}, {-180.0f, 19.5f, 30.96f}, {-180.0f, 19.5f, 34.97f}, {-180.0f, 19.5f, 38.98f}, {-180.0f, 19.5f, 42.99f}, {176.94f, 19.5f, 47.0f}};
    private static final float START_Y = 19.5f;
    private static final float START_Z = 47.0f;
    private static final Pattern WHEEL_PATTERN = Pattern.compile("^wheel(?<direction>[LR]).*$");

    public ResourceLocation getModelResource(T vehicle) {
        ResourceLocation model = super.getModelResource(vehicle);
        if (this.lastModel != null && !this.lastModel.equals((Object)model)) {
            this.init = false;
            this.TRANSFORMS.clear();
        }
        this.lastModel = model;
        return model;
    }

    public boolean hideForTurretControllerWhileZooming() {
        return true;
    }

    private float getKeyframeValue(float t, int component) {
        int wrapRange = 120;
        float normalized = t / (float)wrapRange * 60.0f;
        int idx1 = Mth.m_14045_((int)((int)normalized), (int)0, (int)60);
        int idx2 = Mth.m_14045_((int)(idx1 + 1), (int)0, (int)60);
        float frac = normalized - (float)((int)normalized);
        float p1 = KEYFRAMES[idx1][component];
        float p2 = KEYFRAMES[idx2][component];
        if (component == 0) {
            float diff = p2 - p1;
            if (diff > 180.0f) {
                p2 -= 360.0f;
            } else if (diff < -180.0f) {
                p2 += 360.0f;
            }
        }
        return Mth.m_14179_((float)frac, (float)p1, (float)p2);
    }

    public float getBoneRotX(float t) {
        return this.getKeyframeValue(t, 0);
    }

    public float getBoneMoveY(float t) {
        return this.getKeyframeValue(t, 1) - 19.5f;
    }

    public float getBoneMoveZ(float t) {
        return this.getKeyframeValue(t, 2) - 47.0f;
    }

    public int getDefaultWrapRange(VehicleEntity vehicle) {
        return 120;
    }

    @Nullable
    public VehicleModel.TransformContext<T> collectTransform(String boneName) {
        Matcher matcher = SHELL_PATTERN.matcher(boneName);
        if (matcher.matches()) {
            int shellIndex = Integer.parseInt(matcher.group("id"));
            return (bone, vehicle, state) -> {
                IntList items = (IntList)vehicle.m_20088_().m_135370_(Tos1aEntity.LOADED_AMMO);
                if (shellIndex < items.size()) {
                    bone.setHidden(items.getInt(shellIndex) == -1);
                }
            };
        }
        Matcher wheelMatcher = WHEEL_PATTERN.matcher(boneName);
        if (wheelMatcher.matches()) {
            boolean isL = wheelMatcher.group("direction").equals("L");
            if (boneName.endsWith("Turn")) {
                return (bone, vehicle, state) -> {
                    bone.setRotX(1.5f * (isL ? this.rightWheelRot : this.leftWheelRot));
                    bone.setRotY(Mth.m_14179_((float)state.getPartialTick(), (float)vehicle.rudderRotO, (float)vehicle.getRudderRot()));
                };
            }
            return (bone, vehicle, state) -> bone.setRotX(1.5f * (isL ? this.rightWheelRot : this.leftWheelRot));
        }
        return super.collectTransform(boneName);
    }
}

