/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.client.event;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.mcsp.mcsp.item.VehicleSpawnItem;
import tech.mcsp.mcsp.util.VehicleAmmoExtractor;

@Mod.EventBusSubscriber(modid="mcsp", value={Dist.CLIENT})
public class TooltipRenderHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TooltipRenderHandler.class);

    @SubscribeEvent
    public static void onRenderTooltip(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (!(item instanceof VehicleSpawnItem)) {
            return;
        }
        VehicleSpawnItem spawnItem = (VehicleSpawnItem)item;
        String vehicleId = spawnItem.getVehicleId();
        if (vehicleId == null || vehicleId.isEmpty()) {
            return;
        }
        List<String> ammoIds = VehicleAmmoExtractor.getRequiredAmmoSorted(vehicleId);
        if (ammoIds.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> ammoStacks = new ArrayList<ItemStack>();
        for (String ammoIdStr : ammoIds) {
            ResourceLocation ammoLoc = new ResourceLocation(ammoIdStr);
            Item ammoItem = (Item)ForgeRegistries.ITEMS.getValue(ammoLoc);
            if (ammoItem == null) continue;
            ammoStacks.add(new ItemStack((ItemLike)ammoItem));
        }
        if (!ammoStacks.isEmpty()) {
            event.getTooltipElements().add(Either.right((Object)new AmmoTooltipComponent(ammoStacks)));
        }
    }

    public static class AmmoTooltipComponent
    implements TooltipComponent {
        private final List<ItemStack> ammoStacks;

        public AmmoTooltipComponent(List<ItemStack> ammoStacks) {
            this.ammoStacks = ammoStacks;
        }

        public List<ItemStack> getAmmoStacks() {
            return this.ammoStacks;
        }
    }
}

