/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp.client.debug;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4d;
import org.joml.Vector4d;

@OnlyIn(value=Dist.CLIENT)
public class VehiclePivotDebugRenderer {
    public static boolean enabled = false;
    private static final float BOX_SIZE = 0.1f;

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (!enabled) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        Vec3 camPos = event.getCamera().m_90583_();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        poseStack.m_85836_();
        poseStack.m_85837_(-camPos.f_82479_, -camPos.f_82480_, -camPos.f_82481_);
        for (Entity entity : mc.f_91073_.m_104735_()) {
            if (!(entity instanceof VehicleEntity)) continue;
            VehicleEntity vehicle = (VehicleEntity)entity;
            VehiclePivotDebugRenderer.renderVehiclePivots(vehicle, poseStack, (MultiBufferSource)buffer, event.getPartialTick());
        }
        poseStack.m_85849_();
        buffer.m_109911_();
    }

    private static void renderVehiclePivots(VehicleEntity vehicle, PoseStack poseStack, MultiBufferSource buffer, float partialTick) {
        VertexConsumer lines = buffer.m_6299_(RenderType.m_110504_());
        VehiclePivotDebugRenderer.renderPivotBox(poseStack, lines, vehicle.m_20182_(), 1.0f, 1.0f, 1.0f);
        Vec3 turretWorld = VehiclePivotDebugRenderer.getTransformedPos(vehicle.getTurretTransform(partialTick));
        VehiclePivotDebugRenderer.renderPivotBox(poseStack, lines, turretWorld, 1.0f, 0.0f, 0.0f);
        Vec3 barrelWorld = VehiclePivotDebugRenderer.getTransformedPos(vehicle.getBarrelTransform(partialTick));
        VehiclePivotDebugRenderer.renderPivotBox(poseStack, lines, barrelWorld, 1.0f, 0.5f, 0.0f);
        if (vehicle.hasPassengerWeaponStation()) {
            Vec3 gunWorld = VehiclePivotDebugRenderer.getTransformedPos(vehicle.getGunTransform(partialTick));
            VehiclePivotDebugRenderer.renderPivotBox(poseStack, lines, gunWorld, 0.0f, 1.0f, 0.0f);
            Vec3 vec3 = VehiclePivotDebugRenderer.getTransformedPos(vehicle.getPassengerWeaponStationBarrelTransform(partialTick));
            VehiclePivotDebugRenderer.renderPivotBox(poseStack, lines, vec3, 0.0f, 1.0f, 1.0f);
        }
        for (Map.Entry entry : vehicle.getGunDataMap().entrySet()) {
            GunData gunData = (GunData)entry.getValue();
            if (gunData == null) continue;
            Vec3 shootPos = vehicle.getShootPos((String)entry.getKey(), partialTick);
            VehiclePivotDebugRenderer.renderPivotBox(poseStack, lines, shootPos, 1.0f, 0.0f, 1.0f);
        }
        List terrainCompat = vehicle.data().compute().terrainCompat;
        if (terrainCompat != null) {
            Matrix4d matrix4d = vehicle.getVehicleTransform(partialTick);
            for (Vec3 localPos : terrainCompat) {
                Vec3 worldPos = VehiclePivotDebugRenderer.transformLocalToWorld(matrix4d, localPos);
                VehiclePivotDebugRenderer.renderPivotBox(poseStack, lines, worldPos, 1.0f, 1.0f, 0.0f);
            }
        }
    }

    private static Vec3 transformLocalToWorld(Matrix4d transform, Vec3 localPos) {
        Vector4d pos = new Vector4d(localPos.f_82479_, localPos.f_82480_, localPos.f_82481_, 1.0);
        transform.transform(pos);
        return new Vec3(pos.x, pos.y, pos.z);
    }

    private static Vec3 getTransformedPos(Matrix4d transform) {
        Vector4d pos = new Vector4d(0.0, 0.0, 0.0, 1.0);
        transform.transform(pos);
        return new Vec3(pos.x, pos.y, pos.z);
    }

    private static void renderPivotBox(PoseStack poseStack, VertexConsumer consumer, Vec3 pos, float r, float g, float b) {
        AABB box = new AABB(pos.f_82479_ - (double)0.1f, pos.f_82480_ - (double)0.1f, pos.f_82481_ - (double)0.1f, pos.f_82479_ + (double)0.1f, pos.f_82480_ + (double)0.1f, pos.f_82481_ + (double)0.1f);
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)box, (float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void toggle() {
        enabled = !enabled;
    }
}

