/*
 * Decompiled with CFR 0.152.
 */
package tech.mcsp.mcsp;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import tech.mcsp.mcsp.command.DebugPivotCommand;
import tech.mcsp.mcsp.data.OESData;
import tech.mcsp.mcsp.init.MCSPMenuTypes;
import tech.mcsp.mcsp.init.ModEntities;
import tech.mcsp.mcsp.init.ModItems;
import tech.mcsp.mcsp.init.ModSounds;
import tech.mcsp.mcsp.init.ModTabs;
import tech.mcsp.mcsp.init.ModVehicleItems;
import tech.mcsp.mcsp.network.MCSPNetwork;

@Mod(value="mcsp")
public class MCSP {
    public static final String MOD_ID = "mcsp";
    public static final String MODID = "mcsp";
    private static final Logger LOGGER = LogUtils.getLogger();

    public MCSP() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModEntities.REGISTRY.register(modEventBus);
        ModItems.register(modEventBus);
        ModVehicleItems.register(modEventBus);
        ModTabs.TABS.register(modEventBus);
        ModSounds.REGISTRY.register(modEventBus);
        MCSPMenuTypes.REGISTRY.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onItemTooltip);
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
        MinecraftForge.EVENT_BUS.addListener(this::onAddReloadListeners);
    }

    private void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new OESData.Loader());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(MCSPNetwork::register);
    }

    private void onRegisterCommands(RegisterCommandsEvent event) {
        DebugPivotCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private void onItemTooltip(ItemTooltipEvent event) {
        String entityType;
        CompoundTag tag;
        if (event.getItemStack().m_41720_() instanceof BlockItem && event.getItemStack().m_41782_() && (tag = BlockItem.m_186336_((ItemStack)event.getItemStack())) != null && tag.m_128441_("EntityType") && (entityType = tag.m_128461_("EntityType")).startsWith("mcsp:vdv_")) {
            event.getToolTip().add(Component.m_237115_((String)"tooltip.mcsp.usage_restriction").m_130940_(ChatFormatting.RED));
        }
    }
}

