/*
 * Decompiled with CFR 0.152.
 */
package Aru.Aru.ashvehicle.init.client;

import Aru.Aru.ashvehicle.entity.vehicle.GepardEntity;
import Aru.Aru.ashvehicle.entity.vehicle.ZumwaltEntity;
import Aru.Aru.ashvehicle.init.ModEntities;
import Aru.Aru.ashvehicle.init.client.ClientTargetingData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="ashvehicle", value={Dist.CLIENT})
public class ClientEntityHighlighter {
    private static final float BULLET_SPEED = 35.0f;
    private static final double DETECTION_RANGE = 1028.0;
    private static final double MIN_Z_THRESHOLD = 0.01;
    private static final double EPSILON = 1.0E-6;
    private static final int STEALTH_SIZE = 6;
    private static final int NORMAL_SIZE = 10;
    private static final int LOCKED_COLOR = -256;
    private static final int UNLOCKED_COLOR = -16711936;
    private static final int INTERCEPT_COLOR = -65536;
    private static final float INTERCEPT_ROTATION = 35.0f;
    private static final int MAX_TARGETS = 4;
    private static Set<EntityType<?>> excludedTypes = null;
    private static Set<EntityType<?>> stealthTypes = null;
    private static final Set<String> ALLOWED_NAMESPACES = Set.of("superbwarfare", "ashvehicle", "vvp");
    private static Vec3 cachedShooterPos = Vec3.f_82478_;
    private static double cachedFovScale = 0.0;
    private static int cachedScreenWidth = 0;
    private static int cachedScreenHeight = 0;
    private static final List<TargetCache> targetCaches = new ArrayList<TargetCache>(4);

    private static void ensureInitialized() {
        if (excludedTypes == null) {
            excludedTypes = Set.of((EntityType)com.atsuishio.superbwarfare.init.ModEntities.SMALL_CANNON_SHELL.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.SMALL_ROCKET.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.CANNON_SHELL.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.GUN_GRENADE.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.PROJECTILE.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.AGM_65.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.JAVELIN_MISSILE.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.HAND_GRENADE.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.RGO_GRENADE.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.MELON_BOMB.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.MORTAR_SHELL.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.MORTAR.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.LASER.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.FLARE_DECOY.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.SMOKE_DECOY.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.CLAYMORE.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.BLU_43.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.TM_62.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.TASER_BULLET.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.MK_82.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.MK_42.get());
        }
        if (stealthTypes == null) {
            stealthTypes = Set.of((EntityType)ModEntities.F_35.get(), (EntityType)ModEntities.B_2.get(), (EntityType)ModEntities.F_22.get(), (EntityType)ModEntities.F_117.get(), (EntityType)ModEntities.SU_57.get());
        }
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        ClientEntityHighlighter.ensureInitialized();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        Entity vehicle = player.m_20202_();
        if (vehicle == null) {
            return;
        }
        if (!ClientEntityHighlighter.isAllowedVehicle(vehicle)) {
            return;
        }
        List<Entity> lockedTargets = ClientTargetingData.getLockedTargets();
        cachedScreenWidth = mc.m_91268_().m_85445_();
        cachedScreenHeight = mc.m_91268_().m_85446_();
        float fov = ((Integer)mc.f_91066_.m_231837_().m_231551_()).intValue();
        double fovRad = Math.toRadians(fov);
        cachedFovScale = (double)cachedScreenHeight / (2.0 * Math.tan(fovRad / 2.0));
        cachedShooterPos = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
        Camera camera = mc.f_91063_.m_109153_();
        CameraTransform camTransform = new CameraTransform(camera);
        AABB searchBox = player.m_20191_().m_82400_(1028.0);
        EntityType playerType = player.m_6095_();
        int validCount = 0;
        for (TargetCache cache : targetCaches) {
            cache.reset();
        }
        for (Entity e : vehicle.m_9236_().m_6249_((Entity)player, searchBox, arg_0 -> ClientEntityHighlighter.lambda$onRenderGuiOverlay$0((Player)player, vehicle, playerType, arg_0))) {
            int i;
            double distSq = e.m_20280_((Entity)player);
            int insertPos = -1;
            for (i = 0; i < 4; ++i) {
                if (ClientEntityHighlighter.targetCaches.get((int)i).entity == null) {
                    insertPos = i;
                    break;
                }
                if (!(distSq < ClientEntityHighlighter.targetCaches.get((int)i).distanceSq)) continue;
                insertPos = i;
                break;
            }
            if (insertPos == -1) continue;
            for (i = 3; i > insertPos; --i) {
                TargetCache current = targetCaches.get(i);
                TargetCache prev = targetCaches.get(i - 1);
                current.entity = prev.entity;
                current.distanceSq = prev.distanceSq;
            }
            TargetCache cache = targetCaches.get(insertPos);
            cache.entity = e;
            cache.distanceSq = distSq;
            if (insertPos < validCount) continue;
            validCount = insertPos + 1;
        }
        if (validCount == 0) {
            return;
        }
        for (int i = 0; i < validCount; ++i) {
            TargetCache cache;
            cache = targetCaches.get(i);
            Entity target = cache.entity;
            cache.isStealth = stealthTypes.contains(target.m_6095_());
            cache.isLocked = lockedTargets.contains(target);
            cache.size = cache.isStealth ? 6 : 10;
            Vec3 targetPos = target.m_20191_().m_82399_();
            cache.screenPos = ClientEntityHighlighter.worldToScreenOptimized(targetPos, camTransform);
            if (cache.screenPos == null) continue;
            Vec3 targetVelocity = target.m_20184_();
            Vec3 interceptPoint = ClientEntityHighlighter.calculateInterceptPointOptimized(cachedShooterPos, targetPos, targetVelocity);
            cache.interceptScreenPos = ClientEntityHighlighter.worldToScreenOptimized(interceptPoint, camTransform);
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        for (int i = 0; i < validCount; ++i) {
            TargetCache cache = targetCaches.get(i);
            if (cache.screenPos == null) continue;
            int color = cache.isLocked ? -256 : -16711936;
            ClientEntityHighlighter.drawRectFrame(guiGraphics, (int)cache.screenPos.f_82479_, (int)cache.screenPos.f_82480_, cache.size, color);
            if (cache.interceptScreenPos == null) continue;
            int interceptSize = cache.size - 2;
            ClientEntityHighlighter.drawRectFrameRotated(guiGraphics, poseStack, (int)cache.interceptScreenPos.f_82479_, (int)cache.interceptScreenPos.f_82480_, interceptSize, 35.0f, -65536);
        }
        poseStack.m_85849_();
        RenderSystem.disableBlend();
    }

    private static boolean isAllowedVehicle(Entity vehicle) {
        return vehicle instanceof GepardEntity || vehicle instanceof ZumwaltEntity;
    }

    private static boolean isValidTarget(Entity e, Player player, Entity vehicle, EntityType<?> playerType) {
        if (e == player || e == vehicle || !e.m_6084_()) {
            return false;
        }
        EntityType type = e.m_6095_();
        if (type == playerType || excludedTypes.contains(type)) {
            return false;
        }
        ResourceLocation rl = ForgeRegistries.ENTITY_TYPES.getKey((Object)type);
        return rl != null && ALLOWED_NAMESPACES.contains(rl.m_135827_());
    }

    private static void drawRectFrameRotated(GuiGraphics guiGraphics, PoseStack poseStack, int centerX, int centerY, int size, float angleDegrees, int color) {
        poseStack.m_85836_();
        poseStack.m_252880_((float)centerX, (float)centerY, 0.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(angleDegrees));
        poseStack.m_252880_((float)(-centerX), (float)(-centerY), 0.0f);
        int half = size >> 1;
        int left = centerX - half;
        int top = centerY - half;
        int right = centerX + half;
        int bottom = centerY + half;
        guiGraphics.m_280509_(left, top, right, top + 1, color);
        guiGraphics.m_280509_(left, bottom - 1, right, bottom, color);
        guiGraphics.m_280509_(left, top, left + 1, bottom, color);
        guiGraphics.m_280509_(right - 1, top, right, bottom, color);
        poseStack.m_85849_();
    }

    private static void drawRectFrame(GuiGraphics guiGraphics, int centerX, int centerY, int size, int color) {
        int half = size >> 1;
        int left = centerX - half;
        int top = centerY - half;
        int right = centerX + half;
        int bottom = centerY + half;
        guiGraphics.m_280509_(left, top, right, top + 1, color);
        guiGraphics.m_280509_(left, bottom - 1, right, bottom, color);
        guiGraphics.m_280509_(left, top, left + 1, bottom, color);
        guiGraphics.m_280509_(right - 1, top, right, bottom, color);
    }

    private static Vec3 worldToScreenOptimized(Vec3 worldPos, CameraTransform cam) {
        double dx = worldPos.f_82479_ - cam.camPos.f_82479_;
        double dy = worldPos.f_82480_ - cam.camPos.f_82480_;
        double dz = worldPos.f_82481_ - cam.camPos.f_82481_;
        double x2 = cam.cosYaw * dx - cam.sinYaw * dz;
        double z2 = cam.sinYaw * dx + cam.cosYaw * dz;
        double y2 = cam.cosPitch * dy - cam.sinPitch * z2;
        double z3 = cam.sinPitch * dy + cam.cosPitch * z2;
        if (z3 <= 0.01) {
            return null;
        }
        double screenX = (double)cachedScreenWidth * 0.5 - x2 * cachedFovScale / z3;
        double screenY = (double)cachedScreenHeight * 0.5 - y2 * cachedFovScale / z3;
        if (screenX < 0.0 || screenX >= (double)cachedScreenWidth || screenY < 0.0 || screenY >= (double)cachedScreenHeight) {
            return null;
        }
        return new Vec3(screenX, screenY, 0.0);
    }

    public static Vec3 calculateInterceptPointOptimized(Vec3 shooterPos, Vec3 targetPos, Vec3 targetVel) {
        double t;
        double dx = targetPos.f_82479_ - shooterPos.f_82479_;
        double dy = targetPos.f_82480_ - shooterPos.f_82480_;
        double dz = targetPos.f_82481_ - shooterPos.f_82481_;
        double vx = targetVel.f_82479_;
        double vy = targetVel.f_82480_;
        double vz = targetVel.f_82481_;
        double vDotV = vx * vx + vy * vy + vz * vz;
        double bulletSpeedSq = 1225.0;
        double a = vDotV - bulletSpeedSq;
        if (Math.abs(a) < 1.0E-6) {
            return targetPos;
        }
        double dDotV = dx * vx + dy * vy + dz * vz;
        double b = 2.0 * dDotV;
        double c = dx * dx + dy * dy + dz * dz;
        double discriminant = b * b - 4.0 * a * c;
        if (discriminant < 0.0) {
            return targetPos;
        }
        double sqrtDisc = Math.sqrt(discriminant);
        double invA2 = 0.5 / a;
        double t1 = (-b - sqrtDisc) * invA2;
        double t2 = (-b + sqrtDisc) * invA2;
        double d = t = t1 >= 0.0 ? t1 : t2;
        if (t < 0.0) {
            return targetPos;
        }
        return new Vec3(targetPos.f_82479_ + vx * t, targetPos.f_82480_ + vy * t, targetPos.f_82481_ + vz * t);
    }

    private static /* synthetic */ boolean lambda$onRenderGuiOverlay$0(Player player, Entity vehicle, EntityType playerType, Entity entity) {
        return ClientEntityHighlighter.isValidTarget(entity, player, vehicle, playerType);
    }

    static {
        for (int i = 0; i < 4; ++i) {
            targetCaches.add(new TargetCache());
        }
    }

    private static class CameraTransform {
        final Vec3 camPos;
        final double cosYaw;
        final double sinYaw;
        final double cosPitch;
        final double sinPitch;

        CameraTransform(Camera camera) {
            this.camPos = camera.m_90583_();
            double yaw = Math.toRadians(-camera.m_90590_());
            double pitch = Math.toRadians(-camera.m_90589_());
            this.cosYaw = Math.cos(yaw);
            this.sinYaw = Math.sin(yaw);
            this.cosPitch = Math.cos(pitch);
            this.sinPitch = Math.sin(pitch);
        }
    }

    private static class TargetCache {
        Entity entity;
        double distanceSq;
        Vec3 screenPos;
        Vec3 interceptScreenPos;
        boolean isStealth;
        boolean isLocked;
        int size;

        private TargetCache() {
        }

        void reset() {
            this.entity = null;
            this.screenPos = null;
            this.interceptScreenPos = null;
        }
    }
}

