/*
 * Decompiled with CFR 0.152.
 */
package Aru.Aru.ashvehicle.entity.vehicle;

import Aru.Aru.ashvehicle.entity.projectile.BallisticMissileEntity;
import Aru.Aru.ashvehicle.init.CoordinateTargetVehicle;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4d;
import org.joml.Vector4d;

public class SapsanEntity
extends GeoVehicleEntity
implements CoordinateTargetVehicle {
    private boolean shotToggled = false;
    private static final EntityDataAccessor<Float> POD_ROT = SynchedEntityData.m_135353_(SapsanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> POD_TOGGLED = SynchedEntityData.m_135353_(SapsanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float podRotO = 0.0f;

    public SapsanEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public int m_19879_() {
        return super.m_19879_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(POD_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(POD_TOGGLED, (Object)false);
    }

    public void setPodRot(float value) {
        this.f_19804_.m_135381_(POD_ROT, (Object)Float.valueOf(value));
    }

    public float getPodRot() {
        return ((Float)this.f_19804_.m_135370_(POD_ROT)).floatValue();
    }

    public void setPodToggled(boolean value) {
        this.f_19804_.m_135381_(POD_TOGGLED, (Object)value);
    }

    public boolean getPodToggled() {
        return (Boolean)this.f_19804_.m_135370_(POD_TOGGLED);
    }

    public void togglePod() {
        this.setPodToggled(!this.getPodToggled());
    }

    public void m_6075_() {
        if (this.getPodRot() > 1.0f) {
            this.setForwardInputDown(false);
            this.setBackInputDown(false);
            this.setLeftInputDown(false);
            this.setRightInputDown(false);
        }
        super.m_6075_();
        this.podRotO = this.getPodRot();
        float target = this.getPodToggled() ? 90.0f : 0.0f;
        float current = this.getPodRot();
        float diff = target - current;
        float newRot = current + diff * 0.04f;
        if (Math.abs(diff) < 0.1f) {
            newRot = target;
        }
        this.setPodRot(newRot);
    }

    public void shootMissileTo(Player player, Vec3 targetPos) {
        if (!this.getPodToggled()) {
            return;
        }
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Matrix4d transform = this.getVehicleTransform(1.0f);
        float x = this.shotToggled ? -1.0f : 1.0f;
        float y = 1.0f;
        float z = -10.0f;
        this.shotToggled = !this.shotToggled;
        Vector4d worldPosition = this.transformPos(transform, x, y, z);
        BallisticMissileEntity missile = new BallisticMissileEntity((LivingEntity)player, this.m_9236_());
        missile.m_6034_(worldPosition.x, worldPosition.y, worldPosition.z);
        missile.setTargetPosition(targetPos);
        this.m_9236_().m_7967_((Entity)missile);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123755_, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z, (int)10, (double)0.1, (double)0.1, (double)0.1, (double)0.0, (boolean)false);
        }
    }

    private Vector4d transformPos(Matrix4d transform, double x, double y, double z) {
        Vector4d vec = new Vector4d(x, y, z, 1.0);
        transform.transform(vec);
        return vec;
    }
}

