/*
 * Decompiled with CFR 0.152.
 */
package Aru.Aru.ashvehicle.Packet;

import Aru.Aru.ashvehicle.entity.vehicle.SapsanEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class SetMissileTargetPacket {
    private final int entityId;
    private final double x;
    private final double y;
    private final double z;

    public SetMissileTargetPacket(int entityId, double x, double y, double z) {
        this.entityId = entityId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void encode(SetMissileTargetPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
    }

    public static SetMissileTargetPacket decode(FriendlyByteBuf buf) {
        return new SetMissileTargetPacket(buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void handle(SetMissileTargetPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            Entity entity = level.m_6815_(msg.entityId);
            if (entity instanceof SapsanEntity) {
                SapsanEntity sapsan = (SapsanEntity)entity;
                sapsan.shootMissileTo((Player)player, new Vec3(msg.x, msg.y, msg.z));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

