/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import com.atsuishio.superbwarfare.tools.TagDataParser;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class VehicleAssemblingResult {
    @SerializedName(value="item")
    public String itemString = "";
    @SerializedName(value="entity")
    public String entityTypeString = "";
    @SerializedName(value="count")
    public int count = 1;
    @SerializedName(value="nbt")
    public JsonObject nbt;
    public transient ItemStack result = null;

    public ItemStack getResult() {
        if (this.result != null) {
            return this.result;
        }
        if (!this.entityTypeString.isEmpty()) {
            EntityType type = EntityType.m_20632_((String)this.entityTypeString).orElse(null);
            if (type == null) {
                Mod.LOGGER.warn("invalid entity type: {}", (Object)this.entityTypeString);
                this.result = ItemStack.f_41583_;
            } else {
                this.result = ContainerBlockItem.createInstance(type).m_255036_(this.count);
            }
        } else if (!this.itemString.isEmpty()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.itemString));
            if (item == null) {
                Mod.LOGGER.warn("invalid item: {}", (Object)this.itemString);
                this.result = ItemStack.f_41583_;
            } else if (this.nbt != null) {
                CompoundTag tag = TagDataParser.parse(this.nbt);
                CompoundTag tmp = new CompoundTag();
                if (tag.m_128441_("ForgeCaps")) {
                    tmp.m_128365_("ForgeCaps", tag.m_128423_("ForgeCaps"));
                    tag.m_128473_("ForgeCaps");
                }
                tmp.m_128365_("tag", (Tag)tag);
                tmp.m_128359_("id", this.itemString);
                tmp.m_128405_("Count", this.count);
                this.result = ItemStack.m_41712_((CompoundTag)tmp);
            } else {
                this.result = new ItemStack((ItemLike)item, this.count);
            }
        } else {
            this.result = ItemStack.f_41583_;
        }
        return this.result;
    }
}

