/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe.vehicle;

import com.atsuishio.superbwarfare.data.DataLoader;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingIngredient;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingRecipe;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingRecipeData;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingResult;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleAssemblingRecipeSerializer
implements RecipeSerializer<VehicleAssemblingRecipe> {
    @ParametersAreNonnullByDefault
    @NotNull
    public VehicleAssemblingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
        VehicleAssemblingRecipeData data = (VehicleAssemblingRecipeData)DataLoader.GSON.fromJson((JsonElement)pSerializedRecipe, VehicleAssemblingRecipeData.class);
        return new VehicleAssemblingRecipe(pRecipeId, data);
    }

    @Nullable
    public VehicleAssemblingRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        int count = pBuffer.m_130242_();
        ArrayList<VehicleAssemblingIngredient> ingredients = new ArrayList<VehicleAssemblingIngredient>();
        for (int i = 0; i < count; ++i) {
            VehicleAssemblingIngredient assemblingIngredient = new VehicleAssemblingIngredient();
            assemblingIngredient.ingredientObject = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            assemblingIngredient.count = pBuffer.readInt();
            ingredients.add(assemblingIngredient);
        }
        VehicleAssemblingRecipe.Category category = (VehicleAssemblingRecipe.Category)pBuffer.m_130066_(VehicleAssemblingRecipe.Category.class);
        ItemStack resultItem = pBuffer.m_130267_();
        VehicleAssemblingResult result = new VehicleAssemblingResult();
        result.result = resultItem;
        return new VehicleAssemblingRecipe(pRecipeId, category, result, ingredients);
    }

    public void toNetwork(FriendlyByteBuf pBuffer, VehicleAssemblingRecipe pRecipe) {
        pBuffer.m_130130_(pRecipe.getInputs().size());
        for (VehicleAssemblingIngredient ingredient : pRecipe.getInputs()) {
            ingredient.getIngredient().m_43923_(pBuffer);
            pBuffer.writeInt(ingredient.count);
        }
        pBuffer.m_130068_((Enum)pRecipe.getCategory());
        pBuffer.m_130055_(pRecipe.getResult().getResult());
    }
}

