/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SensitivityMessage {
    private final boolean add;

    public SensitivityMessage(boolean add) {
        this.add = add;
    }

    public static void encode(SensitivityMessage message, FriendlyByteBuf byteBuf) {
        byteBuf.writeBoolean(message.add);
    }

    public static SensitivityMessage decode(FriendlyByteBuf byteBuf) {
        return new SensitivityMessage(byteBuf.readBoolean());
    }

    public static void handler(SensitivityMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21205_();
            if (!(stack.m_41720_() instanceof GunItem)) {
                return;
            }
            GunData data = GunData.from(stack);
            if (message.add) {
                data.sensitivity.set(Math.min(10, data.sensitivity.get() + 1));
            } else {
                data.sensitivity.set(Math.max(-10, data.sensitivity.get() - 1));
            }
            data.save();
            player.m_5661_((Component)Component.m_237110_((String)"tips.superbwarfare.sensitivity", (Object[])new Object[]{data.sensitivity.get()}), true);
        });
        context.get().setPacketHandled(true);
    }
}

