/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.data.gun.FireModeInfo;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkEvent;

public record FireModeMessage(boolean forward) {
    public static void encode(FireModeMessage message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.forward());
    }

    public static FireModeMessage decode(FriendlyByteBuf buffer) {
        return new FireModeMessage(buffer.readBoolean());
    }

    public static void handler(FireModeMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21205_();
            if (!(stack.m_41720_() instanceof GunItem)) {
                return;
            }
            GunData data = GunData.from(stack);
            int selectedFireMode = data.selectedFireMode.get();
            List<FireModeInfo> fireModes = data.compute().availableFireModes();
            if (fireModes.size() > 1) {
                int mode = (selectedFireMode + (message.forward() ? -1 : 1) + fireModes.size()) % fireModes.size();
                data.selectedFireMode.set(mode);
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.FIRE_RATE.get());
                return;
            }
            if (!(stack.m_41720_() != ModItems.SENTINEL.get() || player.m_5833_() || player.m_36335_().m_41519_(stack.m_41720_()) || GunData.from((ItemStack)stack).reload.time() != 0 || GunData.from(stack).charging())) {
                for (ItemStack cell : player.m_150109_().f_35974_) {
                    if (!cell.m_150930_((Item)ModItems.CELL.get())) continue;
                    boolean[] flag = new boolean[]{false};
                    cell.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> {
                        flag[0] = iEnergyStorage.getEnergyStored() >= 0;
                    });
                    if (!flag[0]) continue;
                    data.charge.starter.markStart();
                }
            }
            if (stack.m_41720_() == ModItems.JAVELIN.get()) {
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.CANNON_ZOOM_OUT.get());
            }
            data.save();
        });
        context.setPacketHandled(true);
    }
}

