/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.menu;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.dataslot.ContainerEnergyData;
import com.atsuishio.superbwarfare.network.dataslot.ContainerEnergyDataSlot;
import com.atsuishio.superbwarfare.network.message.receive.ContainerDataMessage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public abstract class EnergyMenu
extends AbstractContainerMenu {
    private final List<ContainerEnergyDataSlot> containerEnergyDataSlots = Lists.newArrayList();
    private final List<ServerPlayer> usingPlayers = new ArrayList<ServerPlayer>();

    public EnergyMenu(@Nullable MenuType<?> pMenuType, int pContainerId) {
        super(pMenuType, pContainerId);
    }

    public EnergyMenu(@Nullable MenuType<?> pMenuType, int id, ContainerEnergyData containerData) {
        super(pMenuType, id);
        for (int i = 0; i < containerData.getCount(); ++i) {
            this.containerEnergyDataSlots.add(ContainerEnergyDataSlot.forContainer(containerData, i));
        }
    }

    public void m_38946_() {
        ArrayList<ContainerDataMessage.Pair> pairs = new ArrayList<ContainerDataMessage.Pair>();
        for (int i = 0; i < this.containerEnergyDataSlots.size(); ++i) {
            ContainerEnergyDataSlot dataSlot = this.containerEnergyDataSlots.get(i);
            if (!dataSlot.checkAndClearUpdateFlag()) continue;
            pairs.add(new ContainerDataMessage.Pair(i, dataSlot.get()));
        }
        if (!pairs.isEmpty()) {
            PacketDistributor.PacketTarget target = PacketDistributor.NMLIST.with(this.usingPlayers.stream().map(serverPlayer -> serverPlayer.f_8906_.f_9742_)::toList);
            NetworkRegistry.PACKET_HANDLER.send(target, (Object)new ContainerDataMessage(this.f_38840_, pairs));
        }
        super.m_38946_();
    }

    public void m_7511_(int id, int data) {
        if (id < 0 || id >= this.containerEnergyDataSlots.size()) {
            Mod.LOGGER.error("EnergyMenu.setData id out of bounds: {}", (Object)id);
            return;
        }
        this.containerEnergyDataSlots.get(id).set(data);
    }

    public void setData(int id, long data) {
        if (id < 0 || id >= this.containerEnergyDataSlots.size()) {
            Mod.LOGGER.error("EnergyMenu.setData id out of bounds: {}", (Object)id);
            return;
        }
        this.containerEnergyDataSlots.get(id).set(data);
    }

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof EnergyMenu) {
            EnergyMenu menu = (EnergyMenu)abstractContainerMenu;
            abstractContainerMenu = event.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                menu.usingPlayers.add(serverPlayer);
                ArrayList<ContainerDataMessage.Pair> toSync = new ArrayList<ContainerDataMessage.Pair>();
                for (int i = 0; i < menu.containerEnergyDataSlots.size(); ++i) {
                    toSync.add(new ContainerDataMessage.Pair(i, menu.containerEnergyDataSlots.get(i).get()));
                }
                NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ContainerDataMessage(menu.f_38840_, toSync));
            }
        }
    }

    @SubscribeEvent
    public static void onContainerClosed(PlayerContainerEvent.Close event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof EnergyMenu) {
            EnergyMenu menu = (EnergyMenu)abstractContainerMenu;
            abstractContainerMenu = event.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                menu.usingPlayers.remove(serverPlayer);
            }
        }
    }
}

