/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.vehicle;

import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.PrismTankEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.world.phys.EntityResult;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleGun
extends GunItem {
    public VehicleGun() {
        super(new Item.Properties());
    }

    @Override
    public DefaultGunData computeProperties(GunData gunData, DefaultGunData rawData) {
        rawData.autoReload = true;
        if (rawData.shootShake == null) {
            rawData.shootShake = new Vec3(5.0, 6.0, 9.0);
        }
        return rawData;
    }

    @Override
    public void init(GunData data) {
    }

    @Override
    public boolean isInitialized(GunData data) {
        return true;
    }

    @Override
    public boolean enableShootTimer() {
        return true;
    }

    @Override
    public boolean canShoot(GunData data, @Nullable Entity shooter) {
        if (shooter instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)shooter;
            return data.compute().projectileAmount > 0 && !data.overHeat.get() && data.compute().heatPerShoot <= 100.0 + data.compute().heatPerShoot - data.heat.get() && !data.reloading() && !data.charging() && !data.bolt.needed.get() && vehicle.getAmmo(data) >= data.compute().ammoCostPerShoot;
        }
        return false;
    }

    @Override
    public LazyOptional<IEnergyStorage> getEnergyProvider(@NotNull GunData data, @Nullable Entity ammoSupplier) {
        if (ammoSupplier != null) {
            return ammoSupplier.getCapability(ForgeCapabilities.ENERGY, null);
        }
        return super.getEnergyProvider(data, null);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"des.superbwarfare.vehicle_gun").m_130940_(ChatFormatting.RED));
    }

    @Override
    public void onRayHitEntity(Entity shooter, ServerLevel level, @NotNull GunData data, EntityResult result, Vec3 shootPosition, Vec3 shootDirection) {
        super.onRayHitEntity(shooter, level, data, result, shootPosition, shootDirection);
        Entity entity = shooter.m_20202_();
        if (entity instanceof PrismTankEntity) {
            PrismTankEntity prismTank = (PrismTankEntity)entity;
            Vec3 root = prismTank.getShootPos(shooter, 1.0f);
            prismTank.m_20088_().m_135381_(PrismTankEntity.LASER_LENGTH, (Object)Float.valueOf((float)root.m_82554_(result.getHitPos())));
            prismTank.hitEntity(result.getHitPos(), data, shooter);
            prismTank.m_20088_().m_135381_(PrismTankEntity.LASER_SCALE, (Object)Float.valueOf(data.compute().shootAnimationTime));
        }
    }

    @Override
    public void onRayHitBlock(Entity shooter, ServerLevel level, @Nullable Entity target, @NotNull GunData data, Vec3 shootDirection, BlockHitResult result, @NotNull Vec3 pos) {
        super.onRayHitBlock(shooter, level, target, data, shootDirection, result, pos);
        Entity entity = shooter.m_20202_();
        if (entity instanceof PrismTankEntity) {
            PrismTankEntity prismTank = (PrismTankEntity)entity;
            Vec3 root = prismTank.getShootPos(shooter, 1.0f);
            prismTank.m_20088_().m_135381_(PrismTankEntity.LASER_LENGTH, (Object)Float.valueOf((float)root.m_82554_(result.m_82450_())));
            prismTank.hitBlock(result.m_82450_(), data, shooter);
            prismTank.m_20088_().m_135381_(PrismTankEntity.LASER_SCALE, (Object)Float.valueOf(data.compute().shootAnimationTime));
        }
    }
}

