/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.sniper;

import com.atsuishio.superbwarfare.client.TooltipTool;
import com.atsuishio.superbwarfare.client.renderer.gun.Ql1031ItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ShootParameters;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModRarities;
import com.atsuishio.superbwarfare.item.BatteryItem;
import com.atsuishio.superbwarfare.item.gun.GunGeoItem;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.GunsTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class Ql1031Item
extends GunGeoItem {
    public Ql1031Item() {
        super(new Item.Properties().m_41497_(ModRarities.LEGENDARY));
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return Ql1031ItemRenderer::new;
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.m_237119_());
        list.add((Component)Component.m_237115_((String)"des.superbwarfare.ql_1031_1").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        TooltipTool.addHideText(list, (Component)Component.m_237119_());
        TooltipTool.addHideText(list, (Component)Component.m_237115_((String)"des.superbwarfare.trachelium_3").m_130940_(ChatFormatting.WHITE));
        TooltipTool.addHideText(list, (Component)Component.m_237115_((String)"des.superbwarfare.ql_1031_2").m_130948_(Style.f_131099_.m_178520_(16772327)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private PlayState editPredicate(AnimationState<Ql1031Item> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ql_1031.idle"));
        }
        if (ClientEventHandler.isEditing) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.ql_1031.edit"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ql_1031.idle"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private PlayState chargePredicate(AnimationState<Ql1031Item> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof GunItem)) {
            return PlayState.STOP;
        }
        GunItem gunItem = (GunItem)item;
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ql_1031.idle"));
        }
        GunData data = GunData.from(stack);
        if (ClientEventHandler.holdingFireKey && gunItem.canShoot(data, (Entity)player) && data.selectedFireModeInfo().name.equals("Hold")) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ql_1031.charge"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ql_1031.idle"));
    }

    @Override
    public void afterShoot(@NotNull ShootParameters parameters) {
        super.afterShoot(parameters);
        GunData data = parameters.data();
        ServerLevel level = parameters.level();
        Vec3 shootPosition = parameters.shootPosition();
        Vec3 shootDirection = parameters.shootDirection();
        if (data.selectedFireModeInfo().name.equals("Hold")) {
            for (int i = 0; i < 40; i += 2) {
                Vec3 pos = shootPosition.m_82549_(shootDirection.m_82541_().m_82490_(1.0 + 0.5 * (double)i + 0.05 * (double)i * (double)i));
                ParticleTool.sendParticle(level, ParticleTypes.f_276452_, pos.f_82479_, pos.f_82480_ - 0.12, pos.f_82481_, 1, 0.04, 0.04, 0.04, 1.0, false);
            }
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController editController = new AnimationController((GeoAnimatable)this, "editController", 1, this::editPredicate);
        AnimationController chargeController = new AnimationController((GeoAnimatable)this, "chargeController", 1, this::chargePredicate);
        data.add(new AnimationController[]{editController});
        data.add(new AnimationController[]{chargeController});
    }

    @Override
    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack cell : player.m_150109_().f_35974_) {
                if (!(cell.m_41720_() instanceof BatteryItem)) continue;
                assert (stack.getCapability(ForgeCapabilities.ENERGY).resolve().isPresent());
                IEnergyStorage stackStorage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).resolve().get();
                int stackMaxEnergy = stackStorage.getMaxEnergyStored();
                int stackEnergy = stackStorage.getEnergyStored();
                assert (cell.getCapability(ForgeCapabilities.ENERGY).resolve().isPresent());
                IEnergyStorage cellStorage = (IEnergyStorage)cell.getCapability(ForgeCapabilities.ENERGY).resolve().get();
                int cellEnergy = cellStorage.getEnergyStored();
                int stackEnergyNeed = Math.min(cellEnergy, stackMaxEnergy - stackEnergy);
                if (cellEnergy > 0) {
                    stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> iEnergyStorage.receiveEnergy(stackEnergyNeed, false));
                }
                cell.getCapability(ForgeCapabilities.ENERGY).ifPresent(cEnergy -> cEnergy.extractEnergy(stackEnergyNeed, false));
            }
        }
    }

    @Override
    public boolean canSwitchScope(GunData data) {
        return data.attachment.get(AttachmentType.SCOPE) == 2;
    }

    @Override
    public double getCustomZoom(GunData data) {
        int scopeType = data.attachment.get(AttachmentType.SCOPE);
        return switch (scopeType) {
            case 2 -> {
                if (data.stack.m_41784_().m_128471_("ScopeAlt")) {
                    yield 0.0;
                }
                yield 2.75;
            }
            case 3 -> GunsTool.getGunDoubleTag(data.stack, "CustomZoom");
            default -> 0.0;
        };
    }

    @Override
    public boolean canAdjustZoom(GunData data) {
        return data.attachment.get(AttachmentType.SCOPE) == 3;
    }

    @Override
    public boolean hasBulletInBarrel(GunData data) {
        return true;
    }

    @Override
    public boolean hasCustomBarrel(GunData data) {
        return true;
    }

    @Override
    public boolean hasCustomGrip(GunData data) {
        return true;
    }

    @Override
    public boolean hasCustomScope(GunData data) {
        return true;
    }

    @Override
    public boolean hasCustomStock(GunData data) {
        return true;
    }

    @Override
    public boolean canEditAttachments(GunData data) {
        return true;
    }
}

