/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.rifle;

import com.atsuishio.superbwarfare.client.renderer.gun.M4ItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.item.gun.GunGeoItem;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.GunsTool;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class M4Item
extends GunGeoItem {
    public M4Item() {
        super(new Item.Properties().m_41497_(Rarity.RARE));
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return M4ItemRenderer::new;
    }

    private PlayState idlePredicate(AnimationState<M4Item> event) {
        boolean grip;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_4.idle"));
        }
        boolean drum = GunData.from((ItemStack)stack).attachment.get(AttachmentType.MAGAZINE) == 2;
        boolean bl = grip = GunData.from((ItemStack)stack).attachment.get(AttachmentType.GRIP) == 1 || GunData.from((ItemStack)stack).attachment.get(AttachmentType.GRIP) == 2;
        if (GunData.from((ItemStack)stack).reload.empty()) {
            if (drum) {
                if (grip) {
                    return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_4.reload_empty_drum_grip"));
                }
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_4.reload_empty_drum"));
            }
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_4.reload_empty_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_4.reload_empty"));
        }
        if (GunData.from((ItemStack)stack).reload.normal()) {
            if (drum) {
                if (grip) {
                    return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_4.reload_normal_drum_grip"));
                }
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_4.reload_normal_drum"));
            }
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_4.reload_normal_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_4.reload_normal"));
        }
        if (grip) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_4.idle_grip"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_4.idle"));
    }

    private PlayState editPredicate(AnimationState<M4Item> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_4.idle"));
        }
        if (ClientEventHandler.isEditing) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_4.edit"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_4.idle"));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 3, this::idlePredicate);
        data.add(new AnimationController[]{idleController});
        AnimationController editController = new AnimationController((GeoAnimatable)this, "editController", 1, this::editPredicate);
        data.add(new AnimationController[]{editController});
    }

    @Override
    public boolean canSwitchScope(GunData data) {
        return data.attachment.get(AttachmentType.SCOPE) == 2;
    }

    @Override
    public int getCustomMagazine(GunData data) {
        int magType = data.attachment.get(AttachmentType.MAGAZINE);
        return switch (magType) {
            case 1 -> 15;
            case 2 -> 30;
            default -> 0;
        };
    }

    @Override
    public double getCustomZoom(GunData data) {
        int scopeType = data.attachment.get(AttachmentType.SCOPE);
        return switch (scopeType) {
            case 2 -> {
                if (data.stack.m_41784_().m_128471_("ScopeAlt")) {
                    yield 0.0;
                }
                yield 2.75;
            }
            case 3 -> GunsTool.getGunDoubleTag(data.stack, "CustomZoom");
            default -> 0.0;
        };
    }

    @Override
    public boolean canAdjustZoom(GunData data) {
        return data.attachment.get(AttachmentType.SCOPE) == 3;
    }

    @Override
    public boolean isOpenBolt(GunData data) {
        return true;
    }

    @Override
    public boolean hasBulletInBarrel(GunData data) {
        return true;
    }

    @Override
    public boolean hasCustomBarrel(GunData data) {
        return true;
    }

    @Override
    public boolean hasCustomGrip(GunData data) {
        return true;
    }

    @Override
    public boolean hasCustomMagazine(GunData data) {
        return true;
    }

    @Override
    public boolean hasCustomScope(GunData data) {
        return true;
    }

    @Override
    public boolean hasCustomStock(GunData data) {
        return true;
    }

    @Override
    public boolean canEditAttachments(GunData data) {
        return true;
    }
}

