/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.launcher;

import com.atsuishio.superbwarfare.client.renderer.gun.IglaItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ShootParameters;
import com.atsuishio.superbwarfare.entity.projectile.IglaMissileEntity;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunGeoItem;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ShootClientMessage;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class IglaItem
extends GunGeoItem {
    public IglaItem() {
        super(new Item.Properties().m_41497_(Rarity.EPIC));
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return IglaItemRenderer::new;
    }

    @Override
    public boolean useSpecialFireProcedure(GunData data) {
        return true;
    }

    @Override
    public void shoot(@NotNull ShootParameters parameters) {
        GunData data = parameters.data();
        Entity shooter = parameters.shooter();
        UUID targetUUID = parameters.targetEntityUUID();
        boolean zoom = parameters.zoom();
        if (shooter == null) {
            return;
        }
        if (!zoom || !data.hasEnoughAmmoToShoot(shooter)) {
            return;
        }
        Level level = shooter.m_9236_();
        float yRot = shooter.m_146908_() + 360.0f;
        yRot = (yRot + 90.0f) % 360.0f;
        Vector3d firePos = new Vector3d(0.0, -0.2, 0.15);
        firePos.rotateZ((double)(-shooter.m_146909_() * ((float)Math.PI / 180)));
        firePos.rotateY((double)(-yRot * ((float)Math.PI / 180)));
        Level level2 = shooter.m_9236_();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            Entity targetEntity = EntityFindUtil.findEntity((Level)serverLevel, String.valueOf(targetUUID));
            IglaMissileEntity iglaMissileEntity = new IglaMissileEntity(shooter, level, (float)data.compute().damage, (float)data.compute().explosionDamage, (float)data.compute().explosionRadius);
            for (Perk.Type type : Perk.Type.values()) {
                PerkInstance instance = data.perk.getInstance(type);
                if (instance == null) continue;
                instance.perk().modifyProjectile(data, instance, (Entity)iglaMissileEntity);
            }
            iglaMissileEntity.m_6034_(shooter.m_20185_() + firePos.x, shooter.m_20188_() + firePos.y, shooter.m_20189_() + firePos.z);
            iglaMissileEntity.m_6686_(shooter.m_20154_().f_82479_, shooter.m_20154_().f_82480_ + 0.3, shooter.m_20154_().f_82481_, 3.0f, 1.0f);
            if (targetEntity != null) {
                iglaMissileEntity.setTargetUuid(targetEntity.m_20149_());
            }
            level.m_7967_((Entity)iglaMissileEntity);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123796_, shooter.m_20185_() + 1.8 * shooter.m_20154_().f_82479_, shooter.m_20186_() + (double)shooter.m_20206_() - 0.1 + 1.8 * shooter.m_20154_().f_82480_, shooter.m_20189_() + 1.8 * shooter.m_20154_().f_82481_, 30, 0.4, 0.4, 0.4, 0.005, true);
            if (shooter instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)shooter;
                SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.IGLA_FIRE_1P.get(), 2.0f, 1.0f);
                NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ShootClientMessage(10.0));
            }
            SoundTool.playDistantSound(serverLevel, (SoundEvent)ModSounds.IGLA_FIRE_3P.get(), shooter.m_20182_(), 4.0f, 1.0f, shooter);
            SoundTool.playDistantSound(serverLevel, (SoundEvent)ModSounds.IGLA_FAR.get(), shooter.m_20182_(), 10.0f, 1.0f, shooter);
        }
        data.ammo.set(data.ammo.get() - data.compute().ammoCostPerShoot);
        data.save();
    }
}

