/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ResetCameraTypeMessage;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.ItemNBTTool;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class Monitor
extends Item {
    public static final String LINKED = "Linked";
    public static final String LINKED_DRONE = "LinkedDrone";

    public Monitor() {
        super(new Item.Properties().m_41487_(1));
    }

    public static void link(ItemStack itemstack, String id) {
        ItemNBTTool.setBoolean(itemstack, LINKED, true);
        itemstack.m_41784_().m_128359_(LINKED_DRONE, id);
    }

    public static void disLink(ItemStack itemstack, Player player) {
        ItemNBTTool.setBoolean(itemstack, LINKED, false);
        itemstack.m_41784_().m_128359_(LINKED_DRONE, "none");
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)ResetCameraTypeMessage.INSTANCE);
        }
    }

    private void resetDroneData(DroneEntity drone) {
        if (drone == null) {
            return;
        }
        drone.getPersistentData().m_128379_("left", false);
        drone.getPersistentData().m_128379_("right", false);
        drone.getPersistentData().m_128379_("forward", false);
        drone.getPersistentData().m_128379_("backward", false);
        drone.getPersistentData().m_128379_("up", false);
        drone.getPersistentData().m_128379_("down", false);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        if (!ItemNBTTool.getBoolean(stack, LINKED, false)) {
            return super.m_7203_(level, player, hand);
        }
        if (stack.m_41784_().m_128471_("Using")) {
            stack.m_41784_().m_128379_("Using", false);
            if (level.f_46443_ && ClientEventHandler.lastCameraType != null) {
                Minecraft.m_91087_().f_91066_.m_92157_(ClientEventHandler.lastCameraType);
            }
        } else {
            stack.m_41784_().m_128379_("Using", true);
            if (level.f_46443_) {
                ClientEventHandler.lastCameraType = Minecraft.m_91087_().f_91066_.m_92176_();
                Minecraft.m_91087_().f_91066_.m_92157_(CameraType.THIRD_PERSON_BACK);
            }
        }
        DroneEntity drone = EntityFindUtil.findDrone(player.m_9236_(), stack.m_41784_().m_128461_(LINKED_DRONE));
        this.resetDroneData(drone);
        return super.m_7203_(level, player, hand);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.putAll(super.getAttributeModifiers(slot, stack));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Item modifier", 2.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Item modifier", -2.4, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public static void getDronePos(ItemStack itemstack, Vec3 vec3) {
        itemstack.m_41784_().m_128347_("PosX", vec3.f_82479_);
        itemstack.m_41784_().m_128347_("PosY", vec3.f_82480_);
        itemstack.m_41784_().m_128347_("PosZ", vec3.f_82481_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flag) {
        if (!stack.m_41784_().m_128441_(LINKED_DRONE) || stack.m_41784_().m_128461_(LINKED_DRONE).equals("none")) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (!(stack.m_41784_().m_128441_("PosX") && stack.m_41784_().m_128441_("PosY") && stack.m_41784_().m_128441_("PosZ"))) {
            return;
        }
        Vec3 droneVec = new Vec3(stack.m_41784_().m_128459_("PosX"), stack.m_41784_().m_128459_("PosY"), stack.m_41784_().m_128459_("PosZ"));
        list.add((Component)Component.m_237110_((String)"des.superbwarfare.monitor", (Object[])new Object[]{FormatTool.format1D(player.m_20182_().m_82554_(droneVec), "m")}).m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237113_((String)("X: " + FormatTool.format1D(droneVec.f_82479_) + " Y: " + FormatTool.format1D(droneVec.f_82480_) + " Z: " + FormatTool.format1D(droneVec.f_82481_))));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(itemstack, world, entity, slot, selected);
        DroneEntity drone = EntityFindUtil.findDrone(entity.m_9236_(), itemstack.m_41784_().m_128461_(LINKED_DRONE));
        if (!selected) {
            if (itemstack.m_41784_().m_128471_("Using")) {
                itemstack.m_41784_().m_128379_("Using", false);
                if (entity.m_9236_().f_46443_ && ClientEventHandler.lastCameraType != null) {
                    Minecraft.m_91087_().f_91066_.m_92157_(ClientEventHandler.lastCameraType);
                }
            }
            this.resetDroneData(drone);
        } else if (drone == null && itemstack.m_41784_().m_128471_("Using")) {
            itemstack.m_41784_().m_128379_("Using", false);
            if (entity.m_9236_().f_46443_ && ClientEventHandler.lastCameraType != null) {
                Minecraft.m_91087_().f_91066_.m_92157_(ClientEventHandler.lastCameraType);
            }
        }
    }
}

