/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.capability.energy.ItemEnergyProvider;
import com.atsuishio.superbwarfare.client.tooltip.component.CellImageComponent;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tiers.ModItemTier;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public class ElectricBaton
extends SwordItem {
    public static final int MAX_ENERGY = 30000;
    public static final int ENERGY_COST = 2000;
    public static final String TAG_OPEN = "Open";
    private final Supplier<Integer> energyCapacity = () -> 30000;

    public ElectricBaton() {
        super((Tier)ModItemTier.STEEL, 2, -2.5f, new Item.Properties().m_41503_(1114));
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"des.superbwarfare.electric_baton").m_130940_(ChatFormatting.AQUA));
        if (pStack.m_41783_() != null && pStack.m_41783_().m_128471_(TAG_OPEN)) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"des.superbwarfare.electric_baton.open").m_130940_(ChatFormatting.GRAY));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemEnergyProvider(stack, this.energyCapacity.get());
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (pPlayer.m_6144_()) {
            stack.m_41784_().m_128379_(TAG_OPEN, !stack.m_41784_().m_128471_(TAG_OPEN));
            pPlayer.m_5661_((Component)Component.m_237115_((String)("des.superbwarfare.electric_baton." + (stack.m_41784_().m_128471_(TAG_OPEN) ? "open" : "close"))), true);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public boolean m_142522_(ItemStack pStack) {
        return pStack.m_41784_().m_128471_(TAG_OPEN) || super.m_142522_(pStack);
    }

    public int m_142158_(ItemStack pStack) {
        if (pStack.m_41784_().m_128471_(TAG_OPEN)) {
            Integer energy = pStack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
            return java.lang.Math.round((float)energy.intValue() * 13.0f / 30000.0f);
        }
        return super.m_142158_(pStack);
    }

    public int m_142159_(@NotNull ItemStack pStack) {
        return pStack.m_41784_().m_128471_(TAG_OPEN) ? 0xFFFF00 : super.m_142159_(pStack);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        Integer energy;
        pAttacker.m_9236_().m_5594_(null, pTarget.m_20097_(), (SoundEvent)ModSounds.MELEE_HIT.get(), SoundSource.PLAYERS, 1.0f, (float)((2.0 * Math.random() - 1.0) * (double)0.1f + 1.0));
        if (pStack.m_41784_().m_128471_(TAG_OPEN) && (energy = pStack.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0)) >= 2000) {
            pStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(e -> e.extractEnergy(2000, false));
            if (!pTarget.m_9236_().f_46443_) {
                pTarget.m_147207_(new MobEffectInstance((MobEffect)ModMobEffects.SHOCK.get(), 30, 2), (Entity)pAttacker);
            }
        }
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack pStack) {
        return Optional.of(new CellImageComponent(pStack));
    }

    public static ItemStack makeFullEnergyStack() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.ELECTRIC_BATON.get());
        stack.getCapability(ForgeCapabilities.ENERGY).ifPresent(e -> e.receiveEnergy(30000, false));
        stack.m_41784_().m_128379_(TAG_OPEN, true);
        return stack;
    }
}

