/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.init;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModItems;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModSerializers {
    public static final DeferredRegister<EntityDataSerializer<?>> REGISTRY = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)"superbwarfare");
    public static final RegistryObject<EntityDataSerializer<IntList>> INT_LIST_SERIALIZER = REGISTRY.register("int_list_serializer", () -> EntityDataSerializer.m_238095_(FriendlyByteBuf::m_178345_, FriendlyByteBuf::m_178338_));
    public static final RegistryObject<EntityDataSerializer<List<Float>>> FLOAT_LIST_SERIALIZER = REGISTRY.register("float_list_serializer", () -> EntityDataSerializer.m_238095_((buf, list) -> {
        buf.m_130130_(list.size());
        for (Float v : list) {
            buf.writeFloat(v.floatValue());
        }
    }, buf -> {
        int length = buf.m_130242_();
        ArrayList<Float> list = new ArrayList<Float>();
        for (int i = 0; i < length; ++i) {
            list.add(Float.valueOf(buf.readFloat()));
        }
        return list;
    }));
    public static final RegistryObject<EntityDataSerializer<Map<String, GunData>>> VEHICLE_GUN_DATA_MAP_SERIALIZER = REGISTRY.register("vehicle_gun_data_map_serializer", () -> EntityDataSerializer.m_238095_((buf, map) -> {
        buf.m_130130_(map.size());
        for (Map.Entry kv : map.entrySet()) {
            buf.m_130070_((String)kv.getKey());
            buf.m_130079_(((GunData)kv.getValue()).stack.getShareTag());
        }
    }, buf -> {
        int length = buf.m_130242_();
        HashMap<String, GunData> map = new HashMap<String, GunData>();
        for (int i = 0; i < length; ++i) {
            String weaponName = buf.m_130277_();
            CompoundTag tag = buf.m_130260_();
            ItemStack gunItemStack = new ItemStack((ItemLike)ModItems.VEHICLE_GUN.get());
            gunItemStack.m_41751_(tag);
            map.put(weaponName, GunData.from(gunItemStack));
        }
        return map;
    }));
}

