/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.event;

import com.atsuishio.superbwarfare.capability.ModCapabilities;
import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.config.common.GameplayConfig;
import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerEventHandler {
    public static final UUID TACTICAL_SPRINT_UUID = UUID.fromString("fe8a1213-cf3d-4ec2-8ea8-29acca64b301");

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        if (stack.m_150930_((Item)ModItems.MONITOR.get()) && stack.m_41784_().m_128471_("Using")) {
            stack.m_41784_().m_128379_("Using", false);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawned(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        PlayerEventHandler.handleRespawnReload(player);
        PlayerEventHandler.handleRespawnAutoArmor(player);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (event.phase == TickEvent.Phase.END) {
            if (stack.m_41720_() instanceof GunItem) {
                PlayerEventHandler.handleSpecialWeaponAmmo(player);
            }
            if (event.side.isServer()) {
                PlayerEventHandler.handleTacticalAttribute(player);
            }
        }
    }

    private static void handleSpecialWeaponAmmo(Player player) {
        ItemStack stack = player.m_21205_();
        GunData data = GunData.from(stack);
        if ((stack.m_150930_((Item)ModItems.RPG.get()) || stack.m_150930_((Item)ModItems.BOCEK.get())) && data.hasEnoughAmmoToShoot((Entity)player)) {
            data.isEmpty.set(false);
        }
    }

    private static void handleRespawnReload(Player player) {
        if (!((Boolean)GameplayConfig.RESPAWN_RELOAD.get()).booleanValue()) {
            return;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!(stack.m_41720_() instanceof GunItem)) continue;
            GunData data = GunData.from(stack);
            if (!InventoryTool.hasCreativeAmmoBox((Entity)player)) {
                data.reloadAmmo((Entity)player);
            } else {
                data.ammo.set(data.compute().magazine);
            }
            data.holdOpen.set(false);
            data.save();
        }
    }

    private static void handleRespawnAutoArmor(Player player) {
        if (!((Boolean)GameplayConfig.RESPAWN_AUTO_ARMOR.get()).booleanValue()) {
            return;
        }
        ItemStack armor = player.m_6844_(EquipmentSlot.CHEST);
        if (armor == ItemStack.f_41583_) {
            return;
        }
        double armorPlate = armor.m_41784_().m_128459_("ArmorPlate");
        int armorLevel = (Integer)MiscConfig.DEFAULT_ARMOR_LEVEL.get();
        if (armor.m_204117_(ModTags.Items.MILITARY_ARMOR)) {
            armorLevel = (Integer)MiscConfig.MILITARY_ARMOR_LEVEL.get();
        } else if (armor.m_204117_(ModTags.Items.MILITARY_ARMOR_HEAVY)) {
            armorLevel = (Integer)MiscConfig.HEAVY_MILITARY_ARMOR_LEVEL.get();
        }
        if (armorPlate < (double)(armorLevel * (Integer)MiscConfig.ARMOR_POINT_PER_LEVEL.get())) {
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!stack.m_150930_((Item)ModItems.ARMOR_PLATE.get())) continue;
                if (stack.m_41783_() != null && stack.m_41783_().m_128471_("Infinite")) {
                    armor.m_41784_().m_128347_("ArmorPlate", (double)(armorLevel * (Integer)MiscConfig.ARMOR_POINT_PER_LEVEL.get()));
                    if (!(player instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_9236_().m_5594_(null, serverPlayer.m_20097_(), SoundEvents.f_11677_, SoundSource.PLAYERS, 0.5f, 1.0f);
                    continue;
                }
                int index0 = 0;
                while ((double)index0 < Math.ceil(((double)(armorLevel * (Integer)MiscConfig.ARMOR_POINT_PER_LEVEL.get()) - armorPlate) / (double)((Integer)MiscConfig.ARMOR_POINT_PER_LEVEL.get()).intValue())) {
                    stack.m_41671_(player.m_9236_(), (LivingEntity)player);
                    ++index0;
                }
            }
        }
    }

    public static void handleTacticalAttribute(Player player) {
        if (player == null) {
            return;
        }
        AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
        if (attr == null) {
            return;
        }
        if (attr.m_22111_(TACTICAL_SPRINT_UUID) != null) {
            attr.m_22120_(TACTICAL_SPRINT_UUID);
        }
        if (((Boolean)MiscConfig.ALLOW_TACTICAL_SPRINT.get()).booleanValue() && ((PlayerVariable)player.getCapability(ModCapabilities.PLAYER_VARIABLE, null).orElse((Object)new PlayerVariable())).tacticalSprint) {
            player.m_6858_(true);
            attr.m_22118_(new AttributeModifier(TACTICAL_SPRINT_UUID, "superbwarfare_attribute_modifier", 0.25, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.m_41720_() instanceof GunItem && right.m_41720_() == ModItems.SHORTCUT_PACK.get()) {
            ItemStack output = left.m_41777_();
            GunData data = GunData.from(output);
            data.level.add(1);
            data.save();
            event.setOutput(output);
            event.setCost(10);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Entity target = event.getTarget();
        if (target instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)target;
            Vec3 position = TraceTool.playerFindLookingPos((Entity)event.getEntity(), vehicle, event.getEntity().getEntityReach());
            if (position != null) {
                Level level;
                if (vehicle.shouldSendHitSounds()) {
                    vehicle.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)position), (SoundEvent)ModSounds.HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                if (vehicle.shouldSendHitParticles() && (level = vehicle.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), position.f_82479_, position.f_82480_, position.f_82481_, 2, 0.0, 0.0, 0.0, 0.2, false);
                }
            }
        }
    }
}

