/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.capability.energy.SyncedEntityEnergyStorage;
import com.atsuishio.superbwarfare.capability.energy.VehicleEnergyStorage;
import com.atsuishio.superbwarfare.client.particle.CustomCloudOption;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.data.DataLoader;
import com.atsuishio.superbwarfare.data.StringOrVec3;
import com.atsuishio.superbwarfare.data.gun.AmmoConsumer;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ShootParameters;
import com.atsuishio.superbwarfare.data.gun.SoundInfo;
import com.atsuishio.superbwarfare.data.vehicle.DefaultVehicleData;
import com.atsuishio.superbwarfare.data.vehicle.VehicleData;
import com.atsuishio.superbwarfare.data.vehicle.VehiclePropertyModifier;
import com.atsuishio.superbwarfare.data.vehicle.subdata.CameraPos;
import com.atsuishio.superbwarfare.data.vehicle.subdata.DestroyInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.DismountInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.EngineInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.EngineType;
import com.atsuishio.superbwarfare.data.vehicle.subdata.OBBInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.SeatInfo;
import com.atsuishio.superbwarfare.data.vehicle.subdata.VehicleContainerType;
import com.atsuishio.superbwarfare.data.vehicle.subdata.VehicleType;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.mixin.OBBHitter;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.MortarEntity;
import com.atsuishio.superbwarfare.entity.vehicle.Tom6Entity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleMiscUtils;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleMotionUtils;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleWeaponUtils;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModMenuTypes;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSerializers;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.common.container.ContainerBlockItem;
import com.atsuishio.superbwarfare.menu.VehicleMenu;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.resource.vehicle.VehicleResource;
import com.atsuishio.superbwarfare.tools.CameraTool;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.DamageTypeTool;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.ProjectileCalculator;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.world.TDMSavedData;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Quaterniond;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector4d;

public abstract class VehicleEntity
extends Entity
implements VehiclePropertyModifier,
HasCustomInventoryScreen,
ContainerEntity,
OBBEntity {
    public static final String TAG_SEAT_INDEX = "SBWSeatIndex";
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<String> OVERRIDE = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> LAST_DRIVER_UUID = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> AI_TURRET_TARGET_UUID = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> AI_PASSENGER_WEAPON_TARGET_UUID = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Float> DELTA_ROT = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> MOUSE_SPEED_X = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> MOUSE_SPEED_Y = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<IntList> SELECTED_WEAPON = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModSerializers.INT_LIST_SERIALIZER.get()));
    public static final EntityDataAccessor<Float> TURRET_HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> L_WHEEL_HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> R_WHEEL_HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> MAIN_ENGINE_HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> SUB_ENGINE_HEALTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> TURRET_DAMAGED = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> L_WHEEL_DAMAGED = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> R_WHEEL_DAMAGED = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> MAIN_ENGINE_DAMAGED = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SUB_ENGINE_DAMAGED = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> HORN_VOLUME = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static Consumer<VehicleEntity> playTrackSound = vehicle -> {};
    public static Consumer<VehicleEntity> playEngineSound = vehicle -> {};
    public static Consumer<VehicleEntity> playSwimSound = vehicle -> {};
    public static Consumer<VehicleEntity> playHornSound = vehicle -> {};
    public static Consumer<VehicleEntity> playFireSound = vehicle -> {};
    public static boolean ignoreEntityGroundCheckStepping = false;
    public static final EntityDataAccessor<Float> SERVER_YAW = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> SERVER_PITCH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> CANNON_RECOIL_TIME = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> CANNON_RECOIL_FORCE = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> POWER = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> YAW_WHILE_SHOOT = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> AMMO = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> DECOY_READY = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> PROPELLER_ROT = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> GEAR_ROT = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> GEAR_UP = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> FORWARD_INPUT_DOWN = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> BACK_INPUT_DOWN = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> LEFT_INPUT_DOWN = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RIGHT_INPUT_DOWN = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> UP_INPUT_DOWN = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DOWN_INPUT_DOWN = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DECOY_INPUT_DOWN = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> FIRE_INPUT_DOWN = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SPRINT_INPUT_DOWN = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> PLANE_BREAK = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> ENERGY = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> LASER_LENGTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> LASER_SCALE = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> LASER_SCALE_O = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> CHARGE_PROGRESS = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Map<String, GunData>> GUN_DATA_MAP = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModSerializers.VEHICLE_GUN_DATA_MAP_SERIALIZER.get()));
    private List<OBB> obbCache;
    private List<OBBInfo> obbInfoCache = new ArrayList<OBBInfo>();
    private EngineInfo engineCache;
    protected int interpolationSteps;
    protected double xO;
    protected double yO;
    protected double zO;
    protected float roll;
    public float prevRoll;
    public int repairCoolDown = this.maxRepairCoolDown();
    private boolean crash;
    private float turretYRot;
    private float turretXRot;
    public float turretYRotO;
    public float turretXRotO;
    public float turretYRotLock;
    private float gunYRot;
    private float gunXRot;
    public float gunYRotO;
    public float gunXRotO;
    protected int noPassengerTime;
    @Nullable
    protected Player damageDebugResultReceiver = null;
    private Vec3 previousVelocity = Vec3.f_82478_;
    protected double acceleration;
    public int decoyReloadCoolDown;
    public double lastTickSpeed;
    protected double lastTickVerticalSpeed;
    public int collisionCoolDown;
    private boolean wasEngineRunning = false;
    private boolean wasHornWorking = false;
    private boolean wasFiring = false;
    public double targetSpeed;
    public float rudderRot;
    public float rudderRotO;
    private float leftWheelRot;
    private float rightWheelRot;
    public float leftWheelRotO;
    public float rightWheelRotO;
    public float leftTrackO;
    public float rightTrackO;
    private float leftTrack;
    private float rightTrack;
    private float propellerRot;
    public float propellerRotO;
    protected double recoilShake;
    public double recoilShakeO;
    public double velocityO;
    private double velocity;
    private float flap1LRot;
    public float flap1LRotO;
    private float flap1RRot;
    public float flap1RRotO;
    private float flap1L2Rot;
    public float flap1L2RotO;
    private float flap1R2Rot;
    public float flap1R2RotO;
    private float flap2LRot;
    public float flap2LRotO;
    private float flap2RRot;
    public float flap2RRotO;
    private float flap3Rot;
    public float flap3RotO;
    private float gearRotO;
    private float gearRot;
    public boolean engineStart;
    public boolean engineStartOver;
    public int holdTick;
    public int holdPowerTick;
    public float destroyRot;
    public int jumpCoolDown;
    private LazyOptional<?> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private final List<Entity> orderedPassengers = this.generatePassengersList();
    public Function<Entity, Integer> entityIndexOverride = null;
    protected SyncedEntityEnergyStorage energyStorage = null;
    protected LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    protected boolean isInitialized;
    protected Map<String, Function<Float, Matrix4d>> positionTransform = new HashMap<String, Function<Float, Matrix4d>>();
    protected Map<String, Function<Float, Vec3>> vectorTransform = new HashMap<String, Function<Float, Vec3>>();
    protected Map<String, Function<Float, Quaterniond>> rotationTransform = new HashMap<String, Function<Float, Quaterniond>>();

    public Map<String, GunData> getGunDataMap() {
        Map rawMap = (Map)this.f_19804_.m_135370_(GUN_DATA_MAP);
        HashMap<String, GunData> newMap = new HashMap<String, GunData>();
        Map<String, DefaultGunData> weapons = this.computed().weapons();
        for (Map.Entry<String, DefaultGunData> kv : weapons.entrySet()) {
            GunData data = (GunData)rawMap.get(kv.getKey());
            if (data == null) {
                data = GunData.from(new ItemStack((ItemLike)ModItems.VEHICLE_GUN.get()));
            }
            data.defaultDataSupplier = kv::getValue;
            newMap.put(kv.getKey(), data);
        }
        return newMap;
    }

    @Nullable
    public SeatInfo getSeat(int seatIndex) {
        if (seatIndex < 0) {
            return null;
        }
        List<SeatInfo> seats = this.computed().seats();
        if (seatIndex >= seats.size()) {
            return null;
        }
        return seats.get(seatIndex);
    }

    @Nullable
    public SeatInfo getSeat(Entity passenger) {
        return this.getSeat(this.getSeatIndex(passenger));
    }

    @Nullable
    public GunData getGunData(int seatIndex) {
        if (seatIndex < 0) {
            return null;
        }
        IntList selectedWeapon = (IntList)this.f_19804_.m_135370_(SELECTED_WEAPON);
        if (seatIndex >= selectedWeapon.size()) {
            return null;
        }
        return this.getGunData(seatIndex, selectedWeapon.getInt(seatIndex));
    }

    @Nullable
    public GunData getGunData(int seatIndex, int weaponIndex) {
        SeatInfo seat = this.getSeat(seatIndex);
        if (seat == null) {
            return null;
        }
        List<String> weapons = seat.weapons();
        if (weaponIndex < 0 || weaponIndex >= weapons.size()) {
            return null;
        }
        return this.getGunData(weapons.get(weaponIndex));
    }

    @Nullable
    public GunData getGunData(Entity passenger, int weaponIndex) {
        return this.getGunData(this.getSeatIndex(passenger), weaponIndex);
    }

    @Nullable
    public GunData getGunData(Entity passenger) {
        return this.getGunData(passenger, this.getSelectedWeapon(this.getSeatIndex(passenger)));
    }

    @Nullable
    public GunData getGunData(String name) {
        return this.getGunDataMap().get(name);
    }

    @Nullable
    public String getGunName(int seatIndex) {
        if (seatIndex < 0) {
            return null;
        }
        SeatInfo seat = this.getSeat(seatIndex);
        if (seat == null) {
            return null;
        }
        IntList selectedWeapon = (IntList)this.f_19804_.m_135370_(SELECTED_WEAPON);
        if (seatIndex >= selectedWeapon.size()) {
            return null;
        }
        int weaponIndex = selectedWeapon.getInt(seatIndex);
        if (weaponIndex < 0) {
            return null;
        }
        List<String> weapons = seat.weapons();
        if (weaponIndex >= weapons.size()) {
            return null;
        }
        return this.getGunName(seatIndex, weaponIndex);
    }

    @Nullable
    public String getGunName(int seatIndex, int weaponIndex) {
        if (seatIndex < 0) {
            return null;
        }
        SeatInfo seat = this.getSeat(seatIndex);
        if (seat == null) {
            return null;
        }
        IntList selectedWeapon = (IntList)this.f_19804_.m_135370_(SELECTED_WEAPON);
        if (seatIndex >= selectedWeapon.size()) {
            return null;
        }
        List<String> weapons = seat.weapons();
        if (weaponIndex >= weapons.size()) {
            return null;
        }
        return weapons.get(weaponIndex);
    }

    public void modifyGunData(int seatIndex, int weaponIndex, @NotNull Consumer<GunData> consumer) {
        this.modifyGunData(this.getGunName(seatIndex, weaponIndex), consumer);
    }

    public void modifyGunData(int seatIndex, @NotNull Consumer<GunData> consumer) {
        this.modifyGunData(this.getGunName(seatIndex), consumer);
    }

    public void modifyGunData(@Nullable String name, @NotNull Consumer<GunData> consumer) {
        if (name == null) {
            return;
        }
        Map<String, GunData> map = this.getGunDataMap();
        GunData data = this.getGunData(name);
        if (data == null) {
            return;
        }
        data = data.copy();
        consumer.accept(data);
        data.save();
        map.put(name, data);
        this.f_19804_.m_276349_(GUN_DATA_MAP, map, true);
    }

    public void setCrash(boolean crash) {
        this.crash = crash;
    }

    public VehicleEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.registerTransforms();
        this.initOBB();
        if (this.hasEnergyStorage()) {
            this.energyStorage = new VehicleEnergyStorage(this);
        }
        this.isInitialized = true;
        this.setHealth(this.getMaxHealth());
    }

    private void initOBB() {
        this.obbInfoCache = ((DefaultVehicleData)this.data().getDefault().copy()).obb.stream().filter(Objects::nonNull).toList();
    }

    public List<OBBInfo> getOBB() {
        return this.obbInfoCache;
    }

    public void m_269505_(@NotNull List<SynchedEntityData.DataValue<?>> dataValues) {
        super.m_269505_(dataValues);
        this.data().update();
    }

    public void processInput(short keys) {
        this.setLeftInputDown((keys & 1) > 0);
        this.setRightInputDown((keys & 2) > 0);
        this.setForwardInputDown((keys & 4) > 0);
        this.setBackInputDown((keys & 8) > 0);
        this.setUpInputDown((keys & 0x10) > 0);
        this.setDownInputDown((keys & 0x20) > 0);
        this.setDecoyInputDown((keys & 0x40) > 0);
        this.setFireInputDown((keys & 0x80) > 0);
        this.setSprintInputDown((keys & 0x100) > 0);
    }

    public boolean forwardInputDown() {
        return (Boolean)this.f_19804_.m_135370_(FORWARD_INPUT_DOWN);
    }

    public boolean backInputDown() {
        return (Boolean)this.f_19804_.m_135370_(BACK_INPUT_DOWN);
    }

    public boolean leftInputDown() {
        return (Boolean)this.f_19804_.m_135370_(LEFT_INPUT_DOWN);
    }

    public boolean rightInputDown() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT_INPUT_DOWN);
    }

    public boolean upInputDown() {
        return (Boolean)this.f_19804_.m_135370_(UP_INPUT_DOWN);
    }

    public boolean downInputDown() {
        return (Boolean)this.f_19804_.m_135370_(DOWN_INPUT_DOWN);
    }

    public boolean fireInputDown() {
        return (Boolean)this.f_19804_.m_135370_(FIRE_INPUT_DOWN);
    }

    public boolean decoyInputDown() {
        return (Boolean)this.f_19804_.m_135370_(DECOY_INPUT_DOWN);
    }

    public boolean sprintInputDown() {
        return (Boolean)this.f_19804_.m_135370_(SPRINT_INPUT_DOWN);
    }

    public void setForwardInputDown(boolean set) {
        this.f_19804_.m_135381_(FORWARD_INPUT_DOWN, (Object)set);
    }

    public void setBackInputDown(boolean set) {
        this.f_19804_.m_135381_(BACK_INPUT_DOWN, (Object)set);
    }

    public void setLeftInputDown(boolean set) {
        this.f_19804_.m_135381_(LEFT_INPUT_DOWN, (Object)set);
    }

    public void setRightInputDown(boolean set) {
        this.f_19804_.m_135381_(RIGHT_INPUT_DOWN, (Object)set);
    }

    public void setUpInputDown(boolean set) {
        this.f_19804_.m_135381_(UP_INPUT_DOWN, (Object)set);
    }

    public void setDownInputDown(boolean set) {
        this.f_19804_.m_135381_(DOWN_INPUT_DOWN, (Object)set);
    }

    public void setFireInputDown(boolean set) {
        this.f_19804_.m_135381_(FIRE_INPUT_DOWN, (Object)set);
    }

    public void setDecoyInputDown(boolean set) {
        this.f_19804_.m_135381_(DECOY_INPUT_DOWN, (Object)set);
    }

    public void setSprintInputDown(boolean set) {
        this.f_19804_.m_135381_(SPRINT_INPUT_DOWN, (Object)set);
    }

    public void mouseInput(double x, double y) {
        this.f_19804_.m_135381_(MOUSE_SPEED_X, (Object)Float.valueOf((float)x));
        this.f_19804_.m_135381_(MOUSE_SPEED_Y, (Object)Float.valueOf((float)y));
    }

    public float getMouseMoveSpeedY() {
        return ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_Y)).floatValue();
    }

    public float getMouseMoveSpeedX() {
        return ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_X)).floatValue();
    }

    protected void resizeItems() {
        int currentSize;
        int newSize = this.m_6643_();
        if (newSize == (currentSize = this.items.size())) {
            return;
        }
        if (newSize > currentSize) {
            NonNullList newItems = NonNullList.m_122780_((int)newSize, (Object)ItemStack.f_41583_);
            for (int i = 0; i < currentSize; ++i) {
                newItems.set(i, (Object)((ItemStack)this.items.get(i)));
            }
            this.items = newItems;
        } else {
            for (int i = newSize; i < currentSize; ++i) {
                ItemStack excessStack = (ItemStack)this.items.get(i);
                if (excessStack.m_41619_()) continue;
                this.m_19983_(excessStack.m_41777_());
            }
            NonNullList newItems = NonNullList.m_122780_((int)newSize, (Object)ItemStack.f_41583_);
            for (int i = 0; i < newSize; ++i) {
                newItems.set(i, (Object)((ItemStack)this.items.get(i)));
            }
            this.items = newItems;
        }
        this.m_6596_();
    }

    public int m_18947_(@Nullable Item item) {
        if (item == null || !this.hasContainer()) {
            return 0;
        }
        return InventoryTool.countItem(this.items, item);
    }

    public boolean hasItem(Item item) {
        if (!this.hasContainer()) {
            return false;
        }
        return this.m_18947_(item) > 0;
    }

    public int consumeItem(Item item, int count) {
        if (!this.hasContainer()) {
            return 0;
        }
        return InventoryTool.consumeItem(this.items, item, count);
    }

    public void insertItem(Item item, int count) {
        if (!this.hasContainer()) {
            return;
        }
        int rest = InventoryTool.insertItem(this.items, item, count, this.m_6893_());
        if (rest > 0) {
            ItemStack stackToDrop = new ItemStack((ItemLike)item, rest);
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stackToDrop));
        }
    }

    public int m_6643_() {
        VehicleContainerType type = this.computed().vehicleContainerType;
        if (type == null) {
            return 0;
        }
        if (type.hasMenu()) {
            return 102;
        }
        return this.computed().vehicleContainerType.getSize();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        if (!this.hasContainer() || slot >= this.m_6643_() || slot < 0) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int pAmount) {
        if (!this.hasContainer() || slot >= this.m_6643_() || slot < 0) {
            return ItemStack.f_41583_;
        }
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)pAmount);
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        if (!this.hasContainer() || slot >= this.m_6643_() || slot < 0) {
            return ItemStack.f_41583_;
        }
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.items.set(slot, (Object)ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int slot, @NotNull ItemStack pStack) {
        if (!this.hasContainer() || slot >= this.m_6643_() || slot < 0) {
            return;
        }
        int limit = org.joml.Math.min((int)this.m_6893_(), (int)pStack.m_41741_());
        if (!pStack.m_41619_() && pStack.m_41613_() > limit) {
            Mod.LOGGER.warn("try inserting ItemStack {} exceeding the maximum stack size: {}, clamped to {}", (Object)pStack.m_41720_(), (Object)limit, (Object)limit);
            pStack.m_41764_(limit);
        }
        this.items.set(slot, (Object)pStack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(@NotNull Player pPlayer) {
        return this.hasContainer() && !this.m_213877_() && this.m_20182_().m_82509_((Position)pPlayer.m_20182_(), 8.0);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public boolean hasContainer() {
        return this.m_6643_() > 0;
    }

    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        int stackCount;
        if (!this.hasContainer() || slot >= this.m_6643_() || slot < 0) {
            return false;
        }
        ItemStack currentStack = (ItemStack)this.items.get(slot);
        if (!currentStack.m_41619_() && currentStack.m_41720_() != stack.m_41720_()) {
            return false;
        }
        int currentCount = currentStack.m_41613_();
        int combinedCount = currentCount + (stackCount = stack.m_41613_());
        if (combinedCount > this.m_6893_() || combinedCount > stack.m_41741_()) {
            return false;
        }
        return super.m_7013_(slot, stack);
    }

    public boolean m_271862_(@NotNull Container target, int slot, @NotNull ItemStack stack) {
        if (!this.hasContainer() || slot >= this.m_6643_() || slot < 0) {
            return false;
        }
        return super.m_271862_(target, slot, stack);
    }

    public void m_142687_(@NotNull Entity.RemovalReason pReason) {
        if (!this.m_9236_().f_46443_ && pReason != Entity.RemovalReason.DISCARDED) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
        }
        super.m_142687_(pReason);
    }

    public void m_213583_(Player pPlayer) {
        pPlayer.m_5893_((MenuProvider)this);
        if (!pPlayer.m_9236_().f_46443_) {
            this.m_146852_(GameEvent.f_157803_, (Entity)pPlayer);
        }
    }

    @Nullable
    public ResourceLocation m_214142_() {
        return null;
    }

    public void m_214199_(@Nullable ResourceLocation pLootTable) {
    }

    public long m_213803_() {
        return 0L;
    }

    public void m_214065_(long pLootTableSeed) {
    }

    public boolean hasMenu() {
        return this.computed().vehicleContainerType.hasMenu();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, @NotNull Inventory pPlayerInventory, Player pPlayer) {
        if (!pPlayer.m_5833_() && this.hasMenu()) {
            DefaultVehicleData computed = this.computed();
            VehicleContainerType type = computed.vehicleContainerType;
            if (type == null || !type.hasMenu()) {
                return null;
            }
            return new VehicleMenu((MenuType)ModMenuTypes.VEHICLE_MENU_HUGE.get(), pContainerId, pPlayerInventory, (Container)this, 6, 17, false);
        }
        return null;
    }

    public void m_5785_(@NotNull Player pPlayer) {
        this.m_9236_().m_214171_(GameEvent.f_157802_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)pPlayer));
    }

    @NotNull
    public NonNullList<ItemStack> m_213659_() {
        return this.items;
    }

    public void m_213775_() {
        this.items.clear();
    }

    private ArrayList<Entity> generatePassengersList() {
        ArrayList<Entity> list = new ArrayList<Entity>(this.getMaxPassengers());
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            list.add(null);
        }
        return list;
    }

    protected void initSeatData(int targetSize) {
        this.padList(this.orderedPassengers, targetSize, null, null);
    }

    protected <T> void padList(@NotNull List<T> list, int targetSize, T defaultValue, @Nullable Consumer<T> onRemove) {
        while (targetSize != list.size()) {
            if (targetSize > list.size()) {
                list.add(defaultValue);
                continue;
            }
            T last = list.remove(list.size() - 1);
            if (last == null || onRemove == null) continue;
            onRemove.accept(last);
        }
    }

    protected void checkSeatsSize() {
        int targetSize = this.computed().seats().size();
        if (targetSize == this.orderedPassengers.size()) {
            return;
        }
        this.initSeatData(targetSize);
    }

    public List<Entity> getOrderedPassengers() {
        this.checkSeatsSize();
        return this.orderedPassengers;
    }

    protected void m_20348_(@NotNull Entity pPassenger) {
        int index;
        if (pPassenger.m_20202_() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        this.checkSeatsSize();
        if (this.entityIndexOverride != null && this.entityIndexOverride.apply(pPassenger) != -1) {
            index = this.entityIndexOverride.apply(pPassenger);
        } else {
            index = 0;
            for (Entity passenger : this.orderedPassengers) {
                if (passenger == null) break;
                ++index;
            }
        }
        if (index >= this.getMaxPassengers() || index < 0) {
            return;
        }
        this.orderedPassengers.set(index, pPassenger);
        pPassenger.getPersistentData().m_128405_(TAG_SEAT_INDEX, index);
        this.f_19823_ = ImmutableList.copyOf(this.orderedPassengers.stream().filter(Objects::nonNull).toList());
        this.m_146852_(GameEvent.f_268500_, pPassenger);
    }

    protected void m_20351_(@NotNull Entity pPassenger) {
        if (pPassenger.m_20202_() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        this.checkSeatsSize();
        int index = this.getSeatIndex(pPassenger);
        if (index == -1) {
            return;
        }
        this.orderedPassengers.set(index, null);
        this.f_19823_ = ImmutableList.copyOf(this.orderedPassengers.stream().filter(Objects::nonNull).toList());
        pPassenger.f_19851_ = 60;
        this.m_146852_(GameEvent.f_268533_, pPassenger);
    }

    public VehicleData data() {
        return VehicleData.from(this);
    }

    public DefaultVehicleData computed() {
        return VehicleData.compute(this);
    }

    public float getStepHeight() {
        return this.computed().upStep;
    }

    @Nullable
    public Entity m_146895_() {
        this.checkSeatsSize();
        if (this.orderedPassengers.isEmpty()) {
            return null;
        }
        return this.orderedPassengers.get(0);
    }

    @Nullable
    public Entity getNthEntity(int index) {
        this.checkSeatsSize();
        if (index >= this.orderedPassengers.size() || index < 0) {
            return null;
        }
        return this.orderedPassengers.get(index);
    }

    public boolean changeSeat(Entity entity, int index) {
        if (index < 0 || index >= this.getMaxPassengers()) {
            return false;
        }
        this.checkSeatsSize();
        if (this.orderedPassengers.get(index) != null) {
            return false;
        }
        if (!this.orderedPassengers.contains(entity)) {
            return false;
        }
        this.orderedPassengers.set(this.orderedPassengers.indexOf(entity), null);
        this.orderedPassengers.set(index, entity);
        entity.getPersistentData().m_128405_(TAG_SEAT_INDEX, index);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8795_(s -> true).forEach(p -> p.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)this)));
        }
        return true;
    }

    public int getSeatIndex(Entity entity) {
        this.checkSeatsSize();
        return this.orderedPassengers.indexOf(entity);
    }

    public int getTagSeatIndex(Entity entity) {
        return entity.getPersistentData().m_128451_(TAG_SEAT_INDEX);
    }

    public Vec3 getThirdPersonCameraPosition() {
        Vec3 pos = this.computed().thirdPersonCameraPos;
        if (pos == null) {
            pos = new Vec3(0.0, 1.0, 3.0);
        }
        return new Vec3(pos.f_82481_ + ClientMouseHandler.custom3pDistanceLerp, pos.f_82480_, pos.f_82479_);
    }

    public float getRoll() {
        return this.roll;
    }

    public float getRoll(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.prevRoll, (float)this.getRoll());
    }

    public float getYaw(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.f_19859_, (float)this.m_146908_());
    }

    public float getPitch(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.f_19860_, (float)this.m_146909_());
    }

    public void setZRot(float rot) {
        this.roll = rot;
    }

    public void turretTurnSound(float diffX, float diffY, float pitch) {
        if (this instanceof MortarEntity) {
            return;
        }
        if (this.m_9236_().f_46443_ && ((double)org.joml.Math.abs((float)diffY) > 0.5 || (double)org.joml.Math.abs((float)diffX) > 0.5)) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), (SoundEvent)ModSounds.TURRET_TURN.get(), this.m_5720_(), (float)Math.min(0.15 * (double)Math.max(Mth.m_14154_((float)diffX), Mth.m_14154_((float)diffY)), 0.75), this.f_19796_.m_188501_() * 0.05f + pitch, false);
        }
    }

    public boolean shouldSendHitParticles() {
        return this.computed().sendHitParticles;
    }

    public boolean shouldSendHitSounds() {
        return true;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public EntityDataAccessor<Integer> getEnergyDataAccessor() {
        return ENERGY;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OVERRIDE, (Object)"");
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(this.getMaxHealth()));
        this.f_19804_.m_135372_(LAST_ATTACKER_UUID, (Object)"undefined");
        this.f_19804_.m_135372_(LAST_DRIVER_UUID, (Object)"undefined");
        this.f_19804_.m_135372_(GUN_DATA_MAP, new HashMap());
        this.f_19804_.m_135372_(AI_TURRET_TARGET_UUID, (Object)"undefined");
        this.f_19804_.m_135372_(AI_PASSENGER_WEAPON_TARGET_UUID, (Object)"undefined");
        this.f_19804_.m_135372_(DELTA_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MOUSE_SPEED_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(MOUSE_SPEED_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TURRET_HEALTH, (Object)Float.valueOf(this.getTurretMaxHealth()));
        this.f_19804_.m_135372_(L_WHEEL_HEALTH, (Object)Float.valueOf(this.getWheelMaxHealth()));
        this.f_19804_.m_135372_(R_WHEEL_HEALTH, (Object)Float.valueOf(this.getWheelMaxHealth()));
        this.f_19804_.m_135372_(MAIN_ENGINE_HEALTH, (Object)Float.valueOf(this.getEngineMaxHealth()));
        this.f_19804_.m_135372_(SUB_ENGINE_HEALTH, (Object)Float.valueOf(this.getEngineMaxHealth()));
        this.f_19804_.m_135372_(TURRET_DAMAGED, (Object)false);
        this.f_19804_.m_135372_(L_WHEEL_DAMAGED, (Object)false);
        this.f_19804_.m_135372_(R_WHEEL_DAMAGED, (Object)false);
        this.f_19804_.m_135372_(MAIN_ENGINE_DAMAGED, (Object)false);
        this.f_19804_.m_135372_(SUB_ENGINE_DAMAGED, (Object)false);
        this.f_19804_.m_135372_(CANNON_RECOIL_TIME, (Object)0);
        this.f_19804_.m_135372_(CANNON_RECOIL_FORCE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(POWER, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(YAW_WHILE_SHOOT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SERVER_YAW, (Object)Float.valueOf(this.m_146908_()));
        this.f_19804_.m_135372_(SERVER_PITCH, (Object)Float.valueOf(this.m_146909_()));
        this.f_19804_.m_135372_(AMMO, (Object)0);
        this.f_19804_.m_135372_(DECOY_READY, (Object)false);
        this.f_19804_.m_135372_(GEAR_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(GEAR_UP, (Object)false);
        this.f_19804_.m_135372_(FORWARD_INPUT_DOWN, (Object)false);
        this.f_19804_.m_135372_(BACK_INPUT_DOWN, (Object)false);
        this.f_19804_.m_135372_(LEFT_INPUT_DOWN, (Object)false);
        this.f_19804_.m_135372_(RIGHT_INPUT_DOWN, (Object)false);
        this.f_19804_.m_135372_(UP_INPUT_DOWN, (Object)false);
        this.f_19804_.m_135372_(DOWN_INPUT_DOWN, (Object)false);
        this.f_19804_.m_135372_(FIRE_INPUT_DOWN, (Object)false);
        this.f_19804_.m_135372_(DECOY_INPUT_DOWN, (Object)false);
        this.f_19804_.m_135372_(SPRINT_INPUT_DOWN, (Object)false);
        this.f_19804_.m_135372_(PLANE_BREAK, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SELECTED_WEAPON, (Object)IntList.of((int[])new int[this.getMaxPassengers()]));
        this.f_19804_.m_135372_(ENERGY, (Object)0);
        this.f_19804_.m_135372_(PROPELLER_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HORN_VOLUME, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LASER_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LASER_SCALE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LASER_SCALE_O, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CHARGE_PROGRESS, (Object)Float.valueOf(0.0f));
    }

    public void consumeEnergy(int amount) {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to consume energy of vehicle {}, but it has no energy storage", (Object)this.m_7755_());
            return;
        }
        if (this.m_9236_() instanceof ServerLevel) {
            this.energyStorage.extractEnergy(amount, false);
        }
    }

    protected boolean canConsume(int amount) {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to check if can consume energy of vehicle {}, but it has no energy storage", (Object)this.m_7755_());
            return false;
        }
        return this.getEnergy() >= amount;
    }

    public int getEnergy() {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to get energy of vehicle {}, but it has no energy storage", (Object)this.m_7755_());
            return Integer.MAX_VALUE;
        }
        return this.energyStorage.getEnergyStored();
    }

    @Nullable
    public IEnergyStorage getEnergyStorage() {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to get energy storage of vehicle {}, but it has no energy storage", (Object)this.m_7755_());
        }
        return this.energyStorage;
    }

    protected void setEnergy(int pEnergy) {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to set energy of vehicle {}, but it has no energy storage", (Object)this.m_7755_());
            return;
        }
        int targetEnergy = Mth.m_14045_((int)pEnergy, (int)0, (int)this.getMaxEnergy());
        if (targetEnergy > this.energyStorage.getEnergyStored()) {
            this.energyStorage.receiveEnergy(targetEnergy - this.energyStorage.getEnergyStored(), false);
        } else {
            this.energyStorage.extractEnergy(this.energyStorage.getEnergyStored() - targetEnergy, false);
        }
    }

    public int getMaxEnergy() {
        if (!this.hasEnergyStorage()) {
            Mod.LOGGER.warn("Trying to get max energy of vehicle {}, but it has no energy storage", (Object)this.m_7755_());
            return Integer.MAX_VALUE;
        }
        return this.computed().maxEnergy;
    }

    public boolean hasEnergyStorage() {
        return this.computed().maxEnergy > 0;
    }

    public boolean canShoot(LivingEntity living) {
        GunData gunData = this.getGunData(this.getSeatIndex((Entity)living));
        return gunData != null && gunData.canShoot(this.getAmmoSupplier());
    }

    public int vehicleWeaponRpm(LivingEntity living) {
        GunData data = this.getGunData(this.getSeatIndex((Entity)living));
        if (data == null || data.compute().rpm <= 0) {
            return 60;
        }
        return data.compute().rpm;
    }

    public int vehicleWeaponRpm(int seatIndex) {
        GunData data = this.getGunData(seatIndex);
        if (data == null || data.compute().rpm <= 0) {
            return 60;
        }
        return data.compute().rpm;
    }

    public int vehicleWeaponRpm(String weaponName) {
        GunData data = this.getGunData(weaponName);
        if (data == null || data.compute().rpm <= 0) {
            return 1;
        }
        return data.compute().rpm;
    }

    public int getWeaponHeat(LivingEntity living) {
        GunData gunData = this.getGunData(this.getSeatIndex((Entity)living));
        if (gunData == null) {
            return 0;
        }
        return Math.toIntExact(Math.round(gunData.heat.get()));
    }

    public int getWeaponHeat(int seatIndex) {
        GunData gunData = this.getGunData(seatIndex);
        if (gunData == null) {
            return 0;
        }
        return Math.toIntExact(Math.round(gunData.heat.get()));
    }

    public int getWeaponHeat(String weaponName) {
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return 0;
        }
        return Math.toIntExact(Math.round(gunData.heat.get()));
    }

    public int getWeaponHeat(int seatIndex, int weaponIndex) {
        GunData gunData = this.getGunData(seatIndex, weaponIndex);
        if (gunData == null) {
            return 0;
        }
        return Math.toIntExact(Math.round(gunData.heat.get()));
    }

    public int getShootAnimationTimer(String weaponName) {
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return 0;
        }
        return gunData.shootAnimationTimer.get();
    }

    public int getShootAnimationTimer(int seatIndex, int weaponIndex) {
        GunData gunData = this.getGunData(seatIndex, weaponIndex);
        if (gunData == null) {
            return 0;
        }
        return gunData.shootAnimationTimer.get();
    }

    public void vehicleShoot(LivingEntity living, String weaponName) {
        this.modifyGunData(weaponName, (GunData data) -> {
            if (!data.canShoot(this.getAmmoSupplier())) {
                return;
            }
            data.shoot(new ShootParameters(this.getAmmoSupplier(), (Entity)living, (ServerLevel)this.m_9236_(), this.getShootPos(weaponName, 1.0f), this.getShootVec(weaponName, 1.0f), (GunData)data, data.compute().spread, true, null, null));
        });
        GunData gunData = this.getGunData(weaponName);
        this.afterShoot(gunData, this.getShootVec(weaponName, 1.0f));
        this.playShootSound3p(living, weaponName);
    }

    public void vehicleShoot(LivingEntity living, @Nullable UUID uuid, @Nullable Vec3 targetPos) {
        int seatIndex = this.getSeatIndex((Entity)living);
        this.modifyGunData(seatIndex, (GunData data) -> {
            if (!data.canShoot(this.getAmmoSupplier())) {
                return;
            }
            data.shoot(new ShootParameters(this.getAmmoSupplier(), (Entity)living, (ServerLevel)this.m_9236_(), this.getShootPos((Entity)living, 1.0f), this.getShootVec((Entity)living, 1.0f), (GunData)data, data.compute().spread, true, uuid, targetPos));
        });
        GunData gunData = this.getGunData(seatIndex);
        this.afterShoot(gunData, this.getShootVec((Entity)living, 1.0f));
        this.playShootSound3p(living, seatIndex);
    }

    public void afterShoot(GunData gunData, Vec3 shootVec) {
        if (gunData != null) {
            DefaultGunData computedGunData = gunData.compute();
            if (computedGunData.recoilTime > 0) {
                if (computedGunData.recoilTime > (Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME)) {
                    this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)computedGunData.recoilTime);
                }
                float angle = (float)Mth.m_14175_((double)(-VehicleVecUtils.getYRotFromVector(this.m_20252_(1.0f)) + VehicleVecUtils.getYRotFromVector(shootVec)));
                Vec3 vo = new Vec3(0.0, 0.0, 1.0);
                double f = 0.3 * (double)((Float)this.f_19804_.m_135370_(CANNON_RECOIL_FORCE)).floatValue() * (double)((Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME) / computedGunData.recoilTime);
                Vec3 v1 = vo.m_82524_(((Float)this.f_19804_.m_135370_(YAW_WHILE_SHOOT)).floatValue() * ((float)Math.PI / 180)).m_82490_(f);
                Vec3 v2 = vo.m_82524_(angle * ((float)Math.PI / 180)).m_82490_((double)computedGunData.recoilForce);
                Vec3 v3 = v1.m_82549_(v2);
                this.f_19804_.m_135381_(YAW_WHILE_SHOOT, (Object)Float.valueOf((float)Mth.m_14175_((double)(-VehicleVecUtils.getYRotFromVector(vo) + VehicleVecUtils.getYRotFromVector(v3)))));
                this.f_19804_.m_135381_(CANNON_RECOIL_FORCE, (Object)Float.valueOf((float)v3.m_82553_()));
                gunData.shakePlayers(this);
            }
        }
    }

    public void playShootSound3p(LivingEntity living, String weaponName) {
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return;
        }
        Vec3 pos = this.getShootPos(weaponName, 1.0f);
        this.playShootSound3p(living, gunData, pos);
    }

    public void playShootSound3p(LivingEntity living, int seatIndex) {
        GunData gunData = this.getGunData(seatIndex);
        if (gunData == null) {
            return;
        }
        Vec3 pos = this.getShootPos((Entity)living, 1.0f);
        this.playShootSound3p(living, gunData, pos);
    }

    public void playShootSound3p(LivingEntity living, GunData gunData, Vec3 pos) {
        GunData shootGunData;
        float pitch;
        Level level = living.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (gunData == null) {
            return;
        }
        DefaultGunData computedGunData = gunData.compute();
        SoundInfo soundInfo = computedGunData.soundInfo;
        float f = pitch = this.getWeaponHeat(living) <= 60 ? 1.0f : (float)(1.0 - 0.011 * (double)Math.abs(60 - this.getWeaponHeat(living)));
        LivingEntity listener = living.m_20202_() != this || living.m_20202_() == null ? null : ((shootGunData = this.getGunData((Entity)living)) != null && shootGunData == gunData ? living : null);
        if (soundInfo.fire3P != null) {
            SoundTool.playDistantSound(serverLevel, soundInfo.fire3P, pos, (float)(computedGunData.soundRadius * (double)0.4f), pitch, (Entity)listener);
        }
        if (soundInfo.fire3PFar != null) {
            SoundTool.playDistantSound(serverLevel, soundInfo.fire3PFar, pos, (float)(computedGunData.soundRadius * (double)0.7f), pitch, (Entity)listener);
        }
        if (soundInfo.fire3PVeryFar != null) {
            SoundTool.playDistantSound(serverLevel, soundInfo.fire3PVeryFar, pos, (float)computedGunData.soundRadius, pitch, (Entity)listener);
        }
    }

    public int getWeaponIndex(int seatIndex) {
        IntList selectedWeapons = (IntList)this.m_20088_().m_135370_(SELECTED_WEAPON);
        if (selectedWeapons.size() <= seatIndex) {
            return -1;
        }
        return selectedWeapons.getInt(seatIndex);
    }

    public boolean hasWeapon() {
        return this.computed().seats().stream().filter(seat -> !seat.weapons().isEmpty()).flatMap(seat -> seat.weapons().stream()).filter(name -> name != null && !name.isEmpty()).anyMatch(name -> this.getGunData((String)name) != null);
    }

    public boolean hasWeapon(int seatIndex) {
        if (seatIndex < 0 || seatIndex >= this.getMaxPassengers()) {
            return false;
        }
        return this.getGunData(seatIndex) != null;
    }

    public void setWeaponIndex(int seatIndex, int selectedWeapon) {
        int[] selectedWeapons = ((IntList)this.m_20088_().m_135370_(SELECTED_WEAPON)).toIntArray();
        int oldIndex = selectedWeapons[seatIndex];
        if (oldIndex == selectedWeapon) {
            return;
        }
        this.modifyGunData(seatIndex, oldIndex, gunData -> {
            if (gunData.compute().withdrawAmmoWhenChangeSlot) {
                gunData.withdrawAmmo(this.getAmmoSupplier());
            }
        });
        selectedWeapons[seatIndex] = selectedWeapon;
        this.m_20088_().m_135381_(SELECTED_WEAPON, (Object)IntList.of((int[])selectedWeapons));
    }

    public void changeWeapon(int seatIndex, int value, boolean isScroll) {
        if (seatIndex < 0 || seatIndex >= this.getMaxPassengers()) {
            return;
        }
        List<String> weapons = this.computed().seats().get(seatIndex).weapons();
        if (weapons.isEmpty()) {
            return;
        }
        int count = weapons.size();
        int currentIndex = this.getWeaponIndex(seatIndex);
        int typeIndex = Mth.m_14045_((int)(isScroll ? (value + currentIndex + count) % count : value), (int)0, (int)(count - 1));
        if (typeIndex == currentIndex) {
            return;
        }
        GunData weapon = this.getGunData(weapons.get(typeIndex));
        if (weapon == null) {
            return;
        }
        this.setWeaponIndex(seatIndex, typeIndex);
        SoundEvent sound = weapon.compute().soundInfo.change;
        if (sound != null) {
            this.m_9236_().m_6269_(null, (Entity)this, sound, this.m_5720_(), 1.0f, 1.0f);
        }
    }

    protected void m_7378_(CompoundTag compound) {
        Tag tag;
        int[] selected;
        this.f_19804_.m_135381_(OVERRIDE, (Object)compound.m_128461_("Override"));
        CompoundTag state = compound.m_128469_("WeaponState");
        HashMap<String, GunData> gunDataMap = new HashMap<String, GunData>();
        for (String key : state.m_128431_()) {
            CompoundTag tag2 = state.m_128469_(key);
            tag2 = tag2.m_6426_();
            tag2.m_128359_("id", "superbwarfare:vehicle_gun");
            tag2.m_128405_("Count", 1);
            gunDataMap.put(key, GunData.from(ItemStack.m_41712_((CompoundTag)tag2)));
        }
        this.f_19804_.m_276349_(GUN_DATA_MAP, gunDataMap, true);
        if (compound.m_128441_("Health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(compound.m_128457_("Health")));
        } else {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(this.getMaxHealth()));
        }
        this.f_19804_.m_135381_(TURRET_HEALTH, (Object)Float.valueOf(compound.m_128457_("TurretHealth")));
        this.f_19804_.m_135381_(L_WHEEL_HEALTH, (Object)Float.valueOf(compound.m_128457_("LeftWheelHealth")));
        this.f_19804_.m_135381_(R_WHEEL_HEALTH, (Object)Float.valueOf(compound.m_128457_("RightWheelHealth")));
        this.f_19804_.m_135381_(MAIN_ENGINE_HEALTH, (Object)Float.valueOf(compound.m_128457_("MainEngineHealth")));
        this.f_19804_.m_135381_(SUB_ENGINE_HEALTH, (Object)Float.valueOf(compound.m_128457_("SubEngineHealth")));
        this.f_19804_.m_135381_(TURRET_DAMAGED, (Object)compound.m_128471_("TurretDamaged"));
        this.f_19804_.m_135381_(L_WHEEL_DAMAGED, (Object)compound.m_128471_("LeftWheelDamaged"));
        this.f_19804_.m_135381_(R_WHEEL_DAMAGED, (Object)compound.m_128471_("RightWheelDamaged"));
        this.f_19804_.m_135381_(MAIN_ENGINE_DAMAGED, (Object)compound.m_128471_("MainEngineDamaged"));
        this.f_19804_.m_135381_(SUB_ENGINE_DAMAGED, (Object)compound.m_128471_("SubEngineDamaged"));
        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(compound.m_128457_("Power")));
        this.f_19804_.m_135381_(DECOY_READY, (Object)compound.m_128471_("DecoyReady"));
        this.f_19804_.m_135381_(GEAR_ROT, (Object)Float.valueOf(compound.m_128457_("GearRot")));
        this.f_19804_.m_135381_(GEAR_UP, (Object)compound.m_128471_("GearUp"));
        this.f_19804_.m_135381_(PROPELLER_ROT, (Object)Float.valueOf(compound.m_128457_("PropellerRot")));
        this.f_19804_.m_135381_(CHARGE_PROGRESS, (Object)Float.valueOf(compound.m_128457_("ChargeProgress")));
        this.f_19804_.m_135381_(LAST_ATTACKER_UUID, (Object)compound.m_128461_("LastAttacker"));
        this.f_19804_.m_135381_(LAST_DRIVER_UUID, (Object)compound.m_128461_("LastDriver"));
        this.f_19804_.m_135381_(SERVER_YAW, (Object)Float.valueOf(compound.m_128457_("ServerYaw")));
        this.f_19804_.m_135381_(SERVER_PITCH, (Object)Float.valueOf(compound.m_128457_("ServerPitch")));
        Tag selectedWeaponTag = compound.m_128423_("SelectedWeapon");
        if (selectedWeaponTag instanceof IntArrayTag) {
            IntArrayTag arrayTag = (IntArrayTag)selectedWeaponTag;
            selected = arrayTag.m_128648_();
        } else {
            selected = new int[this.getMaxPassengers()];
        }
        if (selected.length != this.getMaxPassengers()) {
            this.f_19804_.m_135381_(SELECTED_WEAPON, (Object)IntList.of((int[])new int[this.getMaxPassengers()]));
        } else {
            this.f_19804_.m_135381_(SELECTED_WEAPON, (Object)IntList.of((int[])selected));
        }
        if (this.hasEnergyStorage() && (tag = compound.m_128423_("Energy")) instanceof IntTag) {
            IntTag energyNBT = (IntTag)tag;
            this.energyStorage.deserializeNBT((Tag)energyNBT);
        }
        this.resizeItems();
        ContainerHelper.m_18980_((CompoundTag)compound, this.m_213659_());
    }

    public void m_7380_(CompoundTag compound) {
        this.checkSeatsSize();
        compound.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
        String overrideString = (String)this.f_19804_.m_135370_(OVERRIDE);
        if (!overrideString.isBlank()) {
            compound.m_128359_("Override", overrideString);
        }
        compound.m_128359_("LastAttacker", (String)this.f_19804_.m_135370_(LAST_ATTACKER_UUID));
        compound.m_128359_("LastDriver", (String)this.f_19804_.m_135370_(LAST_DRIVER_UUID));
        Map<String, GunData> gunDataMap = this.getGunDataMap();
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, GunData> kv : gunDataMap.entrySet()) {
            GunData data = GunData.from(kv.getValue().stack.m_41777_());
            data.backupAmmoCount.reset();
            data.save();
            CompoundTag stackTag = data.stack.m_41739_(new CompoundTag());
            stackTag.m_128473_("id");
            stackTag.m_128473_("Count");
            if (stackTag.m_128456_()) continue;
            tag.m_128365_(String.valueOf(kv.getKey()), (Tag)stackTag);
        }
        if (!tag.m_128456_()) {
            compound.m_128365_("WeaponState", (Tag)tag);
        }
        compound.m_128350_("TurretHealth", ((Float)this.f_19804_.m_135370_(TURRET_HEALTH)).floatValue());
        compound.m_128350_("LeftWheelHealth", ((Float)this.f_19804_.m_135370_(L_WHEEL_HEALTH)).floatValue());
        compound.m_128350_("RightWheelHealth", ((Float)this.f_19804_.m_135370_(R_WHEEL_HEALTH)).floatValue());
        compound.m_128350_("MainEngineHealth", ((Float)this.f_19804_.m_135370_(MAIN_ENGINE_HEALTH)).floatValue());
        compound.m_128350_("SubEngineHealth", ((Float)this.f_19804_.m_135370_(SUB_ENGINE_HEALTH)).floatValue());
        compound.m_128379_("TurretDamaged", ((Boolean)this.f_19804_.m_135370_(TURRET_DAMAGED)).booleanValue());
        compound.m_128379_("LeftWheelDamaged", ((Boolean)this.f_19804_.m_135370_(L_WHEEL_DAMAGED)).booleanValue());
        compound.m_128379_("RightWheelDamaged", ((Boolean)this.f_19804_.m_135370_(R_WHEEL_DAMAGED)).booleanValue());
        compound.m_128379_("MainEngineDamaged", ((Boolean)this.f_19804_.m_135370_(MAIN_ENGINE_DAMAGED)).booleanValue());
        compound.m_128379_("SubEngineDamaged", ((Boolean)this.f_19804_.m_135370_(SUB_ENGINE_DAMAGED)).booleanValue());
        compound.m_128350_("Power", ((Float)this.f_19804_.m_135370_(POWER)).floatValue());
        compound.m_128379_("DecoyReady", ((Boolean)this.f_19804_.m_135370_(DECOY_READY)).booleanValue());
        compound.m_128350_("GearRot", ((Float)this.f_19804_.m_135370_(GEAR_ROT)).floatValue());
        compound.m_128379_("GearUp", ((Boolean)this.f_19804_.m_135370_(GEAR_UP)).booleanValue());
        compound.m_128350_("PropellerRot", ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
        compound.m_128350_("ChargeProgress", ((Float)this.f_19804_.m_135370_(CHARGE_PROGRESS)).floatValue());
        compound.m_128350_("ServerYaw", ((Float)this.f_19804_.m_135370_(SERVER_YAW)).floatValue());
        compound.m_128350_("ServerPitch", ((Float)this.f_19804_.m_135370_(SERVER_PITCH)).floatValue());
        if (this.getMaxPassengers() > 0) {
            compound.m_128385_("SelectedWeapon", ((IntList)this.f_19804_.m_135370_(SELECTED_WEAPON)).toIntArray());
        }
        if (this.hasEnergyStorage()) {
            compound.m_128365_("Energy", this.energyStorage.serializeNBT());
        }
        this.resizeItems();
        ContainerHelper.m_18973_((CompoundTag)compound, this.m_213659_());
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        if (player.m_20202_() == this) {
            return InteractionResult.PASS;
        }
        if (this.hasMenu() && player.m_6144_() && !player.m_21205_().m_204117_(ModTags.Items.TOOLS_CROWBAR)) {
            player.m_5893_((MenuProvider)this);
            return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
        }
        if (player.m_20202_() == this) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_150930_((Item)ModItems.VEHICLE_DAMAGE_ANALYZER.get())) {
            if (!this.m_9236_().f_46443_) {
                if (this.damageDebugResultReceiver != null) {
                    this.damageDebugResultReceiver = null;
                    player.m_5661_((Component)Component.m_237110_((String)"des.superbwarfare.vehicle_damage_analyzer.unbind", (Object[])new Object[]{this.m_5446_()}), true);
                } else {
                    this.damageDebugResultReceiver = player;
                    player.m_5661_((Component)Component.m_237110_((String)"des.superbwarfare.vehicle_damage_analyzer.bind", (Object[])new Object[]{this.m_5446_()}), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && stack.m_204117_(ModTags.Items.TOOLS_CROWBAR) && this.m_20197_().isEmpty()) {
            for (ItemStack item : this.getRetrieveItems()) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)item);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6144_() && this.getMaxPassengers() > 0) {
            List entities = this.m_20197_();
            for (Entity passenger : entities) {
                if (passenger.m_5647_() == null || !TDMSavedData.enabledTDM(passenger) && passenger.m_5647_() == player.m_5647_()) continue;
                return InteractionResult.PASS;
            }
            if (this.getLastDriver() != null && !SeekTool.IN_SAME_TEAM.test((Entity)player, this.getLastDriver()) && this.getLastDriver().m_5647_() != null) {
                return InteractionResult.PASS;
            }
            if (this.m_146895_() == null) {
                if (player instanceof FakePlayer) {
                    return InteractionResult.PASS;
                }
                VehicleVecUtils.setDriverAngle(this, player);
                player.m_6858_(false);
                if (player.m_9236_() instanceof ServerLevel) {
                    return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
                }
            } else if (!(this.m_146895_() instanceof Player)) {
                if (player instanceof FakePlayer) {
                    return InteractionResult.PASS;
                }
                this.m_146895_().m_8127_();
                VehicleVecUtils.setDriverAngle(this, player);
                player.m_6858_(false);
                if (player.m_9236_() instanceof ServerLevel) {
                    return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
                }
            }
            if (this.m_7310_((Entity)player)) {
                if (player instanceof FakePlayer) {
                    return InteractionResult.PASS;
                }
                player.m_6858_(false);
                if (player.m_9236_() instanceof ServerLevel) {
                    return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public Entity getLastDriver() {
        return EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(LAST_DRIVER_UUID));
    }

    @Deprecated(forRemoval=true)
    public void setDriverAngle(Player player) {
        VehicleVecUtils.setDriverAngle(this, player);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Projectile projectile;
        OBBHitter accessor;
        OBB.Part part;
        Entity entity;
        if (source.m_269533_(ModTags.DamageTypes.VEHICLE_IMMUNE)) {
            return false;
        }
        if (DamageTypeTool.isGunDamage(source) && source.m_7639_() != null && source.m_7639_().m_20202_() == this) {
            return false;
        }
        if (source.m_7639_() != null && this.getLastDriver() != null && SeekTool.IS_FRIENDLY.test(this.getLastDriver(), source.m_7639_()) && this.getLastDriver().m_5647_() != null && source.m_7639_().m_5647_() != null && source.m_7639_().m_5647_() == this.getLastDriver().m_5647_() && !source.m_7639_().m_5647_().m_6260_() && source.m_7639_() == this.getLastDriver() && !source.m_276093_(ModDamageTypes.VEHICLE_STRIKE)) {
            return false;
        }
        if (this.damageDebugResultReceiver != null) {
            this.damageDebugResultReceiver.m_213846_((Component)DamageHandler.getDamageInfo(this, source, amount));
        }
        float computedAmount = amount;
        if (!source.m_269533_(ModTags.DamageTypes.BYPASSES_VEHICLE)) {
            computedAmount = this.getDamageModifier().compute(source, amount);
        }
        this.crash = source.m_276093_(ModDamageTypes.VEHICLE_STRIKE);
        if (source.m_7639_() != null) {
            this.f_19804_.m_135381_(LAST_ATTACKER_UUID, (Object)source.m_7639_().m_20149_());
        }
        if ((entity = source.m_7640_()) instanceof Projectile && (part = (accessor = OBBHitter.getInstance((Entity)(projectile = (Projectile)entity))).sbw$getCurrentHitPart()) != null) {
            switch (part) {
                case TURRET: {
                    this.f_19804_.m_135381_(TURRET_HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(TURRET_HEALTH)).floatValue() - computedAmount));
                    break;
                }
                case WHEEL_LEFT: {
                    this.f_19804_.m_135381_(L_WHEEL_HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(L_WHEEL_HEALTH)).floatValue() - computedAmount));
                    break;
                }
                case WHEEL_RIGHT: {
                    this.f_19804_.m_135381_(R_WHEEL_HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(R_WHEEL_HEALTH)).floatValue() - computedAmount));
                    break;
                }
                case MAIN_ENGINE: {
                    this.f_19804_.m_135381_(MAIN_ENGINE_HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(MAIN_ENGINE_HEALTH)).floatValue() - computedAmount));
                    break;
                }
                case SUB_ENGINE: {
                    this.f_19804_.m_135381_(SUB_ENGINE_HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(SUB_ENGINE_HEALTH)).floatValue() - computedAmount));
                }
            }
        }
        this.onHurt(computedAmount, source.m_7639_(), true);
        return super.m_6469_(source, computedAmount);
    }

    public DamageModifier getDamageModifier() {
        return this.data().damageModifier();
    }

    public float getSourceAngle(DamageSource source, float multiplier) {
        return VehicleVecUtils.getDamageSourceAngle(this, source, multiplier);
    }

    public void heal(float pHealAmount) {
        if (this.m_9236_() instanceof ServerLevel) {
            this.setHealth(this.getHealth() + pHealAmount);
        }
    }

    public void onHurt(float pHealAmount, Entity attacker, boolean send) {
        if (this.m_9236_() instanceof ServerLevel) {
            Holder holder = Holder.m_205709_((Object)((SoundEvent)ModSounds.INDICATION_VEHICLE.get()));
            if (attacker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)attacker;
                if (pHealAmount > 0.0f && this.getHealth() > 0.0f && send && !(this instanceof DroneEntity)) {
                    player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.m_20185_(), player.m_20188_(), player.m_20189_(), 0.25f + 2.75f * pHealAmount / this.getMaxHealth(), this.f_19796_.m_188501_() * 0.1f + 0.9f, player.m_9236_().f_46441_.m_188505_()));
                    NetworkRegistry.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(3, 5));
                }
            }
            if (pHealAmount > 0.0f && this.getHealth() > 0.0f && send) {
                this.repairCoolDown = this.maxRepairCoolDown();
                List passengers = this.m_20197_();
                for (Entity entity : passengers) {
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer player1 = (ServerPlayer)entity;
                    player1.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player1.m_20185_(), player1.m_20188_(), player1.m_20189_(), 0.25f + 4.75f * pHealAmount / this.getMaxHealth(), this.f_19796_.m_188501_() * 0.1f + 0.6f, player1.m_9236_().f_46441_.m_188505_()));
                }
            }
            this.setHealth(this.getHealth() - pHealAmount);
        }
    }

    public float getHealth() {
        return ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue();
    }

    public void setHealth(float pHealth) {
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(Mth.m_14036_((float)pHealth, (float)0.0f, (float)this.getMaxHealth())));
    }

    public float getMaxHealth() {
        return this.computed().maxHealth;
    }

    public float getTurretMaxHealth() {
        return 50.0f;
    }

    public float getWheelMaxHealth() {
        return 50.0f;
    }

    public float getEngineMaxHealth() {
        return 50.0f;
    }

    public void m_20093_() {
        if (this.f_19797_ % 10 == 0) {
            this.m_6469_(this.m_269291_().m_269233_(), 4.0f);
        }
    }

    @ParametersAreNonnullByDefault
    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_((SoundEvent)ModSounds.WHEEL_VEHICLE_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.1), this.f_19796_.m_188501_() * 0.15f + 1.05f);
    }

    public boolean m_5829_() {
        return this.enableAABB();
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_7313_(@NotNull Entity attacker) {
        return this.m_20363_(attacker) || super.m_7313_(attacker);
    }

    protected boolean m_7310_(@NotNull Entity pPassenger) {
        return this.m_20197_().size() < this.getMaxPassengers();
    }

    public int getMaxPassengers() {
        return this.computed().seats().size();
    }

    public int maxRepairCoolDown() {
        return this.computed().repairCooldown;
    }

    public float repairAmount() {
        return this.computed().repairAmount;
    }

    public void m_6075_() {
        List<Vec3> terrainCompat;
        Mob mob;
        Entity entity;
        DefaultVehicleData computed = this.computed();
        if (this.m_9236_().f_46443_) {
            if (!this.wasEngineRunning && this.engineRunning()) {
                playEngineSound.accept(this);
                playSwimSound.accept(this);
                if (computed.engineType == EngineType.TRACK) {
                    playTrackSound.accept(this);
                }
            }
            if (!this.wasHornWorking && this.hornWorking()) {
                playHornSound.accept(this);
            }
            if (playFireSound != null && !this.wasFiring && this.isFiring()) {
                playFireSound.accept(this);
            }
            this.wasFiring = this.isFiring();
        }
        if (!this.m_9236_().f_46443_) {
            HashMap<String, GunData> newMap = new HashMap<String, GunData>();
            for (Map.Entry<String, GunData> kv : this.getGunDataMap().entrySet()) {
                GunData newData = kv.getValue().copy();
                newData.tick(this, true);
                newMap.put(kv.getKey(), newData);
            }
            this.f_19804_.m_276349_(GUN_DATA_MAP, newMap, true);
        }
        this.wasEngineRunning = this.engineRunning();
        this.wasHornWorking = this.hornWorking();
        this.turretYRotO = this.getTurretYRot();
        this.turretXRotO = this.getTurretXRot();
        this.gunYRotO = this.getGunYRot();
        this.gunXRotO = this.getGunXRot();
        this.leftWheelRotO = this.getLeftWheelRot();
        this.rightWheelRotO = this.getRightWheelRot();
        this.leftTrackO = this.getLeftTrack();
        this.rightTrackO = this.getRightTrack();
        this.rudderRotO = this.getRudderRot();
        this.propellerRotO = this.getPropellerRot();
        this.recoilShakeO = this.getRecoilShake();
        this.velocityO = this.getVelocity();
        if (this.jumpCoolDown > 0 && this.m_20096_()) {
            --this.jumpCoolDown;
        }
        this.lastTickSpeed = new Vec3(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + 0.06, this.m_20184_().f_82481_).m_82553_();
        this.lastTickVerticalSpeed = this.m_20184_().f_82480_ + 0.06;
        if (this.collisionCoolDown > 0) {
            --this.collisionCoolDown;
        }
        this.f_19804_.m_135381_(LASER_SCALE_O, (Object)((Float)this.f_19804_.m_135370_(LASER_SCALE)));
        this.flap1LRotO = this.getFlap1LRot();
        this.flap1RRotO = this.getFlap1RRot();
        this.flap1L2RotO = this.getFlap1L2Rot();
        this.flap1R2RotO = this.getFlap1R2Rot();
        this.flap2LRotO = this.getFlap2LRot();
        this.flap2RRotO = this.getFlap2RRot();
        this.flap3RotO = this.getFlap3Rot();
        this.gearRotO = this.getGearRot();
        super.m_6075_();
        if (((Float)this.f_19804_.m_135370_(LASER_SCALE)).floatValue() > 0.0f) {
            this.f_19804_.m_135381_(LASER_SCALE, (Object)Float.valueOf(org.joml.Math.max((float)(((Float)this.f_19804_.m_135370_(LASER_SCALE)).floatValue() - 0.1f), (float)0.0f)));
            this.f_19804_.m_135381_(LASER_SCALE, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(LASER_SCALE)).floatValue() * 0.9f));
        }
        if (((Float)this.f_19804_.m_135370_(LASER_SCALE)).floatValue() == 0.0f) {
            this.f_19804_.m_135381_(LASER_LENGTH, (Object)Float.valueOf(0.0f));
        }
        if (this.repairCoolDown > 0) {
            --this.repairCoolDown;
        }
        if (this.getHealth() >= this.getMaxHealth()) {
            this.repairCoolDown = this.maxRepairCoolDown();
        }
        this.prevRoll = this.getRoll();
        float delta = org.joml.Math.abs((float)(this.m_146908_() - this.f_19859_));
        while (this.m_146908_() > 180.0f) {
            this.m_146922_(this.m_146908_() - 360.0f);
            this.f_19859_ = this.m_146908_() - delta;
        }
        while (this.m_146908_() <= -180.0f) {
            this.m_146922_(this.m_146908_() + 360.0f);
            this.f_19859_ = delta + this.m_146908_();
        }
        float deltaX = org.joml.Math.abs((float)(this.m_146909_() - this.f_19860_));
        while (this.m_146909_() > 180.0f) {
            this.m_146926_(this.m_146909_() - 360.0f);
            this.f_19860_ = this.m_146909_() - deltaX;
        }
        while (this.m_146909_() <= -180.0f) {
            this.m_146926_(this.m_146909_() + 360.0f);
            this.f_19860_ = deltaX + this.m_146909_();
        }
        float deltaZ = org.joml.Math.abs((float)(this.getRoll() - this.prevRoll));
        while (this.getRoll() > 180.0f) {
            this.setZRot(this.getRoll() - 360.0f);
            this.prevRoll = this.getRoll() - deltaZ;
        }
        while (this.getRoll() <= -180.0f) {
            this.setZRot(this.getRoll() + 360.0f);
            this.prevRoll = deltaZ + this.getRoll();
        }
        this.handleClientSync();
        if (this.m_9236_() instanceof ServerLevel && this.getHealth() <= 0.0f) {
            this.destroy();
        }
        this.travel();
        if (this.getHealth() <= computed.selfHurtPercent * this.getMaxHealth()) {
            this.onHurt(computed.selfHurtAmount, this.getLastAttacker(), false);
        } else if (this.repairCoolDown == 0) {
            this.heal(this.repairAmount());
        }
        if (this.getMaxPassengers() > 0 && this.m_146895_() != null) {
            this.f_19804_.m_135381_(LAST_DRIVER_UUID, (Object)this.m_146895_().m_20149_());
        }
        if (this.m_20197_().isEmpty()) {
            ++this.noPassengerTime;
            if (this.noPassengerTime > 200) {
                this.f_19804_.m_135381_(LAST_DRIVER_UUID, (Object)"undefined");
            }
        } else {
            this.noPassengerTime = 0;
        }
        this.clearArrow();
        this.f_19804_.m_135381_(MOUSE_SPEED_X, (Object)Float.valueOf(this.getMouseMoveSpeedX() * 0.95f));
        this.f_19804_.m_135381_(MOUSE_SPEED_Y, (Object)Float.valueOf(this.getMouseMoveSpeedY() * 0.95f));
        if (this.hasTurret()) {
            if (this.getNthEntity(this.getTurretControllerIndex()) instanceof Player) {
                this.adjustTurretAngle();
            } else {
                entity = this.getNthEntity(this.getTurretControllerIndex());
                if (entity instanceof Mob) {
                    mob = (Mob)entity;
                    this.turretAutoAimFromUuid((String)this.f_19804_.m_135370_(AI_TURRET_TARGET_UUID), (LivingEntity)mob);
                }
            }
        }
        if (this.hasPassengerWeaponStation()) {
            if (this.getNthEntity(this.getPassengerWeaponStationControllerIndex()) instanceof Player || this.getNthEntity(this.getPassengerWeaponStationControllerIndex()) == null) {
                this.adjustWeaponControllerAngle();
            } else {
                entity = this.getNthEntity(this.getPassengerWeaponStationControllerIndex());
                if (entity instanceof Mob) {
                    mob = (Mob)entity;
                    this.passengerWeaponAutoAimFormUuid((String)this.f_19804_.m_135370_(AI_PASSENGER_WEAPON_TARGET_UUID), (LivingEntity)mob);
                }
            }
        }
        for (int i = 0; i < this.data().getDefault().seats().size(); ++i) {
            ItemStack stack;
            GunData gunData;
            Entity rpm2;
            Mob mob2;
            Entity entity2 = this.getNthEntity(i);
            if (entity2 instanceof Mob && this.canShoot((LivingEntity)(mob2 = (Mob)entity2)) && mob2.m_5448_() != null && this.getGunData((Entity)mob2) != null && mob2.m_9236_() instanceof ServerLevel) {
                mob2.m_21391_((Entity)mob2.m_5448_(), 30.0f, 30.0f);
                int rpm2 = (int)org.joml.Math.ceil((float)(20.0f / ((float)this.vehicleWeaponRpm((LivingEntity)mob2) / 60.0f)));
                if (this.f_19797_ % rpm2 == 0 && this.canShoot((LivingEntity)mob2) && VectorTool.calculateAngle(this.getShootDirectionForHud((Entity)mob2, 1.0f), this.getShootPos((Entity)mob2, 1.0f).m_82505_(VectorTool.lerpGetEntityBoundingBoxCenter((Entity)mob2.m_5448_(), 1.0f))) < 4.0) {
                    this.vehicleShoot((LivingEntity)mob2, mob2.m_5448_().m_20148_(), null);
                }
            }
            if (!((rpm2 = this.getNthEntity(i)) instanceof Player)) continue;
            Player player = (Player)rpm2;
            if (!(this.m_9236_() instanceof ServerLevel) || (gunData = this.getGunData((Entity)player)) == null) continue;
            if (gunData.selectedAmmoConsumer().type == AmmoConsumer.AmmoConsumeType.ENERGY) {
                if (this.canConsume(gunData.compute().ammoCostPerShoot)) continue;
                player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.not.enough.energy"), true);
                continue;
            }
            if (this.getAmmoCount((LivingEntity)player) >= gunData.compute().ammoCostPerShoot || (stack = gunData.selectedAmmoConsumer().stack()) == ItemStack.f_41583_ || InventoryTool.hasCreativeAmmoBox(this) || gunData.reloading()) continue;
            player.m_5661_((Component)Component.m_237115_((String)"tips.superbwarfare.need.ammo").m_7220_((Component)Component.m_237113_((String)"[").m_7220_(stack.m_41786_()).m_130946_("]").m_130940_(ChatFormatting.YELLOW)), true);
        }
        Vec3 currentVelocity = this.m_20184_();
        Vec3 accelerationVec = currentVelocity.m_82546_(this.previousVelocity).m_82490_(20.0);
        this.acceleration = accelerationVec.m_82553_() * 20.0;
        this.previousVelocity = currentVelocity;
        double direct = (90.0 - VehicleVecUtils.calculateAngle(this.m_20184_(), this.m_20252_(1.0f))) / 90.0;
        this.setVelocity(Mth.m_14139_((double)0.4, (double)this.getVelocity(), (double)(this.m_20184_().m_165924_() * direct * 20.0)));
        float deltaT = Math.abs(this.getTurretYRot() - this.turretYRotO);
        while (this.getTurretYRot() > 180.0f) {
            this.setTurretYRot(this.getTurretYRot() - 360.0f);
            this.turretYRotO = this.getTurretYRot() - deltaT;
        }
        while (this.getTurretYRot() <= -180.0f) {
            this.setTurretYRot(this.getTurretYRot() + 360.0f);
            this.turretYRotO = deltaT + this.getTurretYRot();
        }
        if (this.decoyReloadCoolDown > 0) {
            --this.decoyReloadCoolDown;
        }
        if ((Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME) > 0) {
            this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)((Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME) - 1));
        }
        this.setRecoilShake((double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(CANNON_RECOIL_FORCE)).floatValue()) * 7.0E-7 * Math.pow(((Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME)).intValue(), 4.0) * Math.sin(0.6283185307179586 * ((double)((Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME)).intValue() - 2.5)));
        this.f_19804_.m_135381_(CANNON_RECOIL_FORCE, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(CANNON_RECOIL_FORCE)).floatValue() * 0.93f));
        this.preventStacking();
        this.supportEntities();
        this.crushEntities();
        this.m_20256_(this.m_20184_().m_82520_(0.0, -this.computed().gravity, 0.0));
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.collideBlocks();
        this.moveOnDragonTeeth();
        if (this.hasEnergyStorage() && this.f_19797_ % 20 == 0) {
            for (ItemStack stack : this.m_213659_()) {
                IEnergyStorage energyStorage;
                int stored;
                int neededEnergy = this.getMaxEnergy() - this.getEnergy();
                if (neededEnergy <= 0) break;
                Optional energyCap = stack.getCapability(ForgeCapabilities.ENERGY).resolve();
                if (energyCap.isEmpty() || (stored = (energyStorage = (IEnergyStorage)energyCap.get()).getEnergyStored()) <= 0) continue;
                int energyToExtract = org.joml.Math.min((int)stored, (int)neededEnergy);
                energyStorage.extractEnergy(energyToExtract, false);
                this.setEnergy(this.getEnergy() + energyToExtract);
            }
        }
        if (this.m_9236_() instanceof ServerLevel) {
            this.updateBackupAmmoCount();
        }
        this.f_19804_.m_135381_(HORN_VOLUME, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(HORN_VOLUME)).floatValue() * 0.5f));
        if (this.hasDecoy()) {
            if (this.getVehicleType() == VehicleType.AIRPLANE || this.getVehicleType() == VehicleType.HELICOPTER) {
                this.releaseDecoy();
            } else {
                this.releaseSmokeDecoy(this.getTurretVector(1.0f));
            }
        }
        if ((terrainCompat = this.computed().terrainCompat) != null) {
            this.terrainCompact(terrainCompat);
        }
        this.inertiaRotate(this.computed().inertiaRotateRate);
        if (this.getLeftTrack() < 0.0f) {
            this.setLeftTrack(this.getTrackAnimationLength());
        }
        if (this.getLeftTrack() > (float)this.getTrackAnimationLength()) {
            this.setLeftTrack(0.0f);
        }
        if (this.getRightTrack() < 0.0f) {
            this.setRightTrack(this.getTrackAnimationLength());
        }
        if (this.getRightTrack() > (float)this.getTrackAnimationLength()) {
            this.setRightTrack(0.0f);
        }
        this.lowHealthWarning();
        this.m_6210_();
        if (!this.enableAABB()) {
            this.handlePartDamaged(this);
            this.handlePartHealth();
            this.updateOBB();
        }
    }

    public boolean m_142079_() {
        return false;
    }

    public void updateOBB() {
        this.getOBB().forEach(obbInfo -> {
            Matrix4d transform = this.getTransformFromString(obbInfo.transform);
            OBB obb = obbInfo.getOBB();
            Vector4d worldPos = this.transformPosition(transform, obbInfo.position.f_82479_, obbInfo.position.f_82480_, obbInfo.position.f_82481_);
            obb.center().set((Vector3dc)OBB.vec3ToVector3d(new Vec3(worldPos.x, worldPos.y, worldPos.z)));
            obb.setRotation(this.getRotationFromString(obbInfo.rotation));
        });
    }

    public SoundEvent getShootSoundInstance() {
        GunData gunData = this.getGunData(0);
        if (gunData != null) {
            SoundEvent instance = gunData.compute().soundInfo.fireSoundInstances;
            if (instance != null) {
                return instance;
            }
        } else {
            return this.getShootSoundInstance("Main");
        }
        return SoundEvents.f_271165_;
    }

    public SoundEvent getShootSoundInstance(String weaponName) {
        SoundEvent instance;
        GunData gunData = this.getGunData(weaponName);
        if (gunData != null && (instance = gunData.compute().soundInfo.fireSoundInstances) != null) {
            return instance;
        }
        return SoundEvents.f_271165_;
    }

    public boolean isFiring() {
        GunData gunData = this.getGunData(0);
        if (gunData != null) {
            SoundEvent instance = gunData.compute().soundInfo.fireSoundInstances;
            if (instance != null) {
                return gunData.shootTimer.get() > 0;
            }
            return false;
        }
        return false;
    }

    public float shootingVolume() {
        GunData gunData = this.getGunData(0);
        if (gunData != null) {
            return (float)gunData.shootTimer.get() * 0.25f;
        }
        return 0.0f;
    }

    public float shootingPitch() {
        GunData gunData = this.getGunData(0);
        if (gunData != null) {
            return (float)((double)(0.98f + (float)gunData.shootTimer.get() * 0.01f) - (gunData.heat.get() > 80.0 ? (gunData.heat.get() - 80.0) * 0.01 : 0.0));
        }
        return 1.0f;
    }

    protected void updateBackupAmmoCount() {
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            this.modifyGunData(i, (GunData data) -> {
                if (data.useBackpackAmmo()) {
                    data.backupAmmoCount.set(data.countBackupAmmo(this.getAmmoSupplier()));
                } else {
                    data.backupAmmoCount.reset();
                }
            });
        }
    }

    public Entity getAmmoSupplier() {
        return this;
    }

    public void handlePartDamaged(OBBEntity obbEntity) {
        List<OBB> obbList = obbEntity.getOBBs();
        for (OBB obb : obbList) {
            Vec3 pos = OBB.vector3dToVec3(obb.center());
            switch (obb.part()) {
                case TURRET: {
                    if (!((Boolean)this.f_19804_.m_135370_(TURRET_DAMAGED)).booleanValue()) break;
                    this.onTurretDamaged(pos);
                    break;
                }
                case WHEEL_LEFT: {
                    if (!((Boolean)this.f_19804_.m_135370_(L_WHEEL_DAMAGED)).booleanValue()) break;
                    this.onLeftWheelDamaged(pos);
                    break;
                }
                case WHEEL_RIGHT: {
                    if (!((Boolean)this.f_19804_.m_135370_(R_WHEEL_DAMAGED)).booleanValue()) break;
                    this.onRightWheelDamaged(pos);
                    break;
                }
                case MAIN_ENGINE: {
                    if (!((Boolean)this.f_19804_.m_135370_(MAIN_ENGINE_DAMAGED)).booleanValue()) break;
                    this.onEngine1Damaged(pos);
                    break;
                }
                case SUB_ENGINE: {
                    if (!((Boolean)this.f_19804_.m_135370_(SUB_ENGINE_DAMAGED)).booleanValue()) break;
                    this.onEngine2Damaged(pos);
                }
            }
        }
    }

    public void handlePartHealth() {
        if (((Float)this.f_19804_.m_135370_(TURRET_HEALTH)).floatValue() < 0.0f) {
            this.f_19804_.m_135381_(TURRET_DAMAGED, (Object)true);
        } else if ((double)((Float)this.f_19804_.m_135370_(TURRET_HEALTH)).floatValue() > 0.95 * (double)this.getTurretMaxHealth()) {
            this.f_19804_.m_135381_(TURRET_DAMAGED, (Object)false);
        }
        if (((Float)this.f_19804_.m_135370_(L_WHEEL_HEALTH)).floatValue() < 0.0f) {
            this.f_19804_.m_135381_(L_WHEEL_DAMAGED, (Object)true);
        } else if ((double)((Float)this.f_19804_.m_135370_(L_WHEEL_HEALTH)).floatValue() > 0.95 * (double)this.getWheelMaxHealth()) {
            this.f_19804_.m_135381_(L_WHEEL_DAMAGED, (Object)false);
        }
        if (((Float)this.f_19804_.m_135370_(R_WHEEL_HEALTH)).floatValue() < 0.0f) {
            this.f_19804_.m_135381_(R_WHEEL_DAMAGED, (Object)true);
        } else if ((double)((Float)this.f_19804_.m_135370_(R_WHEEL_HEALTH)).floatValue() > 0.95 * (double)this.getWheelMaxHealth()) {
            this.f_19804_.m_135381_(R_WHEEL_DAMAGED, (Object)false);
        }
        if (((Float)this.f_19804_.m_135370_(MAIN_ENGINE_HEALTH)).floatValue() < 0.0f) {
            this.f_19804_.m_135381_(MAIN_ENGINE_DAMAGED, (Object)true);
        } else if ((double)((Float)this.f_19804_.m_135370_(MAIN_ENGINE_HEALTH)).floatValue() > 0.95 * (double)this.getEngineMaxHealth()) {
            this.f_19804_.m_135381_(MAIN_ENGINE_DAMAGED, (Object)false);
        }
        if (((Float)this.f_19804_.m_135370_(SUB_ENGINE_HEALTH)).floatValue() < 0.0f) {
            this.f_19804_.m_135381_(SUB_ENGINE_DAMAGED, (Object)true);
        } else if ((double)((Float)this.f_19804_.m_135370_(SUB_ENGINE_HEALTH)).floatValue() > 0.95 * (double)this.getEngineMaxHealth()) {
            this.f_19804_.m_135381_(SUB_ENGINE_DAMAGED, (Object)false);
        }
        this.f_19804_.m_135381_(TURRET_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.f_19804_.m_135370_(TURRET_HEALTH)).floatValue() + 0.0025f * this.getTurretMaxHealth()), (float)this.getTurretMaxHealth())));
        this.f_19804_.m_135381_(L_WHEEL_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.f_19804_.m_135370_(L_WHEEL_HEALTH)).floatValue() + 0.0025f * this.getWheelMaxHealth()), (float)this.getWheelMaxHealth())));
        this.f_19804_.m_135381_(R_WHEEL_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.f_19804_.m_135370_(R_WHEEL_HEALTH)).floatValue() + 0.0025f * this.getWheelMaxHealth()), (float)this.getWheelMaxHealth())));
        this.f_19804_.m_135381_(MAIN_ENGINE_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.f_19804_.m_135370_(MAIN_ENGINE_HEALTH)).floatValue() + 0.0025f * this.getEngineMaxHealth()), (float)this.getEngineMaxHealth())));
        this.f_19804_.m_135381_(SUB_ENGINE_HEALTH, (Object)Float.valueOf(org.joml.Math.min((float)(((Float)this.f_19804_.m_135370_(SUB_ENGINE_HEALTH)).floatValue() + 0.0025f * this.getEngineMaxHealth()), (float)this.getEngineMaxHealth())));
    }

    public void addRandomParticle(ParticleOptions particleOptions, Vec3 pos, float randomPos, Level level, float speed, int count) {
        float randomX = 2.0f * (this.f_19796_.m_188501_() - 0.5f);
        float randomY = 2.0f * (this.f_19796_.m_188501_() - 0.5f);
        float randomZ = 2.0f * (this.f_19796_.m_188501_() - 0.5f);
        for (double i = 0.0; i < (double)count; i += 1.0) {
            level.m_6485_(particleOptions, true, pos.f_82479_ + (double)(randomPos * randomX), pos.f_82480_ + (double)(randomPos * randomY), pos.f_82481_ + (double)(randomPos * randomZ), (double)(randomX * speed), (double)(randomY * speed), (double)(randomZ * speed));
        }
    }

    public void defaultPartDamageEffect(Vec3 pos) {
        if (this.m_9236_().f_46443_) {
            this.addRandomParticle((ParticleOptions)ModParticleTypes.FIRE_STAR.get(), pos, 0.0f, this.m_9236_(), 0.25f, 5);
            this.addRandomParticle((ParticleOptions)ParticleTypes.f_123755_, pos, 0.5f, this.m_9236_(), 0.001f, 1);
        }
    }

    public void onTurretDamaged(Vec3 pos) {
        this.defaultPartDamageEffect(pos);
    }

    public void onLeftWheelDamaged(Vec3 pos) {
        this.defaultPartDamageEffect(pos);
    }

    public void onRightWheelDamaged(Vec3 pos) {
        this.defaultPartDamageEffect(pos);
    }

    public void onEngine1Damaged(Vec3 pos) {
        this.defaultPartDamageEffect(pos);
    }

    public void onEngine2Damaged(Vec3 pos) {
        this.defaultPartDamageEffect(pos);
    }

    public void clearArrow() {
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(0.0, 0.5, 0.0), e -> e instanceof AbstractArrow);
        list.forEach(Entity::m_146870_);
    }

    public void lowHealthWarning() {
        if (!this.data().compute().hasLowHealthWarning) {
            return;
        }
        if ((double)this.getHealth() <= 0.4 * (double)this.getMaxHealth()) {
            this.addRandomParticle((ParticleOptions)ParticleTypes.f_123755_, new Vec3(this.m_20185_(), this.m_20186_() + (double)(0.7f * this.m_20206_()), this.m_20189_()), 0.35f * this.m_20205_(), this.m_9236_(), 0.01f, 1);
        }
        if ((double)this.getHealth() <= 0.25 * (double)this.getMaxHealth()) {
            this.playLowHealthParticle();
        }
        if ((double)this.getHealth() <= 0.15 * (double)this.getMaxHealth()) {
            this.playLowHealthParticle();
        }
        if ((double)this.getHealth() <= 0.1 * (double)this.getMaxHealth()) {
            if (this.m_9236_().f_46443_) {
                float random = 2.0f * (this.f_19796_.m_188501_() - 0.5f);
                this.addRandomParticle((ParticleOptions)ParticleTypes.f_123755_, new Vec3(this.m_20185_(), this.m_20186_() + (double)(0.7f * this.m_20206_()), this.m_20189_()), 0.35f * this.m_20205_(), this.m_9236_(), 0.01f, 2);
                this.addRandomParticle((ParticleOptions)ParticleTypes.f_123777_, new Vec3(this.m_20185_(), this.m_20186_() + (double)(0.7f * this.m_20206_()), this.m_20189_()), 0.35f * this.m_20205_(), this.m_9236_(), 0.01f, 2);
                this.addRandomParticle(new CustomCloudOption(1.0f, 0.1f, 0.0f, (int)(240.0f + 40.0f * random), 2.5f + 0.5f * random, -0.07f, true, true), new Vec3(this.m_20185_(), this.m_20186_() + (double)(0.85f * this.m_20206_()), this.m_20189_()), 0.35f * this.m_20205_(), this.m_9236_(), 0.01f, 1);
                this.addRandomParticle(new CustomCloudOption(1.0f, 0.35f, 0.0f, (int)(80.0f + 40.0f * random), 1.5f + 0.5f * random, -0.07f, false, true), new Vec3(this.m_20185_(), this.m_20186_() + (double)(0.85f * this.m_20206_()), this.m_20189_()), 0.3f * this.m_20205_(), this.m_9236_(), 0.01f, 1);
            }
            if (this.f_19797_ % 15 == 0) {
                this.m_9236_().m_5594_(null, this.m_20097_(), SoundEvents.f_11936_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        if (this.getHealth() < 0.1f * this.getMaxHealth() && this.f_19797_ % 13 == 0) {
            this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.NO_HEALTH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (this.getHealth() >= 0.1f && this.getHealth() < 0.4f * this.getMaxHealth() && this.f_19797_ % 10 == 0) {
            this.m_9236_().m_5594_(null, this.m_20097_(), (SoundEvent)ModSounds.LOW_HEALTH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void playLowHealthParticle() {
        if (this.m_9236_().f_46443_) {
            this.addRandomParticle((ParticleOptions)ParticleTypes.f_123755_, new Vec3(this.m_20185_(), this.m_20186_() + (double)(0.7f * this.m_20206_()), this.m_20189_()), 0.35f * this.m_20205_(), this.m_9236_(), 0.01f, 1);
            this.addRandomParticle((ParticleOptions)ParticleTypes.f_123777_, new Vec3(this.m_20185_(), this.m_20186_() + (double)(0.7f * this.m_20206_()), this.m_20189_()), 0.35f * this.m_20205_(), this.m_9236_(), 0.01f, 1);
        }
    }

    public void adjustTurretAngle() {
        VehicleWeaponUtils.adjustTurretAngle(this);
    }

    public int getSelectedWeapon(int seatIndex) {
        IntList selectedWeapon = (IntList)this.f_19804_.m_135370_(SELECTED_WEAPON);
        return selectedWeapon.getInt(seatIndex);
    }

    public void turretAutoAimFromVector(Vec3 shootVec) {
        VehicleWeaponUtils.turretAutoAimFromVector(this, shootVec);
    }

    public void turretAutoAimFromUuid(String uuid, LivingEntity pLiving) {
        VehicleWeaponUtils.turretAutoAimFromUuid(this, uuid, pLiving);
    }

    public void passengerPitch(Entity entity, float minPitch, float maxPitch, float passengerRot) {
        VehicleVecUtils.setPassengerPitch(this, entity, minPitch, maxPitch, passengerRot);
    }

    public void passengerYaw(Entity entity, float minYaw, float maxYaw, float passengerRot) {
        VehicleVecUtils.setPassengerYaw(this, entity, minYaw, maxYaw, passengerRot);
    }

    public void passengerPitchOnTurret(Entity entity, float turretMinPitch, float turretMaxPitch) {
        VehicleVecUtils.setPassengerPitchOnTurret(this, entity, turretMinPitch, turretMaxPitch);
    }

    public void passengerYawOnTurret(Entity entity, float minYaw, float maxYaw, float passengerRot, boolean rotateWithTurret) {
        VehicleVecUtils.setPassengerYawOnTurret(this, entity, minYaw, maxYaw, passengerRot, rotateWithTurret);
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    protected void clampRotation(Entity entity) {
        int index = this.getSeatIndex(entity);
        List<SeatInfo> seats = this.computed().seats();
        if (index < 0 || index >= seats.size()) {
            return;
        }
        SeatInfo seat = seats.get(index);
        if (seat.transform.equals("Vehicle") || seat.transform.equals("VehicleFlat") || seat.transform.equals("Turret") && seat.canRotateBody.booleanValue()) {
            if (!seat.canRotateBody.booleanValue()) {
                this.passengerYaw(entity, seat.minYaw, seat.maxYaw, seat.orientation);
            }
            if (this.hasTurret() && index == this.getTurretControllerIndex()) {
                if (seat.transform.equals("Vehicle") || seat.transform.equals("VehicleFlat")) {
                    float diffY = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
                    this.passengerPitch(entity, seat.minPitch, seat.maxPitch, diffY);
                } else {
                    this.passengerPitchOnTurret(entity, seat.minPitch, seat.maxPitch);
                    this.passengerYawOnTurret(entity, seat.minYaw, seat.maxYaw, seat.orientation, true);
                }
            } else {
                float diffY = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
                this.passengerPitch(entity, seat.minPitch, seat.maxPitch, diffY);
            }
        }
        if (seat.transform.equals("Turret") && !seat.canRotateBody.booleanValue()) {
            this.passengerPitchOnTurret(entity, seat.minPitch, seat.maxPitch);
            this.passengerYawOnTurret(entity, seat.minYaw, seat.maxYaw, seat.orientation, false);
        }
    }

    public void copyEntityData(Entity entity) {
        entity.m_146922_(entity.m_146908_() + this.destroyRot);
        int index = this.getSeatIndex(entity);
        SeatInfo seat = this.computed().seats().get(index);
        if (seat.transform.equals("Vehicle") || seat.transform.equals("VehicleFlat")) {
            if (!seat.canRotateBody.booleanValue()) {
                entity.m_5618_(this.m_146908_() + seat.orientation);
            }
            if (!seat.canRotateHead.booleanValue()) {
                entity.m_146922_(this.m_146908_() + seat.orientation);
            }
        }
        if (seat.transform.equals("Turret") && !seat.canRotateBody.booleanValue()) {
            entity.m_5618_(this.getBarrelYRot(1.0f) + seat.orientation);
        }
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        int index = this.getSeatIndex(passenger);
        List<SeatInfo> seats = this.computed().seats();
        if (index < 0 || index >= seats.size()) {
            return;
        }
        SeatInfo seat = seats.get(index);
        this.passengerPos(passenger, callback, seat.position, seat.transform);
    }

    public void passengerPos(Entity passenger, @NotNull Entity.MoveFunction callback, Vec3 vec3, String string) {
        Vector4d worldPosition = this.transformPosition(this.getTransformFromString(string), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        passenger.m_6034_(worldPosition.x, worldPosition.y, worldPosition.z);
        callback.m_20372_(passenger, worldPosition.x, worldPosition.y, worldPosition.z);
        this.copyEntityData(passenger);
    }

    protected void registerTransforms() {
        this.positionTransform.put("VehicleFlat", this::getVehicleFlatTransform);
        this.positionTransform.put("Turret", this::getTurretTransform);
        this.positionTransform.put("Barrel", this::getBarrelTransform);
        this.positionTransform.put("WeaponStation", this::getGunTransform);
        this.positionTransform.put("WeaponStationBarrel", this::getPassengerWeaponStationBarrelTransform);
        this.positionTransform.put("Default", this::getVehicleTransform);
        this.vectorTransform.put("Turret", this::getTurretVector);
        this.vectorTransform.put("Barrel", this::getBarrelVector);
        this.vectorTransform.put("WeaponStationBarrel", this::getPassengerWeaponStationVector);
        this.vectorTransform.put("DeltaMovement", tick -> this.m_20184_().m_82541_());
        this.vectorTransform.put("Up", this::getUpVec);
        this.vectorTransform.put("Default", arg_0 -> ((VehicleEntity)this).m_20252_(arg_0));
        this.rotationTransform.put("Turret", tick -> VectorTool.combineRotationsTurret(tick.floatValue(), this));
        this.rotationTransform.put("Barrel", tick -> VectorTool.combineRotationsBarrel(tick.floatValue(), this));
        this.rotationTransform.put("RotationsYaw", tick -> VectorTool.combineRotationsYaw(tick.floatValue(), this));
        this.rotationTransform.put("Default", tick -> VectorTool.combineRotations(tick.floatValue(), this));
    }

    @NotNull
    public Matrix4d getTransformFromString(String string) {
        return this.getTransformFromString(string, 1.0f);
    }

    @NotNull
    public Matrix4d getTransformFromString(String string, float ticks) {
        return this.positionTransform.getOrDefault(string, this.positionTransform.get("Default")).apply(Float.valueOf(ticks));
    }

    @NotNull
    public Vec3 getVectorFromString(String string) {
        return this.getVectorFromString(string, 0.0f);
    }

    @NotNull
    public Vec3 getVectorFromString(String string, float ticks) {
        return this.vectorTransform.getOrDefault(string, this.vectorTransform.get("Default")).apply(Float.valueOf(ticks));
    }

    @NotNull
    public Vec3 getVectorFromString(String string, float ticks, int seatIndex) {
        Entity entity = this.getNthEntity(seatIndex);
        return switch (string) {
            case "Bomb" -> this.bombHitPos(this.getNthEntity(seatIndex)).m_82546_(this.getShootPosForHud(this.getNthEntity(seatIndex), 1.0f));
            case "Passenger" -> {
                if (entity != null) {
                    yield entity.m_20252_(ticks);
                }
                yield this.m_20252_(ticks);
            }
            default -> this.getVectorFromString(string, ticks);
        };
    }

    @NotNull
    public Quaterniond getRotationFromString(String string) {
        return this.getRotationFromString(string, 0.0f);
    }

    @NotNull
    public Quaterniond getRotationFromString(String string, float ticks) {
        return this.rotationTransform.getOrDefault(string, this.rotationTransform.get("Default")).apply(Float.valueOf(ticks));
    }

    public Vec3 getShootPos(int seatIndex, float ticks) {
        return this.getShootPos(this.getNthEntity(seatIndex), ticks);
    }

    public Vec3 bombHitPos(Entity entity) {
        GunData gunData = this.getGunData(entity);
        if (gunData != null) {
            return ProjectileCalculator.calculatePreciseImpactPoint(this.m_9236_(), this.getShootPosForHud(entity, 1.0f), this.getShootVec(entity, 1.0f), this.m_20184_().m_82553_() * gunData.compute().velocity, -this.getProjectileGravity(entity));
        }
        return Vec3.f_82478_;
    }

    public Vec3 getShootPos(Entity entity, float ticks) {
        GunData data = this.getGunData(this.getSeatIndex(entity));
        if (data != null) {
            Vec3 vec3 = data.firePosition();
            Vector4d worldPosition = this.transformPosition(this.getTransformFromString(data.compute().shootPos.transform, ticks), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        }
        return this.m_20299_(ticks);
    }

    public Vec3 getShootPos(String weaponName, float ticks) {
        GunData data = this.getGunData(weaponName);
        if (data != null) {
            Vec3 vec3 = data.firePosition();
            Vector4d worldPosition = this.transformPosition(this.getTransformFromString(data.compute().shootPos.transform, ticks), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        }
        return this.m_20299_(ticks);
    }

    public Vec3 getShootPosForHud(Entity entity, float ticks) {
        GunData data = this.getGunData(this.getSeatIndex(entity));
        if (data != null) {
            Vec3 vec3 = data.firePositionForHud();
            Vector4d worldPosition = this.transformPosition(this.getTransformFromString(data.compute().shootPos.transform, ticks), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        }
        return this.m_20299_(ticks);
    }

    public Vec3 getShootDirectionForHud(Entity entity, float partialTicks) {
        GunData data = this.getGunData(this.getSeatIndex(entity));
        if (data == null) {
            return this.m_20252_(partialTicks);
        }
        StringOrVec3 stringOrVec3 = data.fireDirectionForHud();
        if (stringOrVec3 == null) {
            return this.getViewVec(entity, partialTicks);
        }
        if (stringOrVec3.isString()) {
            return this.getVectorFromString(stringOrVec3.string, partialTicks, this.getSeatIndex(entity));
        }
        Vec3 vec3 = stringOrVec3.vec3;
        Vector4d worldPosition = this.transformPosition(this.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.f_82479_ + stringOrVec3.vec3.f_82479_, vec3.f_82480_ + stringOrVec3.vec3.f_82480_, vec3.f_82481_ + stringOrVec3.vec3.f_82481_);
        Vector4d worldPositionO = this.transformPosition(this.getTransformFromString(data.compute().shootPos.transform, partialTicks), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        Vec3 startPos = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return startPos.m_82505_(endPos).m_82541_();
    }

    public Vec3 getShootVec(int seatIndex, float ticks) {
        return this.getShootVec(this.getNthEntity(seatIndex), ticks);
    }

    public Vec3 getShootVec(Entity entity, float partialTicks) {
        return VehicleVecUtils.getShootVec(this, entity, partialTicks);
    }

    public Vec3 getShootVec(String weaponName, float partialTicks) {
        return VehicleVecUtils.getShootVec(this, weaponName, partialTicks);
    }

    public Vec3 getViewVec(Entity entity, float partialTicks) {
        return VehicleVecUtils.getViewVec(this, entity, partialTicks);
    }

    public Vec3 getViewPos(Entity entity, float partialTicks) {
        return VehicleVecUtils.getViewPos(this, entity, partialTicks);
    }

    public Vec3 getSeekVec(Entity entity, float partialTicks) {
        return VehicleVecUtils.getSeekVec(this, entity, partialTicks);
    }

    public Vec3 getSeekVec(int seatIndex, float partialTicks) {
        return VehicleVecUtils.getSeekVec(this, this.getNthEntity(seatIndex), partialTicks);
    }

    public Entity getPlayerLookAtEntityOnVehicle(Entity shooter, double entityReach, float partialTick) {
        AABB aabb;
        Vec3 eye = this.getShootPosForHud(shooter, partialTick);
        double distance = entityReach * entityReach;
        HitResult hitResult = TraceTool.pickNew(eye, 512.0, this);
        Vec3 viewVec = this.getViewVec(shooter, partialTick);
        Vec3 toVec = eye.m_82520_(viewVec.f_82479_ * entityReach, viewVec.f_82480_ * entityReach, viewVec.f_82481_ * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.m_37287_((Entity)this, (Vec3)eye, (Vec3)toVec, (AABB)(aabb = this.m_20191_().m_82369_(viewVec.m_82490_(entityReach)).m_82400_(1.0)), p -> !p.m_5833_() && p.m_6084_() && SeekTool.BASIC_FILTER.test((Entity)p) && !p.m_6095_().m_204039_(ModTags.EntityTypes.DECOY) && SeekTool.NOT_IN_SMOKE.test((Entity)p) && p != shooter && !(p instanceof Projectile), (double)distance);
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.m_6662_() == HitResult.Type.ENTITY && entityhitresult != null) {
            return entityhitresult.m_82443_();
        }
        return null;
    }

    public float getProjectileVelocity(Entity entity) {
        GunData gunData = this.getGunData(this.getSeatIndex(entity));
        if (gunData == null) {
            return 25.0f;
        }
        if (gunData.compute().addShooterDeltaMovement) {
            return (float)(this.m_20184_().m_82553_() * gunData.compute().velocity);
        }
        return (float)gunData.compute().velocity;
    }

    public float getProjectileVelocity(int seatIndex) {
        GunData gunData = this.getGunData(seatIndex);
        if (gunData == null) {
            return 25.0f;
        }
        if (gunData.compute().addShooterDeltaMovement) {
            return (float)(this.m_20184_().m_82553_() * gunData.compute().velocity);
        }
        return (float)gunData.compute().velocity;
    }

    public float getProjectileVelocity(String weaponName) {
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return 25.0f;
        }
        if (gunData.compute().addShooterDeltaMovement) {
            return (float)(this.m_20184_().m_82553_() * gunData.compute().velocity);
        }
        return (float)gunData.compute().velocity;
    }

    public float getProjectileVelocity(GunData gunData) {
        if (gunData == null) {
            return 25.0f;
        }
        if (gunData.compute().addShooterDeltaMovement) {
            return (float)(this.m_20184_().m_82553_() * gunData.compute().velocity);
        }
        return (float)gunData.compute().velocity;
    }

    public float getProjectileGravity(Entity entity) {
        GunData gunData = this.getGunData(this.getSeatIndex(entity));
        if (gunData == null) {
            return 0.0f;
        }
        return (float)gunData.compute().gravity;
    }

    public float getProjectileGravity(int seatIndex) {
        GunData gunData = this.getGunData(seatIndex);
        if (gunData == null) {
            return 0.0f;
        }
        return (float)gunData.compute().gravity;
    }

    public float getProjectileGravity(String weaponName) {
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return 0.0f;
        }
        return (float)gunData.compute().gravity;
    }

    public float getProjectileGravity(GunData gunData) {
        if (gunData == null) {
            return 0.0f;
        }
        return (float)gunData.compute().gravity;
    }

    public float getProjectileSpread(Entity entity) {
        GunData gunData = this.getGunData(this.getSeatIndex(entity));
        if (gunData == null) {
            return 0.5f;
        }
        return (float)gunData.compute().spread;
    }

    public float getProjectileSpread(int seatIndex) {
        GunData gunData = this.getGunData(seatIndex);
        if (gunData == null) {
            return 0.5f;
        }
        return (float)gunData.compute().spread;
    }

    public float getProjectileSpread(String weaponName) {
        GunData gunData = this.getGunData(weaponName);
        if (gunData == null) {
            return 0.5f;
        }
        return (float)gunData.compute().spread;
    }

    public float getProjectileSpread(GunData gunData) {
        if (gunData == null) {
            return 0.5f;
        }
        return (float)gunData.compute().spread;
    }

    public void passengerWeaponAutoAimFormUuid(String uuid, LivingEntity pLiving) {
        Entity target = EntityFindUtil.findEntity(this.m_9236_(), uuid);
        if (target != null) {
            if (target.m_20202_() != null) {
                target = target.m_20202_();
            }
            Vec3 targetPos = target.m_20191_().m_82399_();
            Vec3 targetVel = target.m_20184_();
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                double gravity = living.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                targetVel = targetVel.m_82520_(0.0, gravity, 0.0);
            }
            if (target instanceof Player) {
                targetVel = targetVel.m_82542_(2.0, 1.0, 2.0);
            }
            Vec3 targetVec = RangeTool.calculateFiringSolution(this.getShootPos((Entity)pLiving, 1.0f).m_82546_(this.getShootVec((Entity)pLiving, 1.0f).m_82490_(this.getShootPos((Entity)pLiving, 1.0f).m_82554_(pLiving.m_20182_()))), targetPos, targetVel, this.getProjectileVelocity((Entity)pLiving), this.getProjectileGravity((Entity)pLiving));
            this.passengerWeaponAutoAimFormVector(targetVec);
        }
    }

    public void passengerWeaponAutoAimFormVector(Vec3 shootVec) {
        float ySpeed = this.getPassengerWeaponYSpeed();
        float xSpeed = this.getPassengerWeaponXSpeed();
        float diffY = (float)Mth.m_14175_((double)(-VehicleVecUtils.getYRotFromVector(shootVec) + VehicleVecUtils.getYRotFromVector(this.getPassengerWeaponStationVector(1.0f))));
        float diffX = (float)Mth.m_14175_((double)(-VehicleVecUtils.getXRotFromVector(shootVec) + VehicleVecUtils.getXRotFromVector(this.getPassengerWeaponStationVector(1.0f))));
        this.turretTurnSound(diffX, diffY, 0.95f);
        this.setGunXRot(Mth.m_14036_((float)(this.getGunXRot() + Mth.m_14036_((float)(0.5f * diffX), (float)(-xSpeed), (float)xSpeed)), (float)(-this.getPassengerWeaponMaxPitch()), (float)(-this.getPassengerWeaponMinPitch())));
        this.setGunYRot(Mth.m_14036_((float)(this.getGunYRot() - Mth.m_14036_((float)(0.5f * diffY), (float)(-ySpeed), (float)ySpeed)), (float)(-this.getPassengerWeaponMaxYaw()), (float)(-this.getPassengerWeaponMinYaw())));
    }

    public void adjustWeaponControllerAngle() {
        float ySpeed = this.getPassengerWeaponYSpeed();
        float xSpeed = this.getPassengerWeaponXSpeed();
        Entity entity = this.getNthEntity(this.getPassengerWeaponStationControllerIndex());
        float diffY = 0.0f;
        float diffX = 0.0f;
        float speed = 1.0f;
        if (entity instanceof Player) {
            float gunAngle = -Mth.m_14177_((float)(entity.m_6080_() - this.m_146908_()));
            diffY = Mth.m_14177_((float)(gunAngle - this.getGunYRot()));
            diffX = Mth.m_14177_((float)(entity.m_146909_() - this.getGunXRot()));
            this.turretTurnSound(diffX, diffY, 0.95f);
            speed = 0.0f;
        }
        this.setGunXRot(this.getGunXRot() + Mth.m_14036_((float)(0.95f * diffX), (float)(-xSpeed), (float)xSpeed));
        this.setGunYRot(this.getGunYRot() + Mth.m_14036_((float)(0.9f * diffY), (float)(-ySpeed), (float)ySpeed) + speed * this.turretYRotLock);
    }

    public void destroy() {
        float radius;
        DestroyInfo destroyInfo = this.computed().destroyInfo;
        if (destroyInfo.explodePassengers) {
            if (this.crash && destroyInfo.crashPassengers) {
                this.crashPassengers();
            } else {
                this.explodePassengers();
            }
        }
        if ((radius = destroyInfo.explosionRadius) > 0.0f) {
            float damage = destroyInfo.explosionDamage;
            ParticleTool.ParticleType particleType = destroyInfo.particleType;
            CustomExplosion.Builder explosion = this.createCustomExplosion().radius(radius).damage(damage).withParticleType(particleType);
            if (!destroyInfo.explodeBlocks) {
                explosion.keepBlock();
            }
            explosion.explode();
        }
        this.m_146870_();
    }

    public CustomExplosion.Builder createCustomExplosion() {
        return new CustomExplosion.Builder(this).attacker(this.getLastAttacker());
    }

    protected void crashPassengers() {
        for (Entity entity : this.m_20197_()) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            for (int i = 0; i < (Integer)VehicleConfig.AIR_CRASH_EXPLOSION_COUNT.get(); ++i) {
                Entity tempAttacker = living == this.getLastAttacker() ? null : this.getLastAttacker();
                living.f_19802_ = 0;
                living.m_6469_(ModDamageTypes.causeAirCrashDamage(this.m_9236_().m_9598_(), null, tempAttacker), (float)((Integer)VehicleConfig.AIR_CRASH_EXPLOSION_DAMAGE.get()).intValue());
            }
        }
    }

    protected void explodePassengers() {
        for (Entity entity : this.m_20197_()) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            for (int i = 0; i < (Integer)VehicleConfig.SELF_EXPLOSION_COUNT.get(); ++i) {
                Entity tempAttacker = living == this.getLastAttacker() ? null : this.getLastAttacker();
                living.f_19802_ = 0;
                living.m_6469_(ModDamageTypes.causeVehicleExplosionDamage(this.m_9236_().m_9598_(), null, tempAttacker), (float)((Integer)VehicleConfig.SELF_EXPLOSION_DAMAGE.get()).intValue());
            }
        }
    }

    public void travel() {
        DefaultVehicleData computed = this.computed();
        EngineType engineType = computed.engineType;
        if (engineType == EngineType.EMPTY) {
            return;
        }
        if (engineType == EngineType.FIXED) {
            this.fixedEngine();
            return;
        }
        if (this.engineCache == null) {
            JsonObject engineInfo = computed.engineInfo;
            try {
                this.engineCache = switch (engineType) {
                    case EngineType.WHEEL -> (EngineInfo.Wheel)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.Wheel.class);
                    case EngineType.TRACK -> (EngineInfo.Track)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.Track.class);
                    case EngineType.HELICOPTER -> (EngineInfo.Helicopter)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.Helicopter.class);
                    case EngineType.SHIP -> (EngineInfo.Ship)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.Ship.class);
                    case EngineType.AIRCRAFT -> (EngineInfo.Aircraft)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.Aircraft.class);
                    case EngineType.WHEELCHAIR -> (EngineInfo.WheelChair)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.WheelChair.class);
                    case EngineType.TOM6 -> (EngineInfo.Tom6)DataLoader.GSON.fromJson((JsonElement)engineInfo, EngineInfo.Tom6.class);
                    default -> null;
                };
            }
            catch (Exception e) {
                Mod.LOGGER.error("Failed to parse engine info for vehicle {}, {}", (Object)this, (Object)e);
            }
        } else {
            this.engineCache.work(this);
        }
    }

    @Nullable
    public EngineInfo getEngineInfo() {
        return this.engineCache;
    }

    public float getEngineSoundVolume() {
        DefaultVehicleData computed = this.computed();
        EngineType engineType = computed.engineType;
        if (engineType == EngineType.EMPTY || engineType == EngineType.FIXED) {
            return 0.0f;
        }
        EngineInfo engineInfo = this.getEngineInfo();
        if (engineInfo == null) {
            return 0.0f;
        }
        return switch (engineType) {
            case EngineType.TRACK -> org.joml.Math.max((float)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()), (float)Mth.m_14154_((float)(1.4f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()))) * engineInfo.engineSoundVolume;
            case EngineType.HELICOPTER -> ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue() * engineInfo.engineSoundVolume;
            default -> Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) * engineInfo.engineSoundVolume;
        };
    }

    public Matrix4d getVehicleTransform(float ticks) {
        Matrix4d transformV = this.getVehicleYOffsetTransform(ticks);
        Matrix4d transform = new Matrix4d();
        Vector4d worldPosition = this.transformPosition(transform, 0.0, -this.getRotateOffsetHeight(), 0.0);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        return transformV;
    }

    public Matrix4d getVehicleYOffsetTransform(float partialTicks) {
        return VehicleVecUtils.getVehicleYOffsetTransform(this, partialTicks);
    }

    public double getRotateOffsetHeight() {
        return this.computed().rotateOffsetHeight;
    }

    public Matrix4d getVehicleFlatTransform(float partialTicks) {
        return VehicleVecUtils.getVehicleFlatTransform(this, partialTicks);
    }

    public Matrix4d getClientVehicleTransform(float partialTicks) {
        return VehicleVecUtils.getClientVehicleTransform(this, partialTicks);
    }

    public boolean hasTurret() {
        return this.getTurretPos() != null;
    }

    public Vec3 getTurretPos() {
        return this.computed().turretPos;
    }

    public int getTurretControllerIndex() {
        return this.computed().turretControllerIndex;
    }

    public float getTurretTurnXSpeed() {
        return this.computed().turretTurnSpeed.f_82470_;
    }

    public float getTurretTurnYSpeed() {
        return this.computed().turretTurnSpeed.f_82471_;
    }

    public float getTurretMinYaw() {
        return this.computed().turretYawRange.f_82470_;
    }

    public float getTurretMaxYaw() {
        return this.computed().turretYawRange.f_82471_;
    }

    public float getTurretMinPitch() {
        return this.computed().turretPitchRange.f_82470_;
    }

    public float getTurretMaxPitch() {
        return this.computed().turretPitchRange.f_82471_;
    }

    public Vec3 getBarrelPosition() {
        return this.computed().barrelPos;
    }

    public boolean hasPassengerWeaponStation() {
        return this.getPassengerWeaponStationPosition() != null;
    }

    public Vec3 getPassengerWeaponStationPosition() {
        return this.computed().passengerWeaponStationPos;
    }

    public Vec3 getPassengerWeaponStationBarrelPosition() {
        return this.computed().passengerWeaponStationBarrelPos;
    }

    public int getPassengerWeaponStationControllerIndex() {
        return this.computed().passengerWeaponStationControllerIndex;
    }

    public float getPassengerWeaponYSpeed() {
        return this.computed().passengerWeaponStationTurnSpeed.f_82471_;
    }

    public float getPassengerWeaponXSpeed() {
        return this.computed().passengerWeaponStationTurnSpeed.f_82470_;
    }

    public float getPassengerWeaponMinPitch() {
        return this.computed().passengerWeaponStationPitchRange.f_82470_;
    }

    public float getPassengerWeaponMaxPitch() {
        return this.computed().passengerWeaponStationPitchRange.f_82471_;
    }

    public float getPassengerWeaponMinYaw() {
        return this.computed().passengerWeaponStationYawRange.f_82470_;
    }

    public float getPassengerWeaponMaxYaw() {
        return this.computed().passengerWeaponStationYawRange.f_82471_;
    }

    public Matrix4d getTurretTransform(float partialTicks) {
        return VehicleVecUtils.getTurretTransform(this, partialTicks);
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        return VehicleVecUtils.getTurretVector(this, pPartialTicks);
    }

    public Matrix4d getBarrelTransform(float partialTicks) {
        return VehicleVecUtils.getBarrelTransform(this, partialTicks);
    }

    public Matrix4d getGunTransform(float partialTicks) {
        return VehicleVecUtils.getGunTransform(this, partialTicks);
    }

    public Matrix4d getPassengerWeaponStationBarrelTransform(float partialTicks) {
        return VehicleVecUtils.getPassengerWeaponStationBarrelTransform(this, partialTicks);
    }

    public Vec3 getPassengerWeaponStationVector(float partialTicks) {
        return VehicleVecUtils.getPassengerWeaponStationVector(this, partialTicks);
    }

    public Vector4d transformPosition(Matrix4d transform, double x, double y, double z) {
        return transform.transform(new Vector4d(x, y, z, 1.0));
    }

    public void handleClientSync() {
        if (this.m_9236_() instanceof ServerLevel && this.f_19797_ % 2 == 0) {
            this.f_19804_.m_135381_(SERVER_YAW, (Object)Float.valueOf(this.m_146908_()));
            this.f_19804_.m_135381_(SERVER_PITCH, (Object)Float.valueOf(this.m_146909_()));
        }
        if (this.m_6109_()) {
            this.interpolationSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedX = this.m_20185_() + (this.xO - this.m_20185_()) / (double)this.interpolationSteps;
        double interpolatedY = this.m_20186_() + (this.yO - this.m_20186_()) / (double)this.interpolationSteps;
        double interpolatedZ = this.m_20189_() + (this.zO - this.m_20189_()) / (double)this.interpolationSteps;
        float diffY = Mth.m_14177_((float)(((Float)this.f_19804_.m_135370_(SERVER_YAW)).floatValue() - this.m_146908_()));
        float diffX = Mth.m_14177_((float)(((Float)this.f_19804_.m_135370_(SERVER_PITCH)).floatValue() - this.m_146909_()));
        this.m_146922_(this.m_146908_() + 0.1f * diffY);
        this.m_146926_(this.m_146909_() + 0.1f * diffX);
        this.m_6034_(interpolatedX, interpolatedY, interpolatedZ);
        --this.interpolationSteps;
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.xO = x;
        this.yO = y;
        this.zO = z;
        this.interpolationSteps = 10;
    }

    @Deprecated(forRemoval=true, since="0.8.9")
    protected Vec3 getDismountOffset(double vehicleWidth, double passengerWidth) {
        return VehicleMiscUtils.getDismountOffset(this, vehicleWidth, passengerWidth);
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity passenger) {
        int index = this.getTagSeatIndex((Entity)passenger);
        if (index < 0) {
            return super.m_7688_(passenger);
        }
        return this.getDismountLocationForIndex(passenger, index);
    }

    @NotNull
    public Vec3 getDismountLocationForIndex(LivingEntity passenger, int index) {
        DismountInfo dismountInfo = this.computed().seats().get((int)index).dismountInfo;
        if (dismountInfo != null) {
            Vec3 vec3 = dismountInfo.position;
            if (vec3 != null) {
                Vector4d worldPosition = this.transformPosition(this.getTransformFromString(dismountInfo.transform), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
            }
            return this.dismount(passenger);
        }
        return this.dismount(passenger);
    }

    @NotNull
    public Vec3 dismount(LivingEntity passenger) {
        Vec3 vec3d = VehicleMiscUtils.getDismountOffset(this, this.m_20205_() * Mth.f_13994_, passenger.m_20205_() * Mth.f_13994_);
        double ox = this.m_20185_() - vec3d.f_82479_;
        double oz = this.m_20189_() + vec3d.f_82481_;
        BlockPos exitPos = new BlockPos((int)ox, (int)this.m_20186_(), (int)oz);
        BlockPos floorPos = exitPos.m_7495_();
        if (!this.m_9236_().m_46801_(floorPos)) {
            double floorHeight;
            ArrayList list = Lists.newArrayList();
            double exitHeight = this.m_9236_().m_45573_(exitPos);
            if (DismountHelper.m_38439_((double)exitHeight)) {
                list.add(new Vec3(ox, (double)exitPos.m_123342_() + exitHeight, oz));
            }
            if (DismountHelper.m_38439_((double)(floorHeight = this.m_9236_().m_45573_(floorPos)))) {
                list.add(new Vec3(ox, (double)floorPos.m_123342_() + floorHeight, oz));
            }
            for (Pose entityPose : passenger.m_7431_()) {
                for (Vec3 vec3d2 : list) {
                    if (!DismountHelper.m_150279_((CollisionGetter)this.m_9236_(), (Vec3)vec3d2, (LivingEntity)passenger, (Pose)entityPose)) continue;
                    passenger.m_20124_(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.m_7688_(passenger);
    }

    @NotNull
    public Vec3 getEjectionPosition(LivingEntity passenger, int index) {
        DismountInfo dismountInfo = this.computed().seats().get((int)index).dismountInfo;
        if (dismountInfo != null) {
            Vec3 vec3 = dismountInfo.ejectPosition;
            if (vec3 == null) {
                return passenger.m_20182_();
            }
            Vector4d worldPosition = this.transformPosition(this.getTransformFromString(dismountInfo.transform), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            return new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        }
        return passenger.m_20182_();
    }

    public boolean allowEjection(int seatIndex) {
        DismountInfo dismountInfo = this.computed().seats().get((int)seatIndex).dismountInfo;
        if (dismountInfo != null) {
            return this.computed().seats().get((int)seatIndex).dismountInfo.canEject;
        }
        return false;
    }

    public void removeSeatIndexTag(Entity entity) {
        entity.getPersistentData().m_128473_(TAG_SEAT_INDEX);
    }

    @NotNull
    public Vec3 getEjectionMovement(LivingEntity entity, int index) {
        DismountInfo dismountInfo = this.computed().seats().get((int)index).dismountInfo;
        if (dismountInfo == null) {
            return this.m_20184_();
        }
        double force = dismountInfo.ejectForce;
        StringOrVec3 stringOrVec3 = dismountInfo.ejectDirection;
        if (stringOrVec3 == null) {
            return this.m_20184_().m_82549_(this.getUpVec(1.0f).m_82490_(force));
        }
        if (stringOrVec3.isString()) {
            return this.m_20184_().m_82549_(this.getVectorFromString(stringOrVec3.string, 1.0f, this.getSeatIndex((Entity)entity)).m_82490_(force));
        }
        Vec3 vec3 = stringOrVec3.vec3;
        Vector4d worldPosition = this.transformPosition(this.getTransformFromString(dismountInfo.transform), vec3.f_82479_ + stringOrVec3.vec3.f_82479_, vec3.f_82480_ + stringOrVec3.vec3.f_82480_, vec3.f_82481_ + stringOrVec3.vec3.f_82481_);
        Vector4d worldPositionO = this.transformPosition(this.getTransformFromString(dismountInfo.transform), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        Vec3 startPos = new Vec3(worldPositionO.x, worldPositionO.y, worldPositionO.z);
        Vec3 endPos = new Vec3(worldPosition.x, worldPosition.y, worldPosition.z);
        return this.m_20184_().m_82549_(startPos.m_82505_(endPos).m_82541_().m_82490_(force));
    }

    public ResourceLocation getVehicleIcon() {
        return this.computed().vehicleIcon;
    }

    public boolean allowFreeCam() {
        return this.computed().allowFreeCam;
    }

    public Vec3 getUpVec(float ticks) {
        Matrix4d transform = this.getVehicleTransform(ticks);
        Vector4d force0 = this.transformPosition(transform, 0.0, 0.0, 0.0);
        Vector4d force1 = this.transformPosition(transform, 0.0, 1.0, 0.0);
        return new Vec3(force0.x, force0.y, force0.z).m_82505_(new Vec3(force1.x, force1.y, force1.z));
    }

    public void m_5997_(double pX, double pY, double pZ) {
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4d transform = this.getBarrelTransform(pPartialTicks);
        Vector4d rootPosition = this.transformPosition(transform, 0.0, 0.0, 0.0);
        Vector4d targetPosition = this.transformPosition(transform, 0.0, 0.0, 1.0);
        return new Vec3(rootPosition.x, rootPosition.y, rootPosition.z).m_82505_(new Vec3(targetPosition.x, targetPosition.y, targetPosition.z));
    }

    public float getBarrelXRot(float pPartialTicks) {
        return Mth.m_14179_((float)pPartialTicks, (float)(this.turretXRotO - this.f_19860_), (float)(this.getTurretXRot() - this.m_146909_()));
    }

    public float getBarrelYRot(float pPartialTick) {
        return -Mth.m_14179_((float)pPartialTick, (float)(this.turretYRotO - this.f_19859_), (float)(this.getTurretYRot() - this.m_146908_()));
    }

    public float getGunXRot(float pPartialTicks) {
        return Mth.m_14179_((float)pPartialTicks, (float)(this.gunXRotO - this.f_19860_), (float)(this.getGunXRot() - this.m_146909_()));
    }

    public float getGunYRot(float pPartialTick) {
        return -Mth.m_14179_((float)pPartialTick, (float)(this.gunYRotO - this.f_19859_), (float)(this.getGunYRot() - this.m_146908_()));
    }

    public float getTurretYRot() {
        return this.turretYRot;
    }

    public float getTurretYaw(float pPartialTick) {
        return Mth.m_14179_((float)pPartialTick, (float)this.turretYRotO, (float)this.getTurretYRot());
    }

    public void setTurretYRot(float pTurretYRot) {
        this.turretYRot = pTurretYRot;
    }

    public float getTurretXRot() {
        return this.turretXRot;
    }

    public void setTurretXRot(float pTurretXRot) {
        this.turretXRot = pTurretXRot;
    }

    public float getTurretPitch(float pPartialTick) {
        return Mth.m_14179_((float)pPartialTick, (float)this.turretXRotO, (float)this.getTurretXRot());
    }

    public float getGunYRot() {
        return this.gunYRot;
    }

    public void setGunYRot(float pGunYRot) {
        this.gunYRot = pGunYRot;
    }

    public float getGunXRot() {
        return this.gunXRot;
    }

    public void setGunXRot(float pGunXRot) {
        this.gunXRot = pGunXRot;
    }

    public Vec3 getCameraPos(Entity entity, float partialTicks) {
        return VehicleVecUtils.getCameraPos(this, entity, partialTicks);
    }

    public Vec3 cameraDirection(Entity entity, float partialTicks) {
        return VehicleVecUtils.getCameraDirection(this, entity, partialTicks);
    }

    public Vec3 getZoomPos(Entity entity, float partialTicks) {
        return VehicleVecUtils.getZoomPos(this, entity, partialTicks);
    }

    public Vec3 getZoomDirection(Entity entity, float partialTicks) {
        return VehicleVecUtils.getZoomDirection(this, entity, partialTicks);
    }

    public double getMouseSensitivity() {
        return 0.1;
    }

    public Vec2 getMouseSpeed() {
        return VehicleResource.compute((VehicleEntity)this).mouseSpeed;
    }

    public float gearRot(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.gearRotO, (float)this.getGearRot());
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getMass() {
        return this.computed().mass;
    }

    public void m_20256_(Vec3 pDeltaMovement) {
        Vec3 acceleration;
        Vec3 currentMomentum = this.m_20184_();
        double currentSpeedSq = currentMomentum.m_82556_();
        double newSpeedSq = pDeltaMovement.m_82556_();
        if (newSpeedSq > currentSpeedSq && (acceleration = pDeltaMovement.m_82546_(currentMomentum)).m_82556_() > 8.0) {
            Vec3 limitedAcceleration = acceleration.m_82541_().m_82490_(0.125);
            Vec3 finalMomentum = currentMomentum.m_82549_(limitedAcceleration);
            super.m_20256_(finalMomentum);
            return;
        }
        super.m_20256_(pDeltaMovement);
    }

    public void m_246865_(Vec3 pAddend) {
        double length = pAddend.m_82553_();
        if (length > 0.1) {
            pAddend = pAddend.m_82490_(0.1 / length);
        }
        super.m_246865_(pAddend);
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        SeatInfo seat = this.computed().seats().get(seatIndex);
        Vec3 sensitivity = seat.sensitivity;
        return zoom ? sensitivity.f_82479_ * original : (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? sensitivity.f_82480_ * original : sensitivity.f_82481_ * original);
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return this.computed().containerIcon;
    }

    public boolean isEnclosed(int index) {
        List<SeatInfo> seats = this.computed().seats();
        if (index < 0 || index >= seats.size()) {
            return false;
        }
        SeatInfo seat = seats.get(index);
        if (seat.isEnclosed == null) {
            return seat.hidePassenger;
        }
        return seat.isEnclosed;
    }

    public boolean isEnclosed(Entity passenger) {
        return this.isEnclosed(this.getSeatIndex(passenger));
    }

    public boolean banHand(LivingEntity entity) {
        int index = this.getSeatIndex((Entity)entity);
        if (index == -1) {
            return false;
        }
        GunData gunData = this.getGunData(index);
        List<SeatInfo> seats = this.computed().seats();
        if (index >= seats.size()) {
            return false;
        }
        SeatInfo seat = seats.get(index);
        return gunData != null || seat.banHand != false;
    }

    public boolean hidePassenger(int index) {
        List<SeatInfo> seats = this.computed().seats();
        if (index < 0 || index >= seats.size()) {
            return false;
        }
        SeatInfo seat = seats.get(index);
        return seat.hidePassenger;
    }

    public boolean hidePassenger(Entity passenger) {
        return this.hidePassenger(this.getSeatIndex(passenger));
    }

    public int getAmmoCount(LivingEntity living) {
        GunData data = this.getGunData(this.getSeatIndex((Entity)living));
        if (data == null) {
            return 0;
        }
        return this.getAmmo(data);
    }

    public int getAmmoCount(int seatIndex) {
        GunData data = this.getGunData(seatIndex);
        if (data == null) {
            return 0;
        }
        return this.getAmmo(data);
    }

    public int getAmmoCount(String weaponName) {
        GunData data = this.getGunData(weaponName);
        if (data == null) {
            return 0;
        }
        return this.getAmmo(data);
    }

    public int getAmmo(GunData data) {
        return data.useBackpackAmmo() ? data.backupAmmoCount.get() : data.ammo.get();
    }

    @Nullable
    public ItemStack m_142340_() {
        if (!this.getRetrieveItems().isEmpty()) {
            return this.getRetrieveItems().get(0);
        }
        return ContainerBlockItem.createInstance(this.m_6095_());
    }

    public boolean useAircraftCamera(int seatIndex) {
        SeatInfo seat = this.computed().seats().get(seatIndex);
        if (seat != null) {
            CameraPos data = seat.cameraPos;
            return data.useAircraftCamera;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        int index = this.getSeatIndex((Entity)player);
        SeatInfo seat = this.computed().seats().get(index);
        GunData gunData = this.getGunData((Entity)player);
        if (seat != null) {
            CameraPos data = seat.cameraPos;
            if (data != null) {
                if (zoom && gunData != null && gunData.compute().shootPos.viewDirection != null) {
                    return new Vec2((float)(-VehicleVecUtils.getYRotFromVector(this.getViewVec((Entity)player, partialTicks))), (float)(-VehicleVecUtils.getXRotFromVector(this.getViewVec((Entity)player, partialTicks))));
                }
                if (this.useAircraftCamera(index)) {
                    return new Vec2((float)((double)this.getYaw(partialTicks) - ClientMouseHandler.freeCameraYaw), (float)((double)this.getPitch(partialTicks) + ClientMouseHandler.freeCameraPitch));
                }
                if (zoom || isFirstPerson) {
                    return new Vec2((float)(-VehicleVecUtils.getYRotFromVector(this.cameraDirection((Entity)player, partialTicks))), (float)(-VehicleVecUtils.getXRotFromVector(this.cameraDirection((Entity)player, partialTicks))));
                }
            } else {
                return null;
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        int index = this.getSeatIndex((Entity)player);
        SeatInfo seat = this.computed().seats().get(index);
        if (seat != null) {
            CameraPos data = seat.cameraPos;
            GunData gunData = this.getGunData((Entity)player);
            if (data != null) {
                if (zoom || isFirstPerson) {
                    if (zoom) {
                        if (gunData != null && gunData.compute().shootPos.viewPosition != null) {
                            return this.getViewPos((Entity)player, partialTicks);
                        }
                        return this.getZoomPos((Entity)player, partialTicks);
                    }
                    return this.getCameraPos((Entity)player, partialTicks);
                }
                if (this.useAircraftCamera(index)) {
                    Matrix4d transform = this.getClientVehicleTransform(partialTicks);
                    Vector4d maxCameraPosition = this.transformPosition(transform, data.aircraftCameraPos.f_82479_, data.aircraftCameraPos.f_82480_ + 0.1 * ClientMouseHandler.custom3pDistanceLerp, data.aircraftCameraPos.f_82481_ - ClientMouseHandler.custom3pDistanceLerp);
                    return CameraTool.getMaxZoom(transform, maxCameraPosition);
                }
            }
            return null;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        CameraPos data;
        int index = this.getSeatIndex(entity);
        SeatInfo seat = this.computed().seats().get(index);
        if (seat != null && (data = seat.cameraPos) != null) {
            return data.useFixedCameraPos;
        }
        return false;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && this.hasEnergyStorage()) {
            return this.energy.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER && this.hasContainer()) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return this.getCapability(cap, null);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.hasContainer()) {
            this.itemHandler.invalidate();
        }
        if (this.hasEnergyStorage()) {
            this.energy.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        if (this.hasContainer()) {
            this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this));
        }
        if (this.hasEnergyStorage()) {
            this.energy = LazyOptional.of(() -> new VehicleEnergyStorage(this));
        }
    }

    public double getDefaultZoom(Entity entity) {
        GunData gunData = this.getGunData(this.getSeatIndex(entity));
        if (gunData != null) {
            return gunData.compute().defaultZoom;
        }
        return 1.0;
    }

    public boolean canCrushEntities() {
        return true;
    }

    public void fixedEngine() {
        this.m_6478_(MoverType.SELF, new Vec3(0.0, this.m_20184_().f_82480_, 0.0));
        if (this.m_20096_()) {
            this.m_20256_(Vec3.f_82478_);
        } else {
            this.m_20256_(new Vec3(0.0, this.m_20184_().f_82480_, 0.0));
        }
    }

    public void releaseSmokeDecoy(Vec3 vec3) {
        VehicleWeaponUtils.releaseSmokeDecoy(this, vec3);
    }

    public void releaseDecoy() {
        VehicleWeaponUtils.releaseDecoy(this);
    }

    public void inertiaRotate(float multiplier) {
        this.m_146926_(this.m_146909_() - 0.5f * (float)(this.getAcceleration() * (double)multiplier));
    }

    public void terrainCompact(List<Vec3> positions) {
        VehicleMotionUtils.terrainCompact(this, positions);
    }

    public Matrix4d getWheelsTransform(float partialTicks) {
        return VehicleMotionUtils.getWheelsTransform(this, partialTicks);
    }

    public void moveOnDragonTeeth() {
        VehicleMotionUtils.handleVehicleMoveOnDragonTeeth(this);
    }

    public void collideBlocks() {
        VehicleMotionUtils.collideBlocks(this);
    }

    public Entity getLastAttacker() {
        return EntityFindUtil.findEntity(this.m_9236_(), (String)this.f_19804_.m_135370_(LAST_ATTACKER_UUID));
    }

    public void m_6478_(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        if (!this.m_9236_().m_5776_()) {
            ignoreEntityGroundCheckStepping = true;
        }
        super.m_6478_(movementType, movement);
        if (this.lastTickSpeed < 0.3 || this.collisionCoolDown > 0 || this instanceof DroneEntity) {
            return;
        }
        Entity driver = this.getLastDriver();
        if (this.f_19863_) {
            if (this.getVehicleType() == VehicleType.AIRPLANE && ((double)((Float)this.f_19804_.m_135370_(GEAR_ROT)).floatValue() > 0.15 && !(this instanceof Tom6Entity) || Mth.m_14154_((float)this.getRoll()) > 20.0f || Mth.m_14154_((float)this.m_146909_()) > 30.0f)) {
                this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), this, driver == null ? this : driver), (float)((double)(8.0f + Mth.m_14154_((float)(this.getRoll() * 0.2f))) * (this.lastTickSpeed - 0.3) * (this.lastTickSpeed - 0.3)));
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.m_5720_(), 1.0f, 1.0f);
                }
                this.bounceVertical(Direction.m_122366_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7098_(), (double)this.m_20184_().m_7094_()).m_122424_());
            } else if (this.getVehicleType() == VehicleType.HELICOPTER) {
                this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), this, driver == null ? this : driver), (float)(60.0 * ((this.lastTickSpeed - 0.5) * (this.lastTickSpeed - 0.5))));
                this.bounceVertical(Direction.m_122366_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7098_(), (double)this.m_20184_().m_7094_()).m_122424_());
            } else if ((double)Mth.m_14154_((float)((float)this.lastTickVerticalSpeed)) > 0.4) {
                this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), this, driver == null ? this : driver), (float)(96.0 * (((double)Mth.m_14154_((float)((float)this.lastTickVerticalSpeed)) - 0.4) * (this.lastTickSpeed - 0.3) * (this.lastTickSpeed - 0.3))));
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.m_5720_(), 1.0f, 1.0f);
                }
                this.bounceVertical(Direction.m_122366_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7098_(), (double)this.m_20184_().m_7094_()).m_122424_());
            }
        }
        if (this.f_19862_) {
            this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage(this.m_9236_().m_9598_(), this, driver == null ? this : driver), (float)(126.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
            this.bounceHorizontal(Direction.m_122366_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7098_(), (double)this.m_20184_().m_7094_()).m_122424_());
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.m_5720_(), 1.0f, 1.0f);
            }
            this.collisionCoolDown = 4;
            this.crash = true;
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(0.8f * ((Float)this.f_19804_.m_135370_(POWER)).floatValue()));
        }
    }

    public void bounceHorizontal(Direction direction) {
        VehicleMotionUtils.bounceHorizontal(this, direction);
    }

    public void bounceVertical(Direction direction) {
        VehicleMotionUtils.bounceVertical(this, direction);
    }

    public void preventStacking() {
        VehicleMotionUtils.preventStacking(this);
    }

    public void pushNew(double pX, double pY, double pZ) {
        this.m_20256_(this.m_20184_().m_82520_(pX, pY, pZ));
    }

    public void supportEntities() {
        VehicleMotionUtils.supportEntities(this);
    }

    @NotNull
    public RandomSource getRandom() {
        return this.f_19796_;
    }

    public void crushEntities() {
        VehicleMotionUtils.crushEntities(this);
    }

    public Vector3f getForwardDirection() {
        return new Vector3f(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))), 0.0f, Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))).normalize();
    }

    public Vector3f getRightDirection() {
        return new Vector3f(Mth.m_14089_((float)(-this.m_146908_() * ((float)Math.PI / 180))), 0.0f, Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)))).normalize();
    }

    public SoundEvent getEngineSound() {
        return this.computed().engineSound;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double pV) {
        this.velocity = pV;
    }

    public double getAcceleration() {
        return this.getVelocity() - this.velocityO;
    }

    public float getRudderRot() {
        return this.rudderRot;
    }

    public void setRudderRot(float pRudderRot) {
        this.rudderRot = pRudderRot;
    }

    public float getLeftWheelRot() {
        return this.leftWheelRot;
    }

    public void setLeftWheelRot(float pLeftWheelRot) {
        this.leftWheelRot = pLeftWheelRot;
    }

    public float getRightWheelRot() {
        return this.rightWheelRot;
    }

    public void setRightWheelRot(float pRightWheelRot) {
        this.rightWheelRot = pRightWheelRot;
    }

    public int getTrackAnimationLength() {
        return 100;
    }

    public float getLeftTrack() {
        return this.leftTrack;
    }

    public void setLeftTrack(float pLeftTrack) {
        this.leftTrack = pLeftTrack;
    }

    public float getRightTrack() {
        return this.rightTrack;
    }

    public void setRightTrack(float pRightTrack) {
        this.rightTrack = pRightTrack;
    }

    public float getPropellerRot() {
        return this.propellerRot;
    }

    public void setPropellerRot(float pPropellerRot) {
        this.propellerRot = pPropellerRot;
    }

    public double getRecoilShake() {
        return this.recoilShake;
    }

    public void setRecoilShake(double pRecoilShake) {
        this.recoilShake = pRecoilShake;
    }

    public float getFlap1LRot() {
        return this.flap1LRot;
    }

    public void setFlap1L2Rot(float pFlap1L2Rot) {
        this.flap1L2Rot = pFlap1L2Rot;
    }

    public float getFlap1R2Rot() {
        return this.flap1R2Rot;
    }

    public void setFlap1R2Rot(float pFlap1R2Rot) {
        this.flap1R2Rot = pFlap1R2Rot;
    }

    public float getFlap1L2Rot() {
        return this.flap1L2Rot;
    }

    public void setFlap1LRot(float pFlap1LRot) {
        this.flap1LRot = pFlap1LRot;
    }

    public float getFlap1RRot() {
        return this.flap1RRot;
    }

    public void setFlap1RRot(float pFlap1RRot) {
        this.flap1RRot = pFlap1RRot;
    }

    public float getFlap2LRot() {
        return this.flap2LRot;
    }

    public void setFlap2LRot(float pFlap2LRot) {
        this.flap2LRot = pFlap2LRot;
    }

    public float getFlap2RRot() {
        return this.flap2RRot;
    }

    public void setFlap2RRot(float pFlap2RRot) {
        this.flap2RRot = pFlap2RRot;
    }

    public float getFlap3Rot() {
        return this.flap3Rot;
    }

    public void setFlap3Rot(float pFlap3Rot) {
        this.flap3Rot = pFlap3Rot;
    }

    public float getGearRot() {
        return this.gearRot;
    }

    public void setGearRot(float pGearRot) {
        this.gearRot = pGearRot;
    }

    public boolean hasDecoy() {
        return this.computed().hasDecoy;
    }

    public boolean engineRunning() {
        return org.joml.Math.abs((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.0f;
    }

    @NotNull
    public List<ItemStack> getRetrieveItems() {
        return List.of(ContainerBlockItem.createInstance(this));
    }

    public int getHudColor() {
        return this.computed().hudColor.get();
    }

    public float getPower() {
        return ((Float)this.f_19804_.m_135370_(POWER)).floatValue();
    }

    public String getDecoyState() {
        return (Boolean)this.f_19804_.m_135370_(DECOY_READY) != false ? "READY" : "RELOADING";
    }

    @NotNull
    public SoundEvent getHornSound() {
        return this.computed().hornSound;
    }

    public void horn() {
        this.f_19804_.m_135381_(HORN_VOLUME, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(HORN_VOLUME)).floatValue() + 0.7f));
    }

    public boolean hornWorking() {
        return (double)org.joml.Math.abs((float)((Float)this.f_19804_.m_135370_(HORN_VOLUME)).floatValue()) > 0.05;
    }

    public VehicleType getVehicleType() {
        return this.computed().type;
    }

    public void support(Entity entity) {
        VehicleMotionUtils.support(this, entity);
    }

    public boolean isAmphibious() {
        return VehicleMiscUtils.isAmphibious(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component firstPersonAmmoComponent(GunData data, Player player) {
        String name = data.compute().name;
        if (name == null || name.isBlank()) {
            return Component.m_237119_();
        }
        int ammoCount = this.getAmmoCount((LivingEntity)player);
        return Component.m_237110_((String)name, (Object[])new Object[]{ammoCount == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(ammoCount)});
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component thirdPersonAmmoComponent(GunData data, Player player) {
        return this.firstPersonAmmoComponent(data, player);
    }

    @Override
    public List<OBB> getOBBs() {
        if (this.obbCache == null) {
            this.obbCache = this.getOBB().stream().filter(Objects::nonNull).map(OBBInfo::getOBB).toList();
        }
        return this.obbCache;
    }
}

