/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.client.particle.CustomSmokeOption;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class SmokeDecoyEntity
extends Entity {
    public int life = 400;
    public int igniteTime = 4;
    public boolean releaseSmoke = true;

    public SmokeDecoyEntity(EntityType<? extends SmokeDecoyEntity> type, Level level) {
        super(type, level);
    }

    public SmokeDecoyEntity(EntityType<? extends SmokeDecoyEntity> type, Level level, boolean release) {
        super(type, level);
        this.releaseSmoke = release;
    }

    public SmokeDecoyEntity(Level level) {
        super((EntityType)ModEntities.SMOKE_DECOY.get(), level);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_7378_(@NotNull CompoundTag compoundTag) {
        if (compoundTag.m_128441_("IgniteTime")) {
            this.igniteTime = compoundTag.m_128451_("IgniteTime");
        }
        if (compoundTag.m_128441_("Life")) {
            this.life = compoundTag.m_128451_("Life");
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128405_("IgniteTime", this.igniteTime);
        compoundTag.m_128405_("Life", this.life);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.f_19797_ == this.igniteTime) {
            if (this.releaseSmoke) {
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    ParticleTool.sendParticle(serverLevel, new CustomSmokeOption(1.0f, 1.0f, 1.0f), this.f_19854_, this.f_19855_, this.f_19856_, 50, 0.0, 0.0, 0.0, 0.07, true);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.f_123755_, this.f_19854_, this.f_19855_, this.f_19856_, 10, 1.0, 1.0, 1.0, 0.1, true);
                    ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), this.f_19854_, this.f_19855_, this.f_19856_, 30, 0.0, 0.0, 0.0, 0.2, true);
                }
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.SMOKE_FIRE.get(), this.m_5720_(), 2.0f, this.f_19796_.m_188501_() * 0.05f + 1.0f);
            }
            this.m_20256_(Vec3.f_82478_);
        }
        if (this.f_19797_ > this.life) {
            this.m_146870_();
        }
    }

    public void decoyShoot(Entity entity, Vec3 shootVec, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = shootVec.m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)pInaccuracy)).m_82490_((double)pVelocity);
        this.m_20256_(entity.m_20184_().m_82490_(0.75).m_82549_(vec3));
        double d0 = vec3.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }
}

