/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectile;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MelonBombEntity
extends DestroyableProjectile {
    public MelonBombEntity(EntityType<? extends MelonBombEntity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
        this.explosionRadius = 10.0f;
        this.explosionDamage = 500.0f;
    }

    public MelonBombEntity(LivingEntity entity, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.MELON_BOMB.get()), (Entity)entity, level);
        this.f_19811_ = true;
        this.explosionRadius = 10.0f;
        this.explosionDamage = 500.0f;
    }

    @NotNull
    protected Item m_7881_() {
        return Items.f_42028_;
    }

    @Override
    public void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (this.m_9236_() instanceof ServerLevel) {
            if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && ((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue()) {
                AABB aabb = new AABB(blockHitResult.m_82450_(), blockHitResult.m_82450_()).m_82400_(5.0);
                BlockPos.m_121921_((AABB)aabb).forEach(pos -> {
                    float hard = this.m_9236_().m_8055_(pos).m_60734_().m_155943_();
                    if (hard != -1.0f) {
                        Vec3 vec3 = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                        if (vec3.m_82554_(blockHitResult.m_82450_()) < 3.0) {
                            this.m_9236_().m_46961_(pos, true);
                        }
                    }
                });
            }
            ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.5f);
            this.m_146870_();
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 600 || ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() <= 0.0f) {
            this.m_146870_();
            if (!this.m_9236_().f_46443_) {
                ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.5f);
            }
        }
    }

    @Override
    public float getMaxHealth() {
        return 15.0f;
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.SHELL_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.7f;
    }
}

