/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.client.animation.AnimationTicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLaserEntity
extends Entity
implements TraceableEntity {
    public LivingEntity caster;
    public float yaw;
    public float pitch;
    public float preYaw;
    public float prePitch;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public double prevCollidePosX;
    public double prevCollidePosY;
    public double prevCollidePosZ;
    public Direction blockSide = null;
    public boolean on = true;
    public AnimationTicker ticker = new AnimationTicker(3);
    private static final EntityDataAccessor<Integer> DATA_CASTER_ID = SynchedEntityData.m_135353_(AbstractLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_YAW = SynchedEntityData.m_135353_(AbstractLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_PITCH = SynchedEntityData.m_135353_(AbstractLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_DURATION = SynchedEntityData.m_135353_(AbstractLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_COUNT_DOWN = SynchedEntityData.m_135353_(AbstractLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public AbstractLaserEntity(EntityType<?> type, Level level, int countDown) {
        super(type, level);
        this.setCountDown(countDown);
        this.f_19811_ = true;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevCollidePosX = this.collidePosX;
        this.prevCollidePosY = this.collidePosY;
        this.prevCollidePosZ = this.collidePosZ;
        this.preYaw = this.yaw;
        this.prePitch = this.pitch;
        this.yaw = this.getYaw();
        this.pitch = this.getPitch();
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.f_19797_ == 1 && this.m_9236_().f_46443_) {
            this.caster = (LivingEntity)this.m_9236_().m_6815_(this.getCasterId());
        }
        this.beamTick();
        if (!this.on && this.ticker.isStopped() || this.caster != null && !this.caster.m_6084_()) {
            this.m_146870_();
        }
        this.ticker.changeTimer(this.on && this.isAccumulating());
        if (this.f_19797_ - this.getCountDown() > this.getDuration()) {
            this.on = false;
        }
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
    }

    protected void beamTick() {
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.caster;
    }

    public void m_7334_(@NotNull Entity entityIn) {
    }

    @NotNull
    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_CASTER_ID, (Object)-1);
        this.f_19804_.m_135372_(DATA_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_DURATION, (Object)0);
        this.f_19804_.m_135372_(DATA_COUNT_DOWN, (Object)0);
    }

    public void setCasterId(int id) {
        this.f_19804_.m_135381_(DATA_CASTER_ID, (Object)id);
    }

    public int getCasterId() {
        return (Integer)this.f_19804_.m_135370_(DATA_CASTER_ID);
    }

    public boolean isAccumulating() {
        return this.f_19797_ > this.getCountDown();
    }

    public float getYaw() {
        return ((Float)this.m_20088_().m_135370_(DATA_YAW)).floatValue();
    }

    public void setYaw(float rotAngle) {
        this.m_20088_().m_135381_(DATA_YAW, (Object)Float.valueOf(rotAngle));
    }

    public float getPitch() {
        return ((Float)this.m_20088_().m_135370_(DATA_PITCH)).floatValue();
    }

    public void setPitch(float rotAngle) {
        this.m_20088_().m_135381_(DATA_PITCH, (Object)Float.valueOf(rotAngle));
    }

    public int getDuration() {
        return (Integer)this.m_20088_().m_135370_(DATA_DURATION);
    }

    public void setDuration(int duration) {
        this.m_20088_().m_135381_(DATA_DURATION, (Object)duration);
    }

    public int getCountDown() {
        return (Integer)this.m_20088_().m_135370_(DATA_COUNT_DOWN);
    }

    public void setCountDown(int countDown) {
        this.m_20088_().m_135381_(DATA_COUNT_DOWN, (Object)countDown);
    }

    protected void calculateEndPos(double radius) {
        if (this.m_9236_().m_5776_()) {
            this.endPosX = this.m_20185_() + radius * Math.cos(this.yaw) * Math.cos(this.pitch);
            this.endPosZ = this.m_20189_() + radius * Math.sin(this.yaw) * Math.cos(this.pitch);
            this.endPosY = this.m_20186_() + radius * Math.sin(this.pitch);
        } else {
            this.endPosX = this.m_20185_() + radius * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosZ = this.m_20189_() + radius * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosY = this.m_20186_() + radius * Math.sin(this.getPitch());
        }
    }

    public CustomHitResult raytraceEntities(Level world, Vec3 from, Vec3 to) {
        CustomHitResult result = new CustomHitResult();
        result.setBlockHit((HitResult)world.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (result.getBlockHit() != null) {
            Vec3 hitVec = result.getBlockHit().m_82450_();
            this.collidePosX = hitVec.f_82479_;
            this.collidePosY = hitVec.f_82480_;
            this.collidePosZ = hitVec.f_82481_;
            this.blockSide = result.getBlockHit().m_82434_();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.m_45976_(LivingEntity.class, new AABB(Math.min(this.m_20185_(), this.collidePosX), Math.min(this.m_20186_(), this.collidePosY), Math.min(this.m_20189_(), this.collidePosZ), Math.max(this.m_20185_(), this.collidePosX), Math.max(this.m_20186_(), this.collidePosY), Math.max(this.m_20189_(), this.collidePosZ)).m_82377_(1.0, 1.0, 1.0));
        for (LivingEntity entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.m_6143_() + this.getBaseScale();
            AABB aabb = entity.m_20191_().m_82377_((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.m_82371_(from, to);
            if (aabb.m_82390_(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6051_() {
        return false;
    }

    protected void onHit(HitResult hitResult) {
        HitResult.Type hitresult$type = hitResult.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)hitResult);
            this.m_9236_().m_214171_(GameEvent.f_157777_, hitResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)hitResult;
            this.onHitBlock(blockhitresult);
            BlockPos blockpos = blockhitresult.m_82425_();
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockpos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockpos)));
        }
    }

    protected void onHitEntity(EntityHitResult result) {
    }

    protected void onHitBlock(BlockHitResult result) {
    }

    protected float getBaseScale() {
        return 0.5f;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static class CustomHitResult {
        private BlockHitResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        public List<LivingEntity> getEntities() {
            return this.entities;
        }

        public void setBlockHit(HitResult rayTraceResult) {
            if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
                this.blockHit = (BlockHitResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

