/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.datagen.builder;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class CustomSeparateModelBuilder<T extends ModelBuilder<T>>
extends CustomLoaderBuilder<T> {
    private String base;
    private final Map<String, String> childModels = new LinkedHashMap<String, String>();
    private final Map<String, ResourceLocation> texture = new LinkedHashMap<String, ResourceLocation>();

    public static <T extends ModelBuilder<T>> CustomSeparateModelBuilder<T> begin(T parent, ExistingFileHelper existingFileHelper) {
        return new CustomSeparateModelBuilder<T>(parent, existingFileHelper);
    }

    protected CustomSeparateModelBuilder(T parent, ExistingFileHelper existingFileHelper) {
        super(new ResourceLocation("forge:separate_transforms"), parent, existingFileHelper);
    }

    public CustomSeparateModelBuilder<T> base(String location) {
        Preconditions.checkNotNull((Object)location, (Object)"location must not be null");
        this.base = location;
        return this;
    }

    public CustomSeparateModelBuilder<T> perspective(ItemDisplayContext perspective, String location) {
        Preconditions.checkNotNull((Object)perspective, (Object)"perspective must not be null");
        Preconditions.checkNotNull((Object)location, (Object)"location must not be null");
        this.childModels.put(perspective.m_7912_(), location);
        return this;
    }

    public CustomSeparateModelBuilder<T> texture(String name, ResourceLocation location) {
        Preconditions.checkNotNull((Object)name, (Object)"name must not be null");
        Preconditions.checkNotNull((Object)location, (Object)"location must not be null");
        this.texture.put(name, location);
        return this;
    }

    public JsonObject toJson(JsonObject json) {
        json = super.toJson(json);
        if (this.base != null) {
            JsonObject base = new JsonObject();
            base.addProperty("parent", this.base);
            json.add("base", (JsonElement)base);
        }
        JsonObject parts = new JsonObject();
        for (Map.Entry<String, String> entry : this.childModels.entrySet()) {
            JsonObject part = new JsonObject();
            part.addProperty("parent", entry.getValue());
            parts.add(entry.getKey(), (JsonElement)part);
        }
        json.add("perspectives", (JsonElement)parts);
        JsonObject textures = new JsonObject();
        for (Map.Entry<String, ResourceLocation> entry : this.texture.entrySet()) {
            textures.addProperty(entry.getKey(), entry.getValue().toString());
        }
        json.add("textures", (JsonElement)textures);
        return json;
    }
}

