/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.tooltip;

import com.atsuishio.superbwarfare.client.tooltip.component.GunImageComponent;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.FireModeInfo;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.FormatTool;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class ClientGunImageTooltip
implements ClientTooltipComponent {
    protected final int width;
    protected final int height;
    protected final ItemStack stack;
    protected final GunData data;

    public ClientGunImageTooltip(GunImageComponent tooltip) {
        this.width = tooltip.width;
        this.height = tooltip.height;
        this.stack = tooltip.stack;
        this.data = GunData.from(this.stack);
    }

    public void m_183452_(@NotNull Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.m_280168_().m_85836_();
        this.renderDamageAndRpmTooltip(font, guiGraphics, x, y);
        this.renderLevelAndUpgradePointTooltip(font, guiGraphics, x, y + 10);
        int yo = 20;
        if (this.shouldRenderBypassAndHeadshotTooltip()) {
            this.renderBypassAndHeadshotTooltip(font, guiGraphics, x, y + yo);
            yo += 10;
        }
        if (this.shouldRenderEnergyTooltip()) {
            this.renderEnergyTooltip(font, guiGraphics, x, y + (yo += 10));
            yo += 10;
        }
        if (this.shouldRenderEditTooltip()) {
            this.renderWeaponEditTooltip(font, guiGraphics, x, y + yo);
            yo += 20;
        }
        if (this.shouldRenderPerks()) {
            if (!Screen.m_96638_()) {
                this.renderPerksShortcut(font, guiGraphics, x, y + yo);
            } else {
                this.renderPerks(font, guiGraphics, x, y + yo);
            }
        }
        guiGraphics.m_280168_().m_85849_();
    }

    protected boolean shouldRenderBypassAndHeadshotTooltip() {
        return this.data.compute().bypassesArmor > 0.0 || this.data.compute().headshot > 0.0;
    }

    protected boolean shouldRenderPerks() {
        return this.data.perk.get(Perk.Type.AMMO) != null || this.data.perk.get(Perk.Type.DAMAGE) != null || this.data.perk.get(Perk.Type.FUNCTIONAL) != null;
    }

    protected boolean shouldRenderEnergyTooltip() {
        return this.stack.getCapability(ForgeCapabilities.ENERGY).map(storage -> storage.getMaxEnergyStored() > 0).orElse(false);
    }

    protected boolean shouldRenderEditTooltip() {
        Item item = this.stack.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            return gunItem.canEditAttachments(GunData.from(this.stack));
        }
        return false;
    }

    protected void renderDamageAndRpmTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280430_(font, this.getDamageComponent(), x, y, 0xFFFFFF);
        int xo = font.m_92724_(this.getDamageComponent().m_7532_());
        guiGraphics.m_280430_(font, this.getRpmComponent(), x + xo + 16, y, 0xFFFFFF);
    }

    protected Component getDamageComponent() {
        DefaultGunData computed = this.data.compute();
        double damage = computed.damage;
        double explosionDamage = computed.explosionDamage;
        Object dmgStr = FormatTool.format1D(damage);
        if (computed.projectileAmount > 1) {
            dmgStr = (String)dmgStr + " * " + computed.projectileAmount;
        }
        MutableComponent component = Component.m_237115_((String)"des.superbwarfare.guns.damage").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)dmgStr).m_130940_(ChatFormatting.GREEN));
        if (explosionDamage > 0.0) {
            Object expDmgStr = FormatTool.format1D(explosionDamage);
            if (computed.projectileAmount > 1) {
                expDmgStr = (String)expDmgStr + " * " + computed.projectileAmount;
            }
            component = component.m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)(" + " + (String)expDmgStr)).m_130940_(ChatFormatting.GOLD));
        }
        return component;
    }

    protected Component getRpmComponent() {
        if (!(this.stack.m_41720_() instanceof GunItem)) {
            return Component.m_237119_();
        }
        GunData data = GunData.from(this.stack);
        FireModeInfo info = data.selectedFireModeInfo();
        if (info.mode == FireMode.AUTO || info.mode == FireMode.BURST) {
            return Component.m_237115_((String)"des.superbwarfare.guns.rpm").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)FormatTool.format0D(data.compute().rpm)).m_130940_(ChatFormatting.GREEN));
        }
        return Component.m_237119_();
    }

    protected void renderLevelAndUpgradePointTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280430_(font, this.getLevelComponent(), x, y, 0xFFFFFF);
        int xo = font.m_92724_(this.getLevelComponent().m_7532_());
        guiGraphics.m_280430_(font, this.getUpgradePointComponent(), x + xo + 16, y, 0xFFFFFF);
    }

    protected Component getLevelComponent() {
        int level = this.data.level.get();
        double rate = this.data.exp.get() / (20.0 * Math.pow(level, 2.0) + (double)(160 * level) + 20.0);
        ChatFormatting formatting = level < 10 ? ChatFormatting.WHITE : (level < 20 ? ChatFormatting.AQUA : (level < 30 ? ChatFormatting.LIGHT_PURPLE : (level < 40 ? ChatFormatting.GOLD : ChatFormatting.RED)));
        return Component.m_237115_((String)"des.superbwarfare.guns.level").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)("" + level)).m_130940_(formatting).m_130940_(ChatFormatting.BOLD)).m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)(" (" + FormatTool.DECIMAL_FORMAT_2ZZZ.format(rate * 100.0) + "%)")).m_130940_(ChatFormatting.GRAY));
    }

    protected Component getUpgradePointComponent() {
        int upgradePoint = this.data.level.get();
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance perkInstance = this.data.perk.getInstance(type);
            if (perkInstance == null) continue;
            upgradePoint -= perkInstance.level() - 1;
        }
        upgradePoint = Math.max(upgradePoint, 0);
        return Component.m_237115_((String)"des.superbwarfare.guns.upgrade_point").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)String.valueOf(upgradePoint)).m_130940_(ChatFormatting.WHITE).m_130940_(ChatFormatting.BOLD));
    }

    protected void renderBypassAndHeadshotTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280430_(font, this.getBypassComponent(), x, y, 0xFFFFFF);
        int xo = font.m_92724_(this.getBypassComponent().m_7532_());
        guiGraphics.m_280430_(font, this.getHeadshotComponent(), x + xo + 16, y, 0xFFFFFF);
    }

    protected Component getBypassComponent() {
        double bypassRate = Math.max(this.data.compute().bypassesArmor, 0.0);
        return Component.m_237115_((String)"des.superbwarfare.guns.bypass").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)FormatTool.format2D(bypassRate * 100.0, "%")).m_130940_(ChatFormatting.GOLD));
    }

    protected Component getHeadshotComponent() {
        double headshot = this.data.compute().headshot;
        return Component.m_237115_((String)"des.superbwarfare.guns.headshot").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)FormatTool.format1D(headshot, "x")).m_130940_(ChatFormatting.AQUA));
    }

    protected void renderEnergyTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280430_(font, this.getEnergyComponent(), x, y, 0xFFFFFF);
    }

    protected Component getEnergyComponent() {
        int i;
        assert (this.stack.getCapability(ForgeCapabilities.ENERGY).resolve().isPresent());
        IEnergyStorage storage = (IEnergyStorage)this.stack.getCapability(ForgeCapabilities.ENERGY).resolve().get();
        int energy = storage.getEnergyStored();
        int maxEnergy = storage.getMaxEnergyStored();
        float percentage = Mth.m_14036_((float)((float)energy / (float)maxEnergy), (float)0.0f, (float)1.0f);
        MutableComponent component = Component.m_237119_();
        ChatFormatting format = percentage <= 0.2f ? ChatFormatting.RED : (percentage <= 0.6f ? ChatFormatting.YELLOW : ChatFormatting.GREEN);
        int count = (int)(percentage * 50.0f);
        for (i = 0; i < count; ++i) {
            component.m_7220_((Component)Component.m_237113_((String)"|").m_130940_(format));
        }
        component.m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET));
        for (i = 0; i < 50 - count; ++i) {
            component.m_7220_((Component)Component.m_237113_((String)"|").m_130940_(ChatFormatting.GRAY));
        }
        component.m_7220_((Component)Component.m_237113_((String)(" " + energy + "/" + maxEnergy + " FE")).m_130940_(ChatFormatting.GRAY));
        return component;
    }

    protected void renderWeaponEditTooltip(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280430_(font, this.getEditComponent(), x, y + 10, 0xFFFFFF);
    }

    protected Component getEditComponent() {
        return Component.m_237110_((String)"des.superbwarfare.guns.edit", (Object[])new Object[]{"[" + ModKeyMappings.EDIT_MODE.getKey().m_84875_().getString() + "]"}).m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.ITALIC);
    }

    protected void renderPerksShortcut(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280168_().m_85836_();
        int xOffset = -20;
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance perkInstance = this.data.perk.getInstance(type);
            if (perkInstance == null) continue;
            Item ammoItem = (Item)perkInstance.perk().getItem().get();
            ItemStack perkStack = ammoItem.m_7968_();
            short level = perkInstance.level();
            perkStack.m_41764_((int)level);
            guiGraphics.m_280480_(perkStack, x + (xOffset += 20), y + 2);
            guiGraphics.m_280370_(font, perkStack, x + xOffset, y + 2);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    protected void renderPerks(Font font, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280430_(font, (Component)Component.m_237115_((String)"perk.superbwarfare.tips").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.UNDERLINE), x, y + 10, 0xFFFFFF);
        int yOffset = -5;
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance perkInstance = this.data.perk.getInstance(type);
            if (perkInstance == null) continue;
            Item ammoItem = (Item)perkInstance.perk().getItem().get();
            guiGraphics.m_280480_(ammoItem.m_7968_(), x, y + 4 + (yOffset += 25));
            String id = perkInstance.perk().descriptionId;
            MutableComponent component = Component.m_237115_((String)("item.superbwarfare." + id)).m_130940_(type.getColor()).m_7220_((Component)Component.m_237113_((String)" ").m_130940_(ChatFormatting.RESET)).m_7220_((Component)Component.m_237113_((String)(" Lvl. " + perkInstance.level())).m_130940_(ChatFormatting.WHITE));
            MutableComponent descComponent = Component.m_237115_((String)("des.superbwarfare." + id)).m_130940_(ChatFormatting.GRAY);
            guiGraphics.m_280430_(font, (Component)component, x + 20, y + yOffset + 2, 0xFFFFFF);
            guiGraphics.m_280430_(font, (Component)descComponent, x + 20, y + yOffset + 12, 0xFFFFFF);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    protected int getDefaultMaxWidth(Font font) {
        int width = font.m_92724_(this.getDamageComponent().m_7532_()) + font.m_92724_(this.getRpmComponent().m_7532_()) + 16;
        width = Math.max(width, font.m_92724_(this.getLevelComponent().m_7532_()) + font.m_92724_(this.getUpgradePointComponent().m_7532_()) + 16);
        if (this.shouldRenderBypassAndHeadshotTooltip()) {
            width = Math.max(width, font.m_92724_(this.getBypassComponent().m_7532_()) + font.m_92724_(this.getHeadshotComponent().m_7532_()) + 16);
        }
        if (this.shouldRenderEditTooltip()) {
            width = Math.max(width, font.m_92724_(this.getEditComponent().m_7532_()) + 16);
        }
        return width + 4;
    }

    protected int getMaxPerkDesWidth(Font font) {
        if (!this.shouldRenderPerks()) {
            return 0;
        }
        int width = 0;
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance perkInstance = this.data.perk.getInstance(type);
            if (perkInstance == null) continue;
            String id = perkInstance.perk().descriptionId;
            MutableComponent ammoDesComponent = Component.m_237115_((String)("des.superbwarfare." + id)).m_130940_(ChatFormatting.GRAY);
            width = Math.max(width, font.m_92852_((FormattedText)ammoDesComponent));
        }
        return width + 25;
    }

    public int m_142103_() {
        int height = Math.max(20, this.height);
        if (this.shouldRenderBypassAndHeadshotTooltip()) {
            height += 10;
        }
        if (this.shouldRenderEnergyTooltip()) {
            height += 20;
        }
        if (this.shouldRenderEditTooltip()) {
            height += 20;
        }
        if (this.shouldRenderPerks()) {
            height += 16;
            if (Screen.m_96638_()) {
                for (Perk.Type type : Perk.Type.values()) {
                    if (!this.data.perk.has(type)) continue;
                    height += 25;
                }
            }
        }
        return height;
    }

    public int m_142069_(@NotNull Font font) {
        int width = this.getMaxPerkDesWidth(font);
        width = Screen.m_96638_() ? (width == 0 ? Math.max(this.width, this.getDefaultMaxWidth(font)) : Math.max(width, this.getDefaultMaxWidth(font))) : this.getDefaultMaxWidth(font);
        if (this.shouldRenderEnergyTooltip()) {
            width = Math.max(width, font.m_92724_(this.getEnergyComponent().m_7532_()) + 10);
        }
        return width;
    }
}

