/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.sound;

import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class FastProjectileSoundInstance
extends AbstractTickableSoundInstance {
    private final Minecraft client;
    private final FastThrowableProjectile entity;
    private double lastDistance;
    private int fade = 0;
    private boolean die = false;

    public FastProjectileSoundInstance(SoundEvent sound, Minecraft client, FastThrowableProjectile entity) {
        super(sound, SoundSource.AMBIENT, entity.m_20193_().m_213780_());
        this.client = client;
        this.entity = entity;
        this.f_119578_ = true;
        this.f_119579_ = 0;
    }

    protected abstract boolean canPlay(FastThrowableProjectile var1);

    protected abstract float getPitch(FastThrowableProjectile var1);

    protected abstract float getVolume(FastThrowableProjectile var1);

    public void m_7788_() {
        LocalPlayer player = this.client.f_91074_;
        if (this.entity.m_213877_() || player == null) {
            this.m_119609_();
            return;
        }
        if (!this.canPlay(this.entity)) {
            this.die = true;
        }
        if (this.die) {
            if (this.fade > 0) {
                --this.fade;
            } else if (this.fade == 0) {
                this.m_119609_();
                return;
            }
        } else if (this.fade < 3) {
            ++this.fade;
        }
        this.f_119573_ = this.getVolume(this.entity) * (float)this.fade;
        this.f_119575_ = this.entity.m_20185_();
        this.f_119576_ = this.entity.m_20186_();
        this.f_119577_ = this.entity.m_20189_();
        this.f_119574_ = this.getPitch(this.entity);
        if (player.m_20202_() != this.entity) {
            double distance = this.entity.m_20182_().m_82546_(player.m_20182_()).m_82553_();
            this.f_119574_ += (float)(0.16 * Math.atan(this.lastDistance - distance));
            this.lastDistance = distance;
        } else {
            this.lastDistance = 0.0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FlySound
    extends FastProjectileSoundInstance {
        public FlySound(FastThrowableProjectile entity) {
            super(entity.getSound(), Minecraft.m_91087_(), entity);
        }

        @Override
        protected boolean canPlay(FastThrowableProjectile entity) {
            return entity.isFastMoving();
        }

        @Override
        protected float getPitch(FastThrowableProjectile entity) {
            return 1.0f;
        }

        @Override
        protected float getVolume(FastThrowableProjectile entity) {
            return (float)Math.min((double)entity.getVolume() * 0.1 * entity.m_20184_().m_82553_(), 1.5);
        }
    }
}

