/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.vehicle.subdata.VehicleContainerType;
import com.atsuishio.superbwarfare.menu.VehicleMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class VehicleScreen
extends AbstractContainerScreen<VehicleMenu> {
    private static final ResourceLocation MINI = Mod.loc("textures/gui/vehicle/inventory/mini.png");
    private static final ResourceLocation SMALL = Mod.loc("textures/gui/vehicle/inventory/small.png");
    private static final ResourceLocation MEDIUM = Mod.loc("textures/gui/vehicle/inventory/medium.png");
    private static final ResourceLocation LARGE = Mod.loc("textures/gui/vehicle/inventory/large.png");
    private static final ResourceLocation HUGE = Mod.loc("textures/gui/vehicle/inventory/huge.png");
    private static final ResourceLocation INVENTORY = Mod.loc("textures/gui/vehicle/inventory/player_inventory.png");
    private static final ResourceLocation INVENTORY_UPGRADE = Mod.loc("textures/gui/vehicle/inventory/player_inventory_upgrade.png");
    private final VehicleContainerType type;
    private final boolean hasUpgradeSlots;
    public static final int X_OFFSET = 8;
    public static final int INVENTORY_TEXTURE_SIZE = 256;

    public VehicleScreen(VehicleMenu pMenu, Inventory pPlayerInventory, Component pTitle, VehicleContainerType type) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.type = type;
        this.hasUpgradeSlots = pMenu.hasUpgradeSlots();
        this.f_97726_ = switch (type) {
            default -> 222;
            case VehicleContainerType.HUGE -> 320;
        };
        this.f_97727_ = (switch (type) {
            default -> 132;
            case VehicleContainerType.HUGE -> 132;
        }) + 90;
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        ResourceLocation texture;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        switch (this.type) {
            default: {
                ResourceLocation resourceLocation = null;
                break;
            }
            case MINI: {
                ResourceLocation resourceLocation = MINI;
                break;
            }
            case SMALL: {
                ResourceLocation resourceLocation = SMALL;
                break;
            }
            case MEDIUM: {
                ResourceLocation resourceLocation = MEDIUM;
                break;
            }
            case LARGE: {
                ResourceLocation resourceLocation = LARGE;
                break;
            }
            case HUGE: {
                ResourceLocation resourceLocation = texture = HUGE;
            }
        }
        if (texture == null) {
            return;
        }
        int size = this.type == VehicleContainerType.HUGE ? 328 : 256;
        pGuiGraphics.m_280163_(texture, i + 8, j, 0.0f, 0.0f, this.f_97726_, this.f_97727_, size, size);
        int x = i + 8 + (((VehicleMenu)this.f_97732_).getContainerCols() - 9) / 2 * 18;
        if (this.hasUpgradeSlots) {
            pGuiGraphics.m_280163_(INVENTORY_UPGRADE, x - 24, j + this.f_97727_ - 90, 0.0f, 0.0f, 198, 90, 256, 256);
        } else {
            pGuiGraphics.m_280163_(INVENTORY, x, j + this.f_97727_ - 90, 0.0f, 0.0f, 175, 90, 256, 256);
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = 15;
        this.f_97729_ = 5;
        this.f_97730_ = (((VehicleMenu)this.f_97732_).getContainerCols() - 9) / 2 * 18 + this.f_97728_;
        this.f_97731_ = 128;
    }
}

