/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.screens;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.network.NetworkRegistry;
import com.atsuishio.superbwarfare.network.message.send.FiringParametersEditMessage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FiringParametersScreen
extends Screen {
    private static final ResourceLocation TEXTURE = Mod.loc("textures/gui/firing_parameters.png");
    private final ItemStack stack;
    private final InteractionHand hand;
    public EditBox posX;
    public EditBox posY;
    public EditBox posZ;
    public EditBox radius;
    public boolean isDepressed;
    private boolean init = false;
    protected int imageWidth = 94;
    protected int imageHeight = 126;

    public FiringParametersScreen(ItemStack stack, InteractionHand hand) {
        super(GameNarrator.f_93310_);
        this.stack = stack;
        this.hand = hand;
        if (!stack.m_41619_()) {
            this.isDepressed = stack.m_41784_().m_128471_("IsDepressed");
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        super.m_86600_();
        if (!this.init) {
            if (!this.stack.m_41619_()) {
                this.posX.m_94144_("" + this.stack.m_41784_().m_128451_("TargetX"));
                this.posY.m_94144_("" + this.stack.m_41784_().m_128451_("TargetY"));
                this.posZ.m_94144_("" + this.stack.m_41784_().m_128451_("TargetZ"));
                this.radius.m_94144_("" + Math.max(0, this.stack.m_41784_().m_128451_("Radius")));
            }
            this.init = true;
        }
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        this.renderBg(pGuiGraphics, pMouseX, pMouseY);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderPositions(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    protected void renderPositions(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PoseStack poseStack = pGuiGraphics.m_280168_();
        poseStack.m_85836_();
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = (this.f_96544_ - this.imageHeight) / 2;
        poseStack.m_272245_(Axis.f_252403_.m_252977_(5.0f), (float)(i + 41), (float)(j + 22), 0.0f);
        this.posX.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.posY.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.posZ.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.radius.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        poseStack.m_85849_();
    }

    protected void renderBg(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = (this.f_96544_ - this.imageHeight) / 2;
        pGuiGraphics.m_280163_(TEXTURE, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 140, 140);
        if (pMouseX >= i + 12 && pMouseX <= i + 47 && pMouseY >= j + 89 && pMouseY <= j + 109) {
            pGuiGraphics.m_280557_(this.f_96547_, (Component)(this.isDepressed ? Component.m_237115_((String)"tips.superbwarfare.mortar.target_pos.depressed_trajectory").m_130940_(ChatFormatting.WHITE) : Component.m_237115_((String)"tips.superbwarfare.mortar.target_pos.lofted_trajectory").m_130940_(ChatFormatting.WHITE)), pMouseX, pMouseY);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.subInit();
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = (this.f_96544_ - this.imageHeight) / 2;
        ModeButton modeButton = new ModeButton(i + 12, j + 89, 35, 20);
        this.m_142416_((GuiEventListener)modeButton);
        DoneButton doneButton = new DoneButton(i + 50, j + 94, 23, 14);
        this.m_142416_((GuiEventListener)doneButton);
    }

    protected void subInit() {
        int i = (this.f_96543_ - this.imageWidth) / 2;
        int j = (this.f_96544_ - this.imageHeight) / 2;
        this.posX = new EditBox(this.f_96547_, i + 44, j + 20, 60, 12, (Component)Component.m_237119_());
        this.initEditBox(this.posX);
        this.posY = new EditBox(this.f_96547_, i + 43, j + 37, 60, 12, (Component)Component.m_237119_());
        this.initEditBox(this.posY);
        this.posZ = new EditBox(this.f_96547_, i + 42, j + 54, 60, 12, (Component)Component.m_237119_());
        this.initEditBox(this.posZ);
        this.radius = new EditBox(this.f_96547_, i + 41, j + 71, 20, 12, (Component)Component.m_237119_());
        this.initEditBox(this.radius);
        this.radius.m_94199_(2);
        this.radius.m_94153_(s -> s.matches("\\d*"));
    }

    protected void initEditBox(EditBox editBox) {
        editBox.m_94190_(true);
        editBox.m_94202_(11706236);
        editBox.m_94205_(5983292);
        editBox.m_94182_(false);
        editBox.m_94199_(9);
        this.m_7787_((GuiEventListener)editBox);
        editBox.m_94186_(true);
        editBox.m_94153_(s -> s.matches("-?\\d*"));
    }

    @OnlyIn(value=Dist.CLIENT)
    class ModeButton
    extends AbstractButton {
        public ModeButton(int pX, int pY, int pWidth, int pHeight) {
            super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_());
        }

        public void m_5691_() {
            FiringParametersScreen.this.isDepressed = !FiringParametersScreen.this.isDepressed;
        }

        protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            boolean isDepressed = FiringParametersScreen.this.isDepressed;
            pGuiGraphics.m_280163_(TEXTURE, this.m_252754_(), isDepressed ? this.m_252907_() + 10 : this.m_252907_(), 96.0f, isDepressed ? 37.0f : 16.0f, 35, isDepressed ? 10 : 20, 140, 140);
        }

        protected void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class DoneButton
    extends AbstractButton {
        public DoneButton(int pX, int pY, int pWidth, int pHeight) {
            super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_());
        }

        public void m_5691_() {
            if (!FiringParametersScreen.this.init) {
                return;
            }
            if (FiringParametersScreen.this.f_96541_ != null) {
                FiringParametersScreen.this.f_96541_.m_91152_(null);
            }
            NetworkRegistry.PACKET_HANDLER.sendToServer((Object)new FiringParametersEditMessage(this.getEditBoxValue(FiringParametersScreen.this.posX.m_94155_()), this.getEditBoxValue(FiringParametersScreen.this.posY.m_94155_()), this.getEditBoxValue(FiringParametersScreen.this.posZ.m_94155_()), Math.max(0, this.getEditBoxValue(FiringParametersScreen.this.radius.m_94155_())), FiringParametersScreen.this.isDepressed, FiringParametersScreen.this.hand == InteractionHand.MAIN_HAND));
        }

        protected void m_87963_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            if (this.f_93622_) {
                pGuiGraphics.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), 95.0f, 1.0f, 23, 14, 140, 140);
            }
        }

        protected void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }

        public int getEditBoxValue(String value) {
            if (value.equals("-")) {
                return 0;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
    }
}

