/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.special;

import com.atsuishio.superbwarfare.block.ContainerBlock;
import com.atsuishio.superbwarfare.block.entity.ContainerBlockEntity;
import com.atsuishio.superbwarfare.client.renderer.ModRenderTypes;
import com.atsuishio.superbwarfare.init.ModTags;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ContainerBlockPreview {
    @SubscribeEvent
    public static void render(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        assert (player != null);
        ItemStack item = player.m_21205_();
        if (!item.m_204117_(ModTags.Items.TOOLS_CROWBAR)) {
            return;
        }
        Level level = player.m_9236_();
        Vec3 look = player.m_20154_();
        int distance = 32;
        Vec3 start = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 end = player.m_20182_().m_82520_(look.f_82479_ * (double)distance, look.f_82480_ * (double)distance + (double)player.m_20192_(), look.f_82481_ * (double)distance);
        ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult result = player.m_9236_().m_45547_(context);
        if (result.m_6662_().equals((Object)HitResult.Type.MISS)) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(result.m_82425_());
        if (!(blockEntity instanceof ContainerBlockEntity)) {
            return;
        }
        ContainerBlockEntity container = (ContainerBlockEntity)blockEntity;
        EntityType<?> entityType = container.entityType;
        CompoundTag entityTag = container.entityTag;
        if (entityType == null) {
            return;
        }
        Entity entity = entityType.m_20615_(level);
        if (entity != null && entityTag != null) {
            entity.m_20258_(entityTag);
        }
        int w = (int)(entityType.m_20680_().f_20377_ / 2.0f + 1.0f);
        int h = (int)(entityType.m_20680_().f_20378_ + 1.0f);
        if (entity != null) {
            w = (int)(entity.m_6095_().m_20680_().f_20377_ / 2.0f + 1.0f);
            h = (int)(entity.m_6095_().m_20680_().f_20378_ + 1.0f);
        }
        if (w == 0 || h == 0) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        BlockPos pos = container.m_58899_();
        Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_((double)pos.m_123341_() - view.f_82479_, (double)pos.m_123342_() - view.f_82480_ + 1.0, (double)pos.m_123343_() - view.f_82481_);
        AABB aabb = new AABB(pos).m_82377_((double)w, 0.0, (double)w).m_82363_(0.0, (double)(h - 1), 0.0).m_82386_(0.0, -1.0, 0.0);
        float startX = (float)aabb.f_82288_ - 0.001f - (float)pos.m_123341_();
        float startY = (float)aabb.f_82289_ - 0.001f - (float)pos.m_123342_();
        float startZ = (float)aabb.f_82290_ - 0.001f - (float)pos.m_123343_();
        float endX = (float)aabb.f_82291_ + 0.001f - (float)pos.m_123341_();
        float endY = (float)aabb.f_82292_ + 0.001f - (float)pos.m_123342_();
        float endZ = (float)aabb.f_82293_ + 0.001f - (float)pos.m_123343_();
        boolean hasEnoughSpace = ContainerBlock.canOpen(level, pos, entityType, entityTag);
        int red = hasEnoughSpace ? 0 : 1;
        int green = 1 - red;
        float blue = 0.0f;
        float alpha = 0.2f;
        VertexConsumer builder = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(ModRenderTypes.BLOCK_OVERLAY);
        Matrix4f m4f = poseStack.m_85850_().m_252922_();
        builder.m_252986_(m4f, startX, startY, startZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, startX, endY, startZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, endX, endY, startZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, endX, startY, startZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, startX, startY, endZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, endX, startY, endZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, endX, endY, endZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, startX, endY, endZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, endX, startY, startZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, endX, endY, startZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, endX, endY, endZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, endX, startY, endZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, startX, startY, startZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, startX, startY, endZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, startX, endY, endZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, startX, endY, startZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, startX, endY, startZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, endX, endY, startZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, endX, endY, endZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, startX, endY, endZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, startX, startY, startZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, endX, startY, startZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, endX, startY, endZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        builder.m_252986_(m4f, startX, startY, endZ).m_85950_((float)red, (float)green, blue, alpha).m_5752_();
        poseStack.m_85849_();
    }
}

