/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.renderer.entity;

import com.atsuishio.superbwarfare.client.renderer.ModRenderTypes;
import com.atsuishio.superbwarfare.entity.projectile.AbstractLaserEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractLaserEntityRenderer<T extends AbstractLaserEntity>
extends EntityRenderer<T> {
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private final float quadRadius;
    private final float beamRadius;

    public AbstractLaserEntityRenderer(EntityRendererProvider.Context context, float quadRadius, float beamRadius) {
        super(context);
        this.quadRadius = quadRadius;
        this.beamRadius = beamRadius;
    }

    @NotNull
    public abstract ResourceLocation getTextureLocation(@NotNull T var1);

    @ParametersAreNonnullByDefault
    public void render(T beam, float entityYaw, float delta, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        double collidePosX = ((AbstractLaserEntity)((Object)beam)).prevCollidePosX + (((AbstractLaserEntity)((Object)beam)).collidePosX - ((AbstractLaserEntity)((Object)beam)).prevCollidePosX) * (double)delta;
        double collidePosY = ((AbstractLaserEntity)((Object)beam)).prevCollidePosY + (((AbstractLaserEntity)((Object)beam)).collidePosY - ((AbstractLaserEntity)((Object)beam)).prevCollidePosY) * (double)delta;
        double collidePosZ = ((AbstractLaserEntity)((Object)beam)).prevCollidePosZ + (((AbstractLaserEntity)((Object)beam)).collidePosZ - ((AbstractLaserEntity)((Object)beam)).prevCollidePosZ) * (double)delta;
        double posX = ((AbstractLaserEntity)((Object)beam)).f_19854_ + (beam.m_20185_() - ((AbstractLaserEntity)((Object)beam)).f_19854_) * (double)delta;
        double posY = ((AbstractLaserEntity)((Object)beam)).f_19855_ + (beam.m_20186_() - ((AbstractLaserEntity)((Object)beam)).f_19855_) * (double)delta;
        double posZ = ((AbstractLaserEntity)((Object)beam)).f_19856_ + (beam.m_20189_() - ((AbstractLaserEntity)((Object)beam)).f_19856_) * (double)delta;
        float yaw = ((AbstractLaserEntity)((Object)beam)).preYaw + (((AbstractLaserEntity)((Object)beam)).yaw - ((AbstractLaserEntity)((Object)beam)).preYaw) * delta;
        float pitch = ((AbstractLaserEntity)((Object)beam)).prePitch + (((AbstractLaserEntity)((Object)beam)).pitch - ((AbstractLaserEntity)((Object)beam)).prePitch) * delta;
        float length = (float)Math.sqrt(Math.pow(collidePosX - posX, 2.0) + Math.pow(collidePosY - posY, 2.0) + Math.pow(collidePosZ - posZ, 2.0));
        int frame = Mth.m_14143_((float)(((float)(((AbstractLaserEntity)((Object)beam)).ticker.getTick() - 1) + delta) * 2.0f));
        if (frame < 0) {
            frame = 6;
        }
        if (!((AbstractLaserEntity)((Object)beam)).isAccumulating()) {
            return;
        }
        VertexConsumer vertex$builder = bufferIn.m_6299_(ModRenderTypes.LASER.apply(this.getTextureLocation(beam)));
        this.renderStart(beam, frame, matrixStackIn, vertex$builder, delta, packedLightIn);
        this.renderBeam(length, 57.295776f * yaw, 57.295776f * pitch, frame, matrixStackIn, vertex$builder, packedLightIn);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(collidePosX - posX, collidePosY - posY, collidePosZ - posZ);
        this.renderEnd(beam, frame, ((AbstractLaserEntity)((Object)beam)).blockSide, matrixStackIn, vertex$builder, delta, packedLightIn);
        matrixStackIn.m_85849_();
    }

    protected void renderFlatQuad(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn, boolean inGround) {
        float minU = 0.0f + 0.0625f * (float)frame;
        float minV = 0.0f;
        float maxU = minU + 0.0625f;
        float maxV = minV + 0.5f;
        float SIZE = this.quadRadius + (inGround ? 0.2f : 0.0f);
        PoseStack.Pose matrix$stack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrix$stack$entry.m_252922_();
        Matrix3f matrix3f = matrix$stack$entry.m_252943_();
        this.drawVertex(matrix4f, matrix3f, builder, -SIZE, -SIZE, 0.0f, minU, minV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -SIZE, SIZE, 0.0f, minU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, SIZE, SIZE, 0.0f, maxU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, SIZE, -SIZE, 0.0f, maxU, minV, packedLightIn);
    }

    protected void renderStart(T entity, int frame, PoseStack matrixStackIn, VertexConsumer builder, float delta, int packedLightIn) {
        matrixStackIn.m_85836_();
        Quaternionf quaternionf = this.f_114476_.m_253208_();
        matrixStackIn.m_252781_(quaternionf);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, false);
        matrixStackIn.m_85849_();
    }

    protected void renderEnd(T entity, int frame, Direction side, PoseStack matrixStackIn, VertexConsumer builder, float delta, int packedLightIn) {
        matrixStackIn.m_85836_();
        Quaternionf quaternionf = this.f_114476_.m_253208_();
        matrixStackIn.m_252781_(quaternionf);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, false);
        matrixStackIn.m_85849_();
        if (side == null) {
            return;
        }
        matrixStackIn.m_85836_();
        Quaternionf rotation = side.m_253075_();
        rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(90.0f));
        matrixStackIn.m_252781_(rotation);
        matrixStackIn.m_252880_(0.0f, 0.0f, -0.01f);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, true);
        matrixStackIn.m_85849_();
    }

    protected void renderBeam(float length, float yaw, float pitch, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(yaw - 90.0f));
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-pitch));
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() + 90.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() - 90.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() + 180.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() - 180.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85849_();
    }

    protected void drawBeam(float length, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 0.0f;
        float minV = 0.5f + 0.03125f * (float)frame;
        float maxU = minU + 0.078125f;
        float maxV = minV + 0.03125f;
        PoseStack.Pose matrix$stack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrix$stack$entry.m_252922_();
        Matrix3f matrix3f = matrix$stack$entry.m_252943_();
        float offset = 0.0f;
        float size = this.beamRadius;
        this.drawVertex(matrix4f, matrix3f, builder, -size, offset, 0.0f, minU, minV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -size, length, 0.0f, minU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, size, length, 0.0f, maxU, maxV, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, size, offset, 0.0f, maxU, minV, packedLightIn);
    }

    protected void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, int packedLightIn) {
        vertexBuilder.m_252986_(matrix, offsetX, offsetY, offsetZ).m_6122_(1, 1, 1, 1).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

