/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.particle;

import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class CannonMuzzleFlareOption
implements ParticleOptions {
    public static final Codec<CannonMuzzleFlareOption> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("color").forGetter(option -> option.color), (App)Codec.INT.fieldOf("life").forGetter(option -> option.life), (App)Codec.FLOAT.fieldOf("fade").forGetter(option -> Float.valueOf(option.fade)), (App)Codec.INT.fieldOf("animationSpeed").forGetter(option -> option.animation_speed), (App)Codec.FLOAT.fieldOf("sizeAdd").forGetter(option -> Float.valueOf(option.sizeAdd))).apply((Applicative)builder, CannonMuzzleFlareOption::new));
    public static final ParticleOptions.Deserializer<CannonMuzzleFlareOption> DESERIALIZER = new ParticleOptions.Deserializer<CannonMuzzleFlareOption>(){

        public CannonMuzzleFlareOption fromCommand(ParticleType<CannonMuzzleFlareOption> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int color = reader.readInt();
            reader.expect(' ');
            int life = reader.readInt();
            reader.expect(' ');
            float fade = reader.readFloat();
            reader.expect(' ');
            int animation_speed = reader.readInt();
            reader.expect(' ');
            float sizeAdd = reader.readFloat();
            return new CannonMuzzleFlareOption(color, life, fade, animation_speed, sizeAdd);
        }

        public CannonMuzzleFlareOption fromNetwork(ParticleType<CannonMuzzleFlareOption> particleType, FriendlyByteBuf buffer) {
            return new CannonMuzzleFlareOption(buffer.readInt(), buffer.readInt(), buffer.readFloat(), buffer.readInt(), buffer.readFloat());
        }
    };
    private final int color;
    private final int life;
    private final float fade;
    private final int animation_speed;
    private final float sizeAdd;

    public CannonMuzzleFlareOption(float r, float g, float b, int life, float fade, int animation_speed, float sizeAdd) {
        this(Math.round(r * 255.0f) << 16 | Math.round(g * 255.0f) << 8 | Math.round(b * 255.0f), life, fade, animation_speed, sizeAdd);
    }

    public CannonMuzzleFlareOption(int color, int life, float fade, int animation_speed, float sizeAdd) {
        this.color = color;
        this.life = life;
        this.fade = fade;
        this.animation_speed = animation_speed;
        this.sizeAdd = sizeAdd;
    }

    public float getRed() {
        return (float)(this.color >> 16 & 0xFF) / 255.0f;
    }

    public float getGreen() {
        return (float)(this.color >> 8 & 0xFF) / 255.0f;
    }

    public float getBlue() {
        return (float)(this.color & 0xFF) / 255.0f;
    }

    public int getLife() {
        return this.life;
    }

    public float getFade() {
        return this.fade;
    }

    public int getAnimationSpeed() {
        return this.animation_speed;
    }

    public float getSizeAdd() {
        return this.sizeAdd;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticleTypes.CANNON_MUZZLE_FLARE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.color);
        buffer.writeInt(this.life);
        buffer.writeFloat(this.fade);
        buffer.writeInt(this.animation_speed);
        buffer.writeFloat(this.sizeAdd);
    }

    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()) + " [" + this.color + ", " + this.life + ", " + this.fade + ", " + this.animation_speed + ", " + this.sizeAdd + "]";
    }
}

