/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay.weapon;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.VehicleHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.VehicleMainWeaponHudOverlay;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.MathTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class HelicopterHud {
    public static final String ID = "@Helicopter";
    private static final ResourceLocation HELI_BASE = Mod.loc("textures/overlay/vehicle/helicopter/heli_base.png");
    private static final ResourceLocation ROLL_IND = Mod.loc("textures/overlay/vehicle/helicopter/roll_ind.png");
    private static final ResourceLocation HELI_LINE = Mod.loc("textures/overlay/vehicle/helicopter/heli_line.png");
    private static final ResourceLocation HELI_POWER_RULER = Mod.loc("textures/overlay/vehicle/helicopter/heli_power_ruler.png");
    private static final ResourceLocation HELI_POWER = Mod.loc("textures/overlay/vehicle/helicopter/heli_power.png");
    private static final ResourceLocation HELI_VY_MOVE = Mod.loc("textures/overlay/vehicle/helicopter/heli_vy_move.png");
    private static final ResourceLocation SPEED_FRAME = Mod.loc("textures/overlay/vehicle/helicopter/speed_frame.png");
    private static final ResourceLocation CROSSHAIR_IND = Mod.loc("textures/overlay/vehicle/helicopter/crosshair_ind.png");
    private static final ResourceLocation HELI_DRIVER_ANGLE = Mod.loc("textures/overlay/vehicle/helicopter/heli_driver_angle.png");
    private static final ResourceLocation FRAME = Mod.loc("textures/overlay/vehicle/land/tv_frame.png");
    private static final ResourceLocation LINE = Mod.loc("textures/overlay/vehicle/land/line.png");
    private static final ResourceLocation COMPASS = Mod.loc("textures/overlay/vehicle/base/compass.png");
    private static final ResourceLocation CROSSHAIR_3P = Mod.loc("textures/overlay/vehicle/crosshair/third_camera.png");
    private static float scopeScale = 1.0f;
    private static float lerpVy = 1.0f;
    private static float lerpPower = 1.0f;

    public static void render(VehicleEntity vehicle, Player player, ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = gui.getMinecraft();
        PoseStack poseStack = guiGraphics.m_280168_();
        int index = vehicle.getSeatIndex((Entity)player);
        GunData data = vehicle.getGunData(index);
        if (data == null) {
            scopeScale = 0.7f;
            return;
        }
        int color = vehicle.getHudColor();
        if (vehicle.getSeatIndex((Entity)player) == vehicle.computed().turretControllerIndex && vehicle.hasTurret()) {
            if (ClientEventHandler.zoomVehicle) {
                VehicleMainWeaponHudOverlay.renderWeaponInfoFirst(guiGraphics, vehicle, player, vehicle.getGunData((Entity)player), mc.f_91062_, screenWidth, screenHeight, color);
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderHelper.blit(poseStack, COMPASS, (float)screenWidth / 2.0f - 128.0f, 10.0f, (float)(128.0 - 1.4222222566604614 * VehicleVecUtils.getYRotFromVector(vehicle.getBarrelVector(partialTick))), 0.0f, 256.0f, 16.0f, 512.0f, 16.0f, color);
                RenderHelper.blit(poseStack, ROLL_IND, (float)screenWidth / 2.0f - 8.0f, 30.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, color);
                int addW = screenWidth / screenHeight * 48;
                int addH = screenWidth / screenHeight * 27;
                RenderHelper.preciseBlit(guiGraphics, FRAME, (float)(-addW) / 2.0f, (float)(-addH) / 2.0f, 10.0f, 0.0f, 0.0f, screenWidth + addW, screenHeight + addH, screenWidth + addW, screenHeight + addH);
                RenderHelper.blit(poseStack, LINE, (float)screenWidth / 2.0f - 64.0f, (float)(screenHeight - 56), 0.0f, 0.0f, 128.0f, 1.0f, 128.0f, 1.0f, color);
                guiGraphics.m_280614_(mc.f_91062_, (Component)Component.m_237113_((String)FormatTool.format0D(vehicle.m_20184_().m_82526_(vehicle.m_20252_(partialTick)) * 72.0, " km/h")), screenWidth / 2 + 160, screenHeight / 2 - 48, color, false);
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)FormatTool.format0D(vehicle.m_20186_(), " m")), screenWidth / 2 + 160, screenHeight / 2 - 39, color, false);
                VehicleMainWeaponHudOverlay.renderEnergyInfo(vehicle, guiGraphics, screenWidth, screenHeight, mc.f_91062_);
                boolean lookAtEntity = false;
                BlockHitResult result = player.m_9236_().m_45547_(new ClipContext(vehicle.getShootPosForHud((Entity)player, partialTick), vehicle.getShootPosForHud((Entity)player, partialTick).m_82549_(vehicle.getShootDirectionForHud((Entity)player, partialTick).m_82490_(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
                Vec3 hitPos = result.m_82450_();
                double blockRange = player.m_20299_(1.0f).m_82554_(hitPos);
                double entityRange = 0.0;
                Entity lookingEntity = TraceTool.camerafFindLookingEntity(player, vehicle.getShootPosForHud((Entity)player, partialTick), vehicle.getShootDirectionForHud((Entity)player, partialTick), 512.0);
                if (lookingEntity != null) {
                    lookAtEntity = true;
                    entityRange = player.m_20270_(lookingEntity);
                }
                if (lookAtEntity) {
                    int width = Minecraft.m_91087_().f_91062_.m_92895_(FormatTool.format0D(entityRange, " m"));
                    guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)FormatTool.format0D(entityRange, " m")), screenWidth / 2 - width / 2, screenHeight - 53, color, false);
                } else if (blockRange > 500.0) {
                    int width = Minecraft.m_91087_().f_91062_.m_92895_("---m");
                    guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)"---m"), screenWidth / 2 - width / 2, screenHeight - 53, color, false);
                } else {
                    int width = Minecraft.m_91087_().f_91062_.m_92895_(FormatTool.format0D(blockRange, " m"));
                    guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)FormatTool.format0D(blockRange, " m")), screenWidth / 2 - width / 2, screenHeight - 53, color, false);
                }
            }
        } else {
            poseStack.m_85836_();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            scopeScale = Mth.m_14179_((float)partialTick, (float)scopeScale, (float)1.0f);
            float f = Math.min((int)screenWidth, (int)screenHeight);
            float f1 = Math.min((float)((float)screenWidth / f), (float)((float)screenHeight / f)) * scopeScale;
            float i = Mth.m_14143_((float)(f * f1));
            float j = Mth.m_14143_((float)(f * f1));
            float k = ((float)screenWidth - i) / 2.0f;
            float l = ((float)screenHeight - j) / 2.0f;
            Vec3 shootPos = vehicle.getShootPosForHud((Entity)player, partialTick);
            BlockHitResult result = player.m_9236_().m_45547_(new ClipContext(shootPos, shootPos.m_82549_(vehicle.getShootDirectionForHud((Entity)player, partialTick).m_82490_(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            Vec3 hitPos = result.m_82450_();
            double dis = shootPos.m_82554_(hitPos);
            Entity lookingEntity = vehicle.getPlayerLookAtEntityOnVehicle((Entity)player, 512.0, partialTick);
            if (lookingEntity != null) {
                dis = shootPos.m_82554_(lookingEntity.m_20182_());
            }
            Vec3 pos = shootPos.m_82549_(vehicle.getShootDirectionForHud((Entity)player, partialTick).m_82490_(dis));
            Vec3 screenPos = VectorUtil.worldToScreen(pos);
            double speed = vehicle.m_20184_().m_82553_() * 72.0;
            double height = vehicle.m_20182_().m_82554_(Vec3.m_82528_((Vec3i)vehicle.m_9236_().m_45547_(new ClipContext(vehicle.m_20182_(), vehicle.m_20182_().m_82549_(new Vec3(0.0, -1.0, 0.0).m_82490_(100.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)vehicle)).m_82425_()));
            double blockInWay = vehicle.m_20182_().m_82554_(Vec3.m_82528_((Vec3i)vehicle.m_9236_().m_45547_(new ClipContext(vehicle.m_20182_(), vehicle.m_20182_().m_82549_(vehicle.m_20184_().m_82520_(0.0, 0.06, 0.0).m_82541_().m_82490_(100.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)vehicle)).m_82425_()));
            float x = (float)screenPos.f_82479_;
            float y = (float)screenPos.f_82480_;
            if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON || ClientEventHandler.zoomVehicle) {
                RenderHelper.blit(poseStack, HELI_BASE, k, l, 0.0f, 0.0f, i, j, i, j, color);
                float diffY = -Mth.m_14179_((float)partialTick, (float)vehicle.turretYRotO, (float)vehicle.getTurretYRot()) * 0.3f;
                float diffX = (float)(Mth.m_14175_((double)(-VehicleVecUtils.getXRotFromVector(vehicle.getBarrelVector(partialTick)) - (double)Mth.m_14179_((float)partialTick, (float)vehicle.f_19860_, (float)vehicle.m_146909_()))) * (double)0.072f);
                RenderHelper.blit(poseStack, HELI_DRIVER_ANGLE, k + diffY, l + diffX, 0.0f, 0.0f, i, j, i, j, color);
                RenderHelper.blit(poseStack, COMPASS, (float)screenWidth / 2.0f - 128.0f, 6.0f, 128.0f + 1.4222223f * vehicle.m_146908_(), 0.0f, 256.0f, 16.0f, 512.0f, 16.0f, color);
                poseStack.m_85836_();
                poseStack.m_272245_(Axis.f_252403_.m_252977_(-vehicle.getRoll(partialTick)), (float)screenWidth / 2.0f, (float)screenHeight / 2.0f, 0.0f);
                float pitch = vehicle.getPitch(partialTick);
                RenderHelper.blit(poseStack, HELI_LINE, (float)screenWidth / 2.0f - 128.0f, (float)screenHeight / 2.0f - 512.0f - 5.475f * pitch, 0.0f, 0.0f, 256.0f, 1024.0f, 256.0f, 1024.0f, color);
                poseStack.m_85849_();
                poseStack.m_85836_();
                poseStack.m_272245_(Axis.f_252403_.m_252977_(vehicle.getRoll(partialTick)), (float)screenWidth / 2.0f, (float)screenHeight / 2.0f - 56.0f, 0.0f);
                RenderHelper.blit(poseStack, ROLL_IND, (float)screenWidth / 2.0f - 8.0f, (float)screenHeight / 2.0f - 88.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, color);
                poseStack.m_85849_();
                RenderHelper.blit(poseStack, HELI_POWER_RULER, (float)screenWidth / 2.0f + 100.0f, (float)screenHeight / 2.0f - 64.0f, 0.0f, 0.0f, 64.0f, 128.0f, 64.0f, 128.0f, color);
                float power = vehicle.getPower();
                lerpPower = Mth.m_14179_((float)(0.001f * partialTick), (float)lerpPower, (float)power);
                RenderHelper.blit(poseStack, HELI_POWER, (float)screenWidth / 2.0f + 130.0f, (float)screenHeight / 2.0f - 64.0f + 124.0f - power * 980.0f, 0.0f, 0.0f, 4.0f, power * 980.0f, 4.0f, power * 980.0f, color);
                lerpVy = (float)Mth.m_14139_((double)(0.021f * partialTick), (double)lerpVy, (double)(vehicle.m_20184_().m_7098_() * 20.0));
                RenderHelper.blit(poseStack, HELI_VY_MOVE, (float)screenWidth / 2.0f + 138.0f, (float)screenHeight / 2.0f - 3.0f - Math.max((float)lerpVy, (float)-24.0f) * 2.5f, 0.0f, 0.0f, 8.0f, 8.0f, 8.0f, 8.0f, color);
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)FormatTool.format0D(lerpVy, "m/s")), screenWidth / 2 + 146, (int)((double)((float)screenHeight / 2.0f - 3.0f) - (double)Math.max((float)lerpVy, (float)-24.0f) * 2.5), lerpVy < -24.0f || (lerpVy < -10.0f || lerpVy < -1.0f && speed > 100.0) && height < 36.0 || speed > 40.0 && blockInWay < 72.0 ? -65536 : color, false);
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)FormatTool.format0D(vehicle.m_20186_())), screenWidth / 2 + 104, screenHeight / 2, color, false);
                RenderHelper.blit(poseStack, SPEED_FRAME, (float)screenWidth / 2.0f - 144.0f, (float)screenHeight / 2.0f - 6.0f, 0.0f, 0.0f, 50.0f, 18.0f, 50.0f, 18.0f, color);
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)FormatTool.format0D(speed, "km/h")), screenWidth / 2 - 140, screenHeight / 2, color, false);
                if (vehicle.hasDecoy()) {
                    if (vehicle.getDecoyState().equals("READY")) {
                        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.flare.ready").m_7220_((Component)Component.m_237113_((String)(" [" + ModKeyMappings.RELEASE_DECOY.getKey().m_84875_().getString() + "]"))), screenWidth / 2 - 160, screenHeight / 2 - 50, color, false);
                    } else {
                        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.flare.reloading"), screenWidth / 2 - 160, screenHeight / 2 - 50, 0xFF0000, false);
                    }
                }
                Component component = vehicle.firstPersonAmmoComponent(data, player);
                int heat = vehicle.getWeaponHeat((LivingEntity)player);
                guiGraphics.m_280614_(mc.f_91062_, component, screenWidth / 2 - 160, screenHeight / 2 - 59, MathTool.getGradientColor(color, 0xFF0000, heat, 2), false);
                VehicleMainWeaponHudOverlay.renderEnergyInfo(vehicle, guiGraphics, screenWidth, screenHeight, mc.f_91062_);
                RenderHelper.blit(poseStack, CROSSHAIR_IND, x - 8.0f, y - 8.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, color);
                VehicleHudOverlay.renderKillIndicatorDynamic(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
            } else if (VectorUtil.canSee(pos)) {
                poseStack.m_85836_();
                poseStack.m_272245_(Axis.f_252403_.m_252977_(vehicle.getRoll(partialTick)), x, y, 0.0f);
                RenderHelper.preciseBlit(guiGraphics, CROSSHAIR_3P, x - 8.0f, y - 8.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f);
                VehicleHudOverlay.renderKillIndicatorDynamic(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                poseStack.m_85836_();
                poseStack.m_252880_(x, y, 0.0f);
                poseStack.m_85841_(0.75f, 0.75f, 1.0f);
                VehicleMainWeaponHudOverlay.renderWeaponInfoThird(guiGraphics, vehicle, player, data, mc.f_91062_);
                if (vehicle.hasDecoy()) {
                    if (vehicle.getDecoyState().equals("READY")) {
                        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.flare.ready").m_7220_((Component)Component.m_237113_((String)(" [" + ModKeyMappings.RELEASE_DECOY.getKey().m_84875_().getString() + "]"))), 30, 1, -1, false);
                    } else {
                        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.flare.reloading"), 30, 1, 0xFF0000, false);
                    }
                }
                poseStack.m_85849_();
                poseStack.m_85849_();
            }
            if (lerpVy < -16.0f) {
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)"SINK RATE\uff0cPULL UP!"), screenWidth / 2 - 53, screenHeight / 2 + 24, -65536, false);
                if (player.f_19797_ % 30 == 0) {
                    player.m_9236_().m_245747_(player.m_20097_(), (SoundEvent)ModSounds.PULL_UP.get(), SoundSource.PLAYERS, 3.0f, 1.0f, false);
                }
            } else if ((lerpVy < -10.0f || lerpVy < -3.0f && speed > 100.0) && height < 36.0 || speed > 72.0 && blockInWay < 72.0) {
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)"TERRAIN TERRAIN"), screenWidth / 2 - 42, screenHeight / 2 + 24, -65536, false);
                if (player.f_19797_ % 30 == 0) {
                    player.m_9236_().m_245747_(player.m_20097_(), (SoundEvent)ModSounds.TERRAIN.get(), SoundSource.PLAYERS, 3.0f, 1.0f, false);
                }
            }
            poseStack.m_85849_();
        }
    }
}

