/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.weapon.AircraftHud;
import com.atsuishio.superbwarfare.client.overlay.weapon.ArtilleryHud;
import com.atsuishio.superbwarfare.client.overlay.weapon.HelicopterHud;
import com.atsuishio.superbwarfare.client.overlay.weapon.LandVehicleHud;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.SeekWeaponInfo;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.MathTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class VehicleMainWeaponHudOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_vehicle_main_weapon_hud";
    public static final String EMPTY = "@Empty";
    private static float lerpLock = 1.0f;
    public static boolean lock = false;
    private static final ResourceLocation FRAME_GREEN = Mod.loc("textures/overlay/frame/frame_green.png");
    private static final ResourceLocation FRAME_TARGET = Mod.loc("textures/overlay/frame/frame_target.png");
    private static final ResourceLocation FRAME_TARGET_TRIANGLE = Mod.loc("textures/overlay/frame/frame_target_triangle.png");
    private static final ResourceLocation FRAME_LOCK = Mod.loc("textures/overlay/frame/frame_lock.png");
    private static final ResourceLocation IND_1 = Mod.loc("textures/overlay/vehicle/aircraft/locking_ind1.png");
    private static final ResourceLocation IND_2 = Mod.loc("textures/overlay/vehicle/aircraft/locking_ind2.png");
    private static final ResourceLocation IND_3 = Mod.loc("textures/overlay/vehicle/aircraft/locking_ind3.png");
    private static final ResourceLocation IND_4 = Mod.loc("textures/overlay/vehicle/aircraft/locking_ind4.png");
    private static final ResourceLocation SHOOT_INDICATOR = Mod.loc("textures/overlay/frame/frame_diamond.png");
    private static final ResourceLocation BLOCK = Mod.loc("textures/overlay/misc/block.png");

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        LocalPlayer player = gui.getMinecraft().f_91074_;
        if (player == null) {
            return;
        }
        Entity entity = player.m_20202_();
        if (!(entity instanceof VehicleEntity)) {
            return;
        }
        VehicleEntity vehicle = (VehicleEntity)entity;
        if (ClientEventHandler.isEditing) {
            return;
        }
        String type = vehicle.computed().hudType;
        if (type.equals(EMPTY)) {
            return;
        }
        GunData gunData = vehicle.getGunData((Entity)player);
        if (gunData == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (type) {
            case "@Land": {
                LandVehicleHud.render(vehicle, (Player)player, gui, guiGraphics, partialTick, screenWidth, screenHeight);
                break;
            }
            case "@Helicopter": {
                HelicopterHud.render(vehicle, (Player)player, gui, guiGraphics, partialTick, screenWidth, screenHeight);
                break;
            }
            case "@Artillery": {
                ArtilleryHud.render(vehicle, (Player)player, gui, guiGraphics, partialTick, screenWidth, screenHeight);
                break;
            }
            case "@Aircraft": {
                AircraftHud.render(vehicle, (Player)player, gui, guiGraphics, partialTick, screenWidth, screenHeight);
            }
        }
        SeekWeaponInfo seekInfo = gunData.compute().seekWeaponInfo;
        if (seekInfo == null) {
            poseStack.m_85849_();
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        int seekTime = seekInfo.seekTime;
        if (seekInfo.onlyLockEntity) {
            Entity targetEntity = ClientEventHandler.lockingEntityVehicle;
            Entity nearestEntity = ClientEventHandler.nearestEntityVehicle;
            Vec3 seekVec = vehicle.getSeekVec((Entity)player, partialTick);
            List<Entity> entities = new SeekTool.Builder(vehicle).withinRange(seekInfo.seekRange).withinAngle(cameraPos, seekVec, seekInfo.seekAngle).baseFilter().heightRange(seekInfo.minTargetHeight, seekInfo.maxTargetHeight).sizeBiggerThan(seekInfo.minTargetSize).smokeFilter().noVehicle().noClip().notFriendly().build();
            Entity decoy = TraceTool.findLookDecoy((Player)player, cameraPos, seekVec, seekInfo.seekRange);
            if (decoy != null && decoy.m_6095_().m_204039_(ModTags.EntityTypes.DECOY)) {
                return;
            }
            for (Entity e : entities) {
                Vec3 pos3;
                if (e.m_6095_().m_204039_(ModTags.EntityTypes.DECOY) || !VectorUtil.canSee(pos3 = VectorTool.lerpGetEntityBoundingBoxCenter(e, partialTick)) || seekInfo.onlyLockBlock) continue;
                Vec3 point = VectorUtil.worldToScreen(pos3);
                boolean lockOn = ClientEventHandler.lockOnVehicle && targetEntity != null && e == targetEntity;
                boolean nearest = e == (ClientEventHandler.seekingEntityVehicle == null ? nearestEntity : ClientEventHandler.seekingEntityVehicle);
                poseStack.m_85836_();
                float x = (float)point.f_82479_;
                float y = (float)point.f_82480_;
                if (lockOn) {
                    lock = true;
                    RenderHelper.blit(poseStack, FRAME_LOCK, x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                    nearestEntity = targetEntity;
                    if (seekInfo.calculateTrajectory) {
                        Vec3 shootVector = RangeTool.calculateFiringSolution(vehicle.getShootPos((Entity)player, partialTick), VectorTool.lerpGetEntityBoundingBoxCenter(targetEntity, partialTick), targetEntity.m_20184_().m_82490_(1.25), vehicle.getProjectileVelocity((Entity)player), vehicle.getProjectileGravity((Entity)player)).m_82541_();
                        Vec3 shootPos = vehicle.getShootPos((Entity)player, partialTick).m_82549_(shootVector.m_82490_(vehicle.getShootPos((Entity)player, partialTick).m_82554_(VectorTool.lerpGetEntityBoundingBoxCenter(targetEntity, partialTick))));
                        Vec3 point0 = VectorUtil.worldToScreen(shootPos);
                        if (VectorUtil.canSee(shootPos)) {
                            poseStack.m_85836_();
                            float x0 = (float)point0.f_82479_;
                            float y0 = (float)point0.f_82480_;
                            Vec3 targetHudPos = new Vec3((double)x, (double)y, 0.0);
                            Vec3 shootHudPos = new Vec3((double)x0, (double)y0, 0.0);
                            RenderHelper.blit(poseStack, SHOOT_INDICATOR, x0 - 12.0f, y0 - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                            poseStack.m_85849_();
                            double dis = targetHudPos.m_82554_(shootHudPos);
                            for (double i = 3.0; i < dis - 3.0; i += 3.0) {
                                Vec3 toVec = targetHudPos.m_82505_(shootHudPos).m_82541_();
                                Vec3 p0 = targetHudPos.m_82549_(toVec.m_82490_(i));
                                RenderHelper.blit(poseStack, BLOCK, (float)(p0.f_82479_ - 0.5), (float)(p0.f_82480_ - 0.5), 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                            }
                        }
                    }
                } else if (nearest && !lock) {
                    lerpLock = Mth.m_14179_((float)partialTick, (float)lerpLock, (float)ClientEventHandler.seekingTimeVehicle);
                    float lockTime = Mth.m_14036_((float)(((float)seekTime - lerpLock) * (20.0f / (float)seekTime)), (float)0.0f, (float)20.0f);
                    if (ClientEventHandler.seekingTimeVehicle > 0) {
                        RenderHelper.blit(poseStack, IND_1, x - 12.0f, y - 12.0f - lockTime, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                        RenderHelper.blit(poseStack, IND_2, x - 12.0f, y - 12.0f + lockTime, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                        RenderHelper.blit(poseStack, IND_3, x - 12.0f - lockTime, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                        RenderHelper.blit(poseStack, IND_4, x - 12.0f + lockTime, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                    }
                    if (ClientEventHandler.seekingTimeVehicle == 0) {
                        poseStack.m_85836_();
                        poseStack.m_252880_(x, y, 0.0f);
                        String string = "[" + ModKeyMappings.VEHICLE_SEEK.getKey().m_84875_().getString() + "]";
                        int width = Minecraft.m_91087_().f_91062_.m_92895_(string);
                        guiGraphics.m_280056_(mc.f_91062_, string, -width / 2, 10, 16760191, false);
                        poseStack.m_85849_();
                    }
                    RenderHelper.blit(poseStack, ClientEventHandler.seekingTimeVehicle > 0 ? FRAME_TARGET : FRAME_TARGET_TRIANGLE, x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                } else {
                    RenderHelper.blit(poseStack, FRAME_GREEN, x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                }
                poseStack.m_85849_();
            }
        } else {
            Vec3 pos = ClientEventHandler.lockingPosVehicle;
            if (pos != null) {
                boolean lockOn = ClientEventHandler.lockOnVehicle;
                Vec3 point = VectorUtil.worldToScreen(pos);
                if (VectorUtil.canSee(pos)) {
                    poseStack.m_85836_();
                    float x = (float)point.f_82479_;
                    float y = (float)point.f_82480_;
                    lerpLock = Mth.m_14179_((float)partialTick, (float)lerpLock, (float)ClientEventHandler.seekingTimeVehicle);
                    float lockTime = Mth.m_14036_((float)(((float)seekTime - lerpLock) * (20.0f / (float)seekTime)), (float)0.0f, (float)20.0f);
                    if (ClientEventHandler.seekingTimeVehicle > 0 && !lockOn) {
                        RenderHelper.blit(poseStack, IND_1, x - 12.0f, y - 12.0f - lockTime, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                        RenderHelper.blit(poseStack, IND_2, x - 12.0f, y - 12.0f + lockTime, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                        RenderHelper.blit(poseStack, IND_3, x - 12.0f - lockTime, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                        RenderHelper.blit(poseStack, IND_4, x - 12.0f + lockTime, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                    }
                    if (ClientEventHandler.seekingTimeVehicle == 0) {
                        poseStack.m_85836_();
                        poseStack.m_252880_(x, y, 0.0f);
                        String string = "[" + ModKeyMappings.VEHICLE_SEEK.getKey().m_84875_().getString() + "]";
                        int width = Minecraft.m_91087_().f_91062_.m_92895_(string);
                        guiGraphics.m_280056_(mc.f_91062_, string, -width / 2, 10, 16760191, false);
                        poseStack.m_85849_();
                    }
                    RenderHelper.blit(poseStack, lockOn ? FRAME_LOCK : FRAME_TARGET, x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f, 1.0f);
                    poseStack.m_85849_();
                }
            }
        }
        poseStack.m_85849_();
    }

    public static void renderEnergyInfo(VehicleEntity vehicle, GuiGraphics guiGraphics, int screenWidth, int screenHeight, Font font) {
        if (!vehicle.hasEnergyStorage()) {
            return;
        }
        if ((double)vehicle.getEnergy() < 0.02 * (double)vehicle.getMaxEnergy()) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)"NO POWER!"), screenWidth / 2 - 144, screenHeight / 2 + 14, -65536, false);
        } else if ((double)vehicle.getEnergy() < 0.2 * (double)vehicle.getMaxEnergy()) {
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)"LOW POWER"), screenWidth / 2 - 144, screenHeight / 2 + 14, 16739072, false);
        }
    }

    public static void renderWeaponInfoFirst(GuiGraphics guiGraphics, VehicleEntity vehicle, Player player, GunData data, Font font, int screenWidth, int screenHeight, int color) {
        int heat = vehicle.getWeaponHeat((LivingEntity)player);
        Component component = vehicle.firstPersonAmmoComponent(data, player);
        guiGraphics.m_280614_(font, component, (screenWidth - font.m_92852_((FormattedText)component)) / 2, screenHeight - 65, MathTool.getGradientColor(color, 0xFF0000, heat, 2), false);
    }

    public static void renderWeaponInfoThird(GuiGraphics guiGraphics, VehicleEntity vehicle, Player player, GunData data, Font font) {
        if (!vehicle.hasWeapon()) {
            return;
        }
        float heat = (float)vehicle.getWeaponHeat((LivingEntity)player) / 100.0f;
        Component component = vehicle.thirdPersonAmmoComponent(data, player);
        guiGraphics.m_280614_(font, component, 30, -9, Mth.m_14169_((float)0.0f, (float)heat, (float)1.0f), false);
    }

    public static Vec3 getAroundPos(Vec3 direction, Vec3 center, double radius) {
        direction = direction.m_82541_();
        Vec3 randomPerp = VehicleMainWeaponHudOverlay.getRandomPerpendicular(direction);
        Vec3 u = randomPerp.m_82541_();
        Vec3 v = direction.m_82537_(u).m_82541_();
        double theta = Math.PI * 2;
        double xOffset = radius * (Math.cos(theta) * u.f_82479_ + Math.sin(theta) * v.f_82479_);
        double yOffset = radius * (Math.cos(theta) * u.f_82480_ + Math.sin(theta) * v.f_82480_);
        double zOffset = radius * (Math.cos(theta) * u.f_82481_ + Math.sin(theta) * v.f_82481_);
        return center.m_82520_(xOffset, yOffset, zOffset);
    }

    private static Vec3 getRandomPerpendicular(Vec3 dir) {
        Vec3 candidate1 = new Vec3(dir.f_82480_, -dir.f_82479_, 0.0);
        if (candidate1.m_82556_() > 1.0E-4) {
            return candidate1;
        }
        return new Vec3(0.0, dir.f_82481_, -dir.f_82480_);
    }
}

