/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.VehicleHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.VehicleMainWeaponHudOverlay;
import com.atsuishio.superbwarfare.client.overlay.weapon.LandVehicleHud;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.vehicle.subdata.VehicleType;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.ResourceOnceLogger;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.joml.Math;

@OnlyIn(value=Dist.CLIENT)
public class VehicleCrosshairOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_vehicle_crosshair";
    private static final ResourceOnceLogger LOGGER = new ResourceOnceLogger();
    public static final Map<String, ResourceLocation> CROSSHAIR_MAP = Map.ofEntries(Map.entry("@VehicleUsApc", Mod.loc("textures/overlay/vehicle/crosshair/us_apc.png")), Map.entry("@VehicleUsTank", Mod.loc("textures/overlay/vehicle/crosshair/us_tank.png")), Map.entry("@VehicleRuApc", Mod.loc("textures/overlay/vehicle/crosshair/ru_apc.png")), Map.entry("@VehicleCommonMissile", Mod.loc("textures/overlay/vehicle/crosshair/common_missile.png")), Map.entry("@VehicleCommonSeekMissile", Mod.loc("textures/overlay/vehicle/crosshair/common_seek_missile.png")), Map.entry("@VehicleCommonGun", Mod.loc("textures/overlay/vehicle/crosshair/common_gun.png")), Map.entry("@VehicleCommonGunDynamic", Mod.loc("textures/overlay/vehicle/crosshair/common_gun.png")), Map.entry("@VehicleCommonCannon", Mod.loc("textures/overlay/vehicle/crosshair/common_cannon.png")), Map.entry("@VehicleCommonCross", Mod.loc("textures/overlay/vehicle/crosshair/common_cross.png")), Map.entry("@VehicleDynamicCross", Mod.loc("textures/overlay/vehicle/crosshair/common_dynamic_cross.png")), Map.entry("@VehicleFixedPoint", Mod.loc("textures/overlay/vehicle/crosshair/common_fixed_point.png")), Map.entry("@VehicleCnHpjZooming", Mod.loc("textures/overlay/vehicle/crosshair/cn_hpj_zooming.png")), Map.entry("@VehicleCommonCannonZooming", Mod.loc("textures/overlay/vehicle/crosshair/common_cannon_zooming.png")), Map.entry("@VehicleLaserCannon", Mod.loc("textures/overlay/vehicle/crosshair/laser_cannon.png")), Map.entry("@AirCraftCommon", Mod.loc("textures/overlay/vehicle/aircraft/common.png")));
    private static final ResourceLocation CROSSHAIR_THIRD_CAMERA = Mod.loc("textures/overlay/vehicle/crosshair/third_camera.png");
    private static float scopeScale = 1.0f;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (player == null || player.m_5833_()) {
            VehicleCrosshairOverlay.resetScale();
            return;
        }
        Entity entity = player.m_20202_();
        if (!(entity instanceof VehicleEntity)) {
            VehicleCrosshairOverlay.resetScale();
            return;
        }
        VehicleEntity vehicle = (VehicleEntity)entity;
        int index = vehicle.getSeatIndex((Entity)player);
        GunData data = vehicle.getGunData(index);
        if (data == null) {
            VehicleCrosshairOverlay.resetScale();
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        String crosshairPath = data.compute().crosshair;
        if (crosshairPath.equals("@Empty")) {
            VehicleCrosshairOverlay.resetScale();
            return;
        }
        if (ClientEventHandler.zoomVehicle && !data.compute().crosshairZooming.equals("@Empty")) {
            crosshairPath = data.compute().crosshairZooming;
        }
        int color = data.compute().crosshairColor.get();
        poseStack.m_85836_();
        float recoil = Mth.m_14179_((float)partialTick, (float)((float)vehicle.recoilShakeO), (float)((float)vehicle.getRecoilShake()));
        poseStack.m_252880_(LandVehicleHud.lerpRecoil * 6.0f + (float)screenWidth * 0.025f * recoil, recoil * 3.0f + (float)screenHeight * 0.025f * recoil, 0.0f);
        poseStack.m_85841_(1.0f - recoil * 0.05f, 1.0f - recoil * 0.05f, 1.0f);
        poseStack.m_272245_(Axis.f_252403_.m_252977_(-0.3f * ClientEventHandler.cameraRoll + 4.0f * LandVehicleHud.lerpRecoil), (float)screenWidth / 2.0f, (float)screenHeight / 2.0f, 0.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float scale = scopeScale = Mth.m_14179_((float)partialTick, (float)scopeScale, (float)1.0f);
        Vec3 shootPos = vehicle.getShootPosForHud((Entity)player, partialTick);
        BlockHitResult result = player.m_9236_().m_45547_(new ClipContext(shootPos, shootPos.m_82549_(vehicle.getShootDirectionForHud((Entity)player, partialTick).m_82490_(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 hitPos = result.m_82450_();
        double dis = shootPos.m_82554_(hitPos);
        Entity lookingEntity = vehicle.getPlayerLookAtEntityOnVehicle((Entity)player, 512.0, partialTick);
        if (lookingEntity != null) {
            dis = shootPos.m_82554_(lookingEntity.m_20182_());
        }
        Vec3 pos = shootPos.m_82549_(vehicle.getShootDirectionForHud((Entity)player, partialTick).m_82490_(dis));
        Vec3 p = VectorUtil.worldToScreen(pos);
        if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON || ClientEventHandler.zoomVehicle) {
            poseStack.m_85836_();
            ResourceLocation texture = crosshairPath.startsWith("@") ? CROSSHAIR_MAP.get(crosshairPath) : ResourceLocation.m_135820_((String)crosshairPath);
            if (texture == null) {
                String finalCrosshairPath = crosshairPath;
                if (!finalCrosshairPath.equals("@Custom")) {
                    LOGGER.log(crosshairPath, logger -> logger.error("Failed to load crosshair texture for {}", (Object)finalCrosshairPath));
                }
            } else {
                float minWH = Math.min((int)screenWidth, (int)screenHeight);
                float scaledMinWH = Mth.m_14143_((float)(minWH * scale));
                float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
                float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
                float x = (float)p.f_82479_;
                float y = (float)p.f_82480_;
                if (crosshairPath.equals("@VehicleDynamicCross") && VectorUtil.canSee(pos)) {
                    RenderHelper.blit(poseStack, texture, x - scaledMinWH / 2.0f, y - scaledMinWH / 2.0f, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH, color);
                    VehicleHudOverlay.renderKillIndicatorDynamic(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                    ResourceLocation fixedTexture = CROSSHAIR_MAP.get("@VehicleFixedPoint");
                    RenderHelper.blit(poseStack, fixedTexture, centerW, centerH, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH, color);
                } else if ((crosshairPath.equals("@AirCraftCommon") || crosshairPath.equals("@VehicleLaserCannon") || crosshairPath.equals("@VehicleCommonGunDynamic")) && VectorUtil.canSee(pos)) {
                    RenderHelper.blit(poseStack, texture, x - scaledMinWH / 2.0f, y - scaledMinWH / 2.0f, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH, color);
                    VehicleHudOverlay.renderKillIndicatorDynamic(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                } else if (crosshairPath.equals("@VehicleCnHpjZooming")) {
                    ResourceLocation dynamicTexture = CROSSHAIR_MAP.get("@VehicleDynamicCross");
                    RenderHelper.blit(poseStack, dynamicTexture, x - scaledMinWH / 2.0f, y - scaledMinWH / 2.0f, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH, color);
                    VehicleHudOverlay.renderKillIndicatorDynamic(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
                } else if (crosshairPath.equals("@VehicleCommonCannonZooming")) {
                    float fovAdjust = 60.0f / (float)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue();
                    float f = Math.min((int)screenWidth, (int)screenHeight);
                    float f1 = Math.min((float)((float)screenWidth / f), (float)((float)screenHeight / f)) * fovAdjust;
                    int i = Mth.m_14143_((float)(f * f1));
                    int j = Mth.m_14143_((float)(f * f1));
                    int k = (screenWidth - i) / 2;
                    int l = (screenHeight - j) / 2;
                    RenderHelper.preciseBlit(guiGraphics, texture, k, l, 0.0f, 0.0f, i, j, i, j);
                    VehicleHudOverlay.renderKillIndicator(guiGraphics, screenWidth, screenHeight);
                } else if (crosshairPath.equals("@VehicleCommonSeekMissile") && data.compute().seekWeaponInfo != null && data.compute().seekWeaponInfo.onlyLockBlock) {
                    Vec3 vec3 = ClientEventHandler.seekingPosVehicle;
                    if (ClientEventHandler.seekingTimeVehicle > 0) {
                        vec3 = ClientEventHandler.lockingPosVehicle;
                    }
                    if (vec3 != null) {
                        String string = "[ " + FormatTool.format0D(vec3.f_82479_) + ", " + FormatTool.format0D(vec3.f_82480_) + ", " + FormatTool.format0D(vec3.f_82481_) + " ]";
                        int width = Minecraft.m_91087_().f_91062_.m_92895_(string);
                        RenderHelper.blit(poseStack, texture, centerW, centerH, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH, color);
                        guiGraphics.drawString(Minecraft.m_91087_().f_91062_, string, (float)screenWidth / 2.0f - (float)width / 2.0f, (float)screenHeight - 73.0f, color, false);
                    }
                } else {
                    RenderHelper.blit(poseStack, texture, centerW, centerH, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH, color);
                    VehicleHudOverlay.renderKillIndicator(guiGraphics, screenWidth, screenHeight);
                }
            }
            poseStack.m_85849_();
        } else if (Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.THIRD_PERSON_BACK && !ClientEventHandler.zoomVehicle && VectorUtil.canSee(pos) && (vehicle.getVehicleType() != VehicleType.AIRPLANE && vehicle.getVehicleType() != VehicleType.HELICOPTER || player != vehicle.m_146895_())) {
            float x = (float)p.f_82479_;
            float y = (float)p.f_82480_;
            RenderHelper.preciseBlit(guiGraphics, CROSSHAIR_THIRD_CAMERA, x - 12.0f, y - 12.0f, 0.0f, 0.0f, 24.0f, 24.0f, 24.0f, 24.0f);
            VehicleHudOverlay.renderKillIndicatorDynamic(guiGraphics, x - 7.5f + (float)(2.0 * (Math.random() - 0.5)), y - 7.5f + (float)(2.0 * (Math.random() - 0.5)));
            poseStack.m_85836_();
            poseStack.m_252880_(x, y, 0.0f);
            poseStack.m_85841_(0.75f, 0.75f, 1.0f);
            VehicleMainWeaponHudOverlay.renderWeaponInfoThird(guiGraphics, vehicle, (Player)player, data, mc.f_91062_);
            if (player == vehicle.m_146895_() && vehicle.hasDecoy()) {
                if (vehicle.getDecoyState().equals("READY")) {
                    guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.smoke.ready").m_7220_((Component)Component.m_237113_((String)(" [" + ModKeyMappings.RELEASE_DECOY.getKey().m_84875_().getString() + "]"))), 30, 1, -1, false);
                } else {
                    guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.smoke.reloading"), 30, 1, 0xFF0000, false);
                }
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private static void resetScale() {
        scopeScale = 0.7f;
    }
}

