/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.client.overlay.IFFOverlay;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.tools.VectorUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class SpyglassRangeOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_spyglass_range";
    private static final ResourceLocation INDICATOR = Mod.loc("textures/overlay/spyglass/indicator.png");
    private static final ResourceLocation SPYGLASS = Mod.loc("textures/overlay/spyglass/spyglass.png");
    private static float scopeScale = 1.0f;
    private static float lerpHoldArtilleryIndicator;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = gui.getMinecraft();
        PoseStack poseStack = guiGraphics.m_280168_();
        LocalPlayer player = gui.getMinecraft().f_91074_;
        if (player == null) {
            return;
        }
        if ((player.m_6117_() && player.m_21211_().m_150930_((Item)ModItems.ARTILLERY_INDICATOR.get()) || player.m_150108_()) && mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            if (player.m_21211_().m_150930_((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                ItemStack stack = player.m_21211_();
                poseStack.m_85836_();
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float deltaFrame = Minecraft.m_91087_().m_91297_();
                scopeScale = (float)Mth.m_14139_((double)(0.5f * deltaFrame), (double)scopeScale, (double)((double)1.35f + (double)0.2f * ClientEventHandler.firePos));
                float f = Math.min(screenWidth, screenHeight);
                float f1 = Math.min((float)screenWidth / f, (float)screenHeight / f) * scopeScale;
                float i = Mth.m_14143_((float)(f * f1));
                float j = Mth.m_14143_((float)(f * f1));
                float k = ((float)screenWidth - i) / 2.0f;
                float l = ((float)screenHeight - j) / 2.0f;
                float w = i * 21.0f / 9.0f;
                RenderHelper.preciseBlit(guiGraphics, SPYGLASS, k - 2.0f * w / 7.0f, l, 0.0f, 0.0f, w, j, w, j);
                double targetX = stack.m_41784_().m_128459_("TargetX");
                double targetY = stack.m_41784_().m_128459_("TargetY");
                double targetZ = stack.m_41784_().m_128459_("TargetZ");
                Vec3 pos = new Vec3(targetX, targetY, targetZ);
                Vec3 point = VectorUtil.worldToScreen(pos);
                if (VectorUtil.canSee(pos)) {
                    float x = (float)point.f_82479_;
                    float y = (float)point.f_82480_;
                    RenderHelper.preciseBlit(guiGraphics, INDICATOR, Mth.m_14036_((float)(x - 6.0f), (float)0.0f, (float)(screenWidth - 12)), Mth.m_14036_((float)(y - 6.0f), (float)0.0f, (float)(screenHeight - 12)), 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
                }
                ListTag tags = stack.m_41784_().m_128437_("Cannons", 10);
                for (int m = 0; m < tags.size(); ++m) {
                    CompoundTag tag = tags.m_128728_(m);
                    Entity entity = EntityFindUtil.findEntity(player.m_9236_(), tag.m_128461_("UUID"));
                    if (entity == null) continue;
                    Vec3 posF = VectorTool.lerpGetEntityBoundingBoxCenter(entity, partialTick);
                    Vec3 pointF = VectorUtil.worldToScreen(posF);
                    if (!VectorUtil.canSee(posF)) continue;
                    float xf = (float)pointF.f_82479_;
                    float yf = (float)pointF.f_82480_;
                    RenderHelper.preciseBlit(guiGraphics, IFFOverlay.FRIENDLY_ARTILLERY, Mth.m_14036_((float)(xf - 6.0f), (float)0.0f, (float)(screenWidth - 12)), Mth.m_14036_((float)(yf - 6.0f), (float)0.0f, (float)(screenHeight - 12)), 0.0f, 0.0f, 12.0f, 12.0f, 12.0f, 12.0f);
                }
                poseStack.m_85849_();
                lerpHoldArtilleryIndicator = Mth.m_14179_((float)partialTick, (float)lerpHoldArtilleryIndicator, (float)(0.05f * (float)ClientEventHandler.holdArtilleryIndicator));
                if (lerpHoldArtilleryIndicator > 0.0f) {
                    float alpha = Mth.m_14036_((float)(lerpHoldArtilleryIndicator * 20.0f), (float)0.0f, (float)5.0f) * 0.2f;
                    RenderHelper.renderCircularRing(guiGraphics, (float)screenWidth / 2.0f, (float)screenHeight / 2.0f, 0.07f, 0.052f, new float[]{0.0f, 0.0f, 0.0f, 0.4f * alpha}, new float[]{1.0f, 1.0f, 1.0f, 0.8f * alpha}, lerpHoldArtilleryIndicator, true);
                }
            }
            boolean lookAtEntity = false;
            BlockHitResult result = player.m_9236_().m_45547_(new ClipContext(player.m_146892_(), player.m_146892_().m_82549_(player.m_20252_(1.0f).m_82490_(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            Vec3 hitPos = result.m_82450_();
            double blockRange = player.m_20299_(1.0f).m_82554_(hitPos);
            double entityRange = 0.0;
            Entity lookingEntity = TraceTool.findLookingEntity((Entity)player, 520.0);
            if (lookingEntity instanceof VehicleEntity) {
                return;
            }
            if (lookingEntity != null) {
                lookAtEntity = true;
                entityRange = player.m_20270_(lookingEntity);
            }
            if (lookAtEntity) {
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.drone.range").m_7220_((Component)Component.m_237113_((String)(FormatTool.format1D(entityRange, "M ") + lookingEntity.m_5446_().getString()))), screenWidth / 2 + 12, screenHeight / 2 - 28, -1, false);
            } else if (blockRange > 500.0) {
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.drone.range").m_7220_((Component)Component.m_237113_((String)"---M")), screenWidth / 2 + 12, screenHeight / 2 - 28, -1, false);
            } else {
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"tips.superbwarfare.drone.range").m_7220_((Component)Component.m_237113_((String)FormatTool.format1D(blockRange, "M"))), screenWidth / 2 + 12, screenHeight / 2 - 28, -1, false);
            }
        } else {
            scopeScale = 1.0f;
        }
    }
}

