/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.client.overlay;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.client.DisplayConfig;
import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.init.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class ArmorPlateOverlay
implements IGuiOverlay {
    public static final String ID = "superbwarfare_armor_plate";
    private static final ResourceLocation ICON = Mod.loc("textures/overlay/armor_plate/icon.png");
    private static final ResourceLocation BAR_1 = Mod.loc("textures/overlay/armor_plate/bar_1.png");
    private static final ResourceLocation BAR_2 = Mod.loc("textures/overlay/armor_plate/bar_2.png");
    private static final ResourceLocation BAR_3 = Mod.loc("textures/overlay/armor_plate/bar_3.png");
    private static final ResourceLocation BAR_FRAME_1 = Mod.loc("textures/overlay/armor_plate/bar_frame_1.png");
    private static final ResourceLocation BAR_FRAME_2 = Mod.loc("textures/overlay/armor_plate/bar_frame_2.png");
    private static final ResourceLocation BAR_FRAME_3 = Mod.loc("textures/overlay/armor_plate/bar_frame_3.png");

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (!((Boolean)DisplayConfig.ARMOR_PLATE_HUD.get()).booleanValue()) {
            return;
        }
        Minecraft mc = gui.getMinecraft();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
        if (stack == ItemStack.f_41583_) {
            return;
        }
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("ArmorPlate")) {
            return;
        }
        int armorLevel = (Integer)MiscConfig.DEFAULT_ARMOR_LEVEL.get();
        if (stack.m_204117_(ModTags.Items.MILITARY_ARMOR)) {
            armorLevel = (Integer)MiscConfig.MILITARY_ARMOR_LEVEL.get();
        } else if (stack.m_204117_(ModTags.Items.MILITARY_ARMOR_HEAVY)) {
            armorLevel = (Integer)MiscConfig.HEAVY_MILITARY_ARMOR_LEVEL.get();
        }
        int max = armorLevel * (Integer)MiscConfig.ARMOR_POINT_PER_LEVEL.get();
        double amount = 60.0 * (stack.m_41783_().m_128459_("ArmorPlate") / (double)max);
        ResourceLocation texture = switch (armorLevel) {
            case 2 -> BAR_2;
            case 3 -> BAR_3;
            default -> BAR_1;
        };
        ResourceLocation frame = switch (armorLevel) {
            case 2 -> BAR_FRAME_2;
            case 3 -> BAR_FRAME_3;
            default -> BAR_FRAME_1;
        };
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280163_(ICON, 10, screenHeight - 13, 0.0f, 0.0f, 8, 8, 8, 8);
        guiGraphics.m_280163_(frame, 20, screenHeight - 12, 0.0f, 0.0f, 60, 6, 60, 6);
        guiGraphics.m_280163_(texture, 20, screenHeight - 12, 0.0f, 0.0f, (int)amount, 6, 60, 6);
        guiGraphics.m_280168_().m_85849_();
    }
}

