/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AircraftCatapultBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final BooleanProperty UPDATING = BooleanProperty.m_61465_((String)"updating");

    public AircraftCatapultBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56743_).m_60978_(3.0f).m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)UPDATING, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState pOldState, boolean pMovedByPiston) {
        if (level instanceof ServerLevel) {
            int receivedPower = level.m_277086_(pos);
            int maxNeighborPower = this.getFacingPower(level, pos, state);
            int newPower = Math.max(receivedPower, maxNeighborPower);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(newPower)), 3);
        }
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{POWER}).m_61104_(new Property[]{UPDATING});
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (!pLevel.f_46443_ && !((Boolean)pState.m_61143_((Property)UPDATING)).booleanValue()) {
            pLevel.m_186460_(pPos, (Block)this, 1);
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource pRandom) {
        this.updateSignal(state, level, pos);
    }

    private void updateSignal(BlockState state, ServerLevel level, BlockPos pos) {
        BlockState newState;
        if (((Boolean)state.m_61143_((Property)UPDATING)).booleanValue()) {
            return;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)UPDATING, (Comparable)Boolean.valueOf(true)), 2);
        int receivedPower = level.m_277086_(pos);
        int maxNeighborPower = this.getFacingPower((Level)level, pos, state);
        int newPower = Math.max(receivedPower, maxNeighborPower);
        if (newPower != (Integer)state.m_61143_((Property)POWER)) {
            newState = level.m_8055_(pos);
            level.m_7731_(pos, (BlockState)newState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(newPower)), 3);
        }
        newState = level.m_8055_(pos);
        level.m_7731_(pos, (BlockState)newState.m_61124_((Property)UPDATING, (Comparable)Boolean.valueOf(false)), 2);
    }

    private int getFacingPower(Level level, BlockPos pos, BlockState state) {
        int max = 0;
        BlockPos relative = pos.m_121945_((Direction)state.m_61143_((Property)FACING));
        BlockState blockState = level.m_8055_(relative);
        if (blockState.m_60734_() instanceof AircraftCatapultBlock) {
            max = Math.max(max, (Integer)blockState.m_61143_((Property)POWER));
        }
        return max;
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        super.m_141947_(pLevel, pPos, pState, pEntity);
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        int power = (Integer)pState.m_61143_((Property)POWER);
        if (power == 0) {
            return;
        }
        float rate = (float)power / 400.0f;
        if (pEntity instanceof LivingEntity) {
            rate = (float)power / 50.0f;
        }
        Vec3 vec3 = new Vec3((double)direction.m_122429_(), 0.0, (double)direction.m_122431_());
        if (pEntity.m_20184_().m_82526_(vec3) < 0.2 * (double)power) {
            pEntity.m_246865_(new Vec3((double)((float)direction.m_122429_() * rate), 0.0, (double)((float)direction.m_122431_() * rate)));
        }
    }
}

