/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.template;

import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Util;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.definition.Link;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.project.JsonMap;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.Cube;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RenderedCube;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.template.TemplateArgumentType;
import com.tom.cpm.shared.template.args.TexArg;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Template {
    public static final int TEMPLATE_ID_OFFSET = 10000;
    protected Link link;
    protected Map<String, IArg> templateArgs = new HashMap<String, IArg>();
    protected Map<String, Object> data;
    protected Map<String, Object> appliedData;
    private List<Cube> cubes;
    private List<RenderedCube> rc;
    protected Map<VanillaModelPart, List<RenderedCube>> partToCubes;
    protected Map<Integer, RootModelType> rootIDmap = new HashMap<Integer, RootModelType>();
    protected TextureProvider texture;
    protected TexArg texArg;

    public Template(Link link, InputStreamReader rd, JsonMap editorData, IOHelper args, ModelDefinition def) throws IOException {
        Map rootsMap;
        this.link = link;
        this.data = (Map)MinecraftObjectHolder.gson.fromJson((Reader)rd, Object.class);
        List argsList = (List)this.data.get("args");
        if (args != null) {
            for (Map arg : argsList) {
                name = (String)arg.get("name");
                iarg = TemplateArgumentType.create((String)arg.get("type"));
                iarg.init((Map)arg.get("data"));
                iarg.load(args);
                this.templateArgs.put(name, iarg);
            }
        } else {
            for (Map arg : argsList) {
                name = (String)arg.get("name");
                iarg = TemplateArgumentType.create((String)arg.get("type"));
                iarg.init((Map)arg.get("data"));
                if (editorData.containsKey(name)) {
                    iarg.load(editorData.getMap(name).asMap());
                }
                this.templateArgs.put(name, iarg);
            }
        }
        if (this.data.containsKey("texture")) {
            this.texture = new TextureProvider(new IOHelper((String)this.data.get("texture")), def);
            this.texArg = new TexArg();
            if (args != null) {
                this.texArg.load(args);
            } else if (editorData.containsKey("__tex")) {
                this.texArg.load(editorData.getMap("__tex").asMap());
            }
            this.templateArgs.put("__tex", this.texArg);
        }
        if ((rootsMap = (Map)this.data.get("roots")) != null) {
            block2: for (Map.Entry e : rootsMap.entrySet()) {
                for (RootModelType rmt : RootModelType.VALUES) {
                    if (!rmt.getName().equals(e.getKey())) continue;
                    this.rootIDmap.put((Integer)e.getValue(), rmt);
                    continue block2;
                }
            }
        }
        this.loadModelData();
    }

    protected void loadModelData() {
        this.appliedData = Util.deepCopy(this.data);
        this.templateArgs.values().forEach(a -> a.apply(this.appliedData));
        this.cubes = new ArrayList<Cube>();
        List cubesList = (List)this.appliedData.get("cubes");
        HashMap<Integer, Map> cubeDataList = new HashMap<Integer, Map>();
        for (int i = 0; i < cubesList.size(); ++i) {
            Map map = (Map)cubesList.get(i);
            Cube cube = Cube.loadDefinitionCube(map);
            cube.id = i + 10000;
            this.cubes.add(cube);
            cubeDataList.put(cube.id, (Map)map.get("data"));
        }
        this.rc = Cube.resolveCubes(this.cubes);
        for (RenderedCube renderedCube : this.rc) {
            Map cd = (Map)cubeDataList.get(renderedCube.getId());
            renderedCube.setHidden((Boolean)cd.get("hidden"));
            renderedCube.recolor = (Boolean)cd.get("recolor");
            renderedCube.glow = (Boolean)cd.get("glow");
            this.templateArgs.values().forEach(a -> a.apply(renderedCube));
        }
    }

    protected void loadPartToCubes() {
        this.partToCubes = new HashMap<VanillaModelPart, List<RenderedCube>>();
        HashMap roots = new HashMap();
        for (int i = 0; i < PlayerModelParts.VALUES.length; ++i) {
            ArrayList l = new ArrayList();
            this.partToCubes.put(PlayerModelParts.VALUES[i], l);
            roots.put(i, l);
        }
        for (RenderedCube renderedCube : this.rc) {
            int id = renderedCube.getCube().parentId;
            List p = (List)roots.get(id);
            if (p == null) continue;
            p.add(renderedCube);
        }
        List<RenderedCube> customParts = this.partToCubes.remove(PlayerModelParts.CUSTOM_PART);
        for (Map.Entry<Integer, RootModelType> e : this.rootIDmap.entrySet()) {
            ArrayList<RenderedCube> l = new ArrayList<RenderedCube>();
            this.partToCubes.put(e.getValue(), l);
            for (RenderedCube rc : customParts) {
                if (rc.getId() != e.getKey().intValue()) continue;
                l.add(rc);
            }
        }
    }

    public Link getLink() {
        return this.link;
    }

    public IOHelper writeArgs() throws IOException {
        IOHelper h = new IOHelper();
        List argsList = (List)this.data.get("args");
        for (Map arg : argsList) {
            String name = (String)arg.get("name");
            IArg iarg = this.templateArgs.get(name);
            iarg.write(h);
        }
        if (this.texArg != null) {
            this.texArg.write(h);
        }
        return h;
    }

    public List<RenderedCube> getCubes() {
        return this.rc;
    }

    public boolean isTextureMerged() {
        return this.texArg == null ? true : this.texArg.isTextureMerged();
    }

    public void onStitch(Vec2i uv) {
        for (RenderedCube cube : this.rc) {
            cube.getCube().u += uv.x;
            cube.getCube().v += uv.y;
        }
    }

    public TextureProvider getTemplateDefaultTexture() {
        return this.texture;
    }

    public static interface IArg {
        public String getType();

        public void write(Map<String, Object> var1);

        public void write(IOHelper var1) throws IOException;

        public void load(Map<String, Object> var1);

        public void load(IOHelper var1) throws IOException;

        public void init(Map<String, Object> var1);

        public void export(Map<String, Object> var1);

        public void apply(RenderedCube var1);

        public void apply(Map<String, Object> var1);
    }
}

