/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim;

import com.tom.cpm.shared.animation.Animation;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.AnimationTrigger;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.IAnimation;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.StagedAnimation;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.parts.anim.ParameterDetails;
import com.tom.cpm.shared.parts.anim.menu.BoolParameterToggleButtonData;
import com.tom.cpm.shared.parts.anim.menu.CustomPoseGestureButtonData;
import com.tom.cpm.shared.parts.anim.menu.LegacyDropdownButtonData;
import com.tom.cpm.shared.parts.anim.menu.ValueParameterButtonData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LegacyAnimationParser {
    private final ModelDefinition def;
    private final AnimationRegistry reg;
    private Map<Gesture, Integer> layerToId = new HashMap<Gesture, Integer>();
    private Map<CustomPose, Integer> poseGid = new HashMap<CustomPose, Integer>();
    private List<Gesture> stageGestures = new ArrayList<Gesture>();
    public Map<String, List<IAnimation>> gestures = new HashMap<String, List<IAnimation>>();
    private Map<IPose, List<IAnimation>> animations = new HashMap<IPose, List<IAnimation>>();
    private Map<String, Gesture> gesturesMap = new HashMap<String, Gesture>();
    private Map<String, Pose> customPoses = new HashMap<String, Pose>();
    private Set<IPose> mustFinishPoses = new HashSet<IPose>();

    public LegacyAnimationParser(ModelDefinition def) {
        this.def = def;
        this.reg = def.getAnimations();
    }

    private void finishLoading() {
        HashMap<String, StagedAnimation> anims = new HashMap<String, StagedAnimation>();
        for (Gesture g : this.stageGestures) {
            String[] nm = g.name.split(":", 2);
            if (nm.length != 2) continue;
            IPose pose = null;
            StagedAnimation san = anims.computeIfAbsent(g.name, k -> new StagedAnimation());
            if (g.type == AnimationType.SETUP) {
                g.animation.forEach(san::addPre);
            } else if (g.type == AnimationType.FINISH) {
                g.animation.forEach(san::addPost);
            }
            switch (nm[0]) {
                case "p": {
                    for (VanillaPose p2 : VanillaPose.VALUES) {
                        if (!nm[1].equals(p2.name().toLowerCase(Locale.ROOT))) continue;
                        pose = p2;
                        break;
                    }
                }
                case "c": {
                    Pose p3;
                    if (pose == null && (p3 = this.customPoses.get(nm[1])) != null) {
                        pose = p3.pose;
                    }
                    if (pose == null) break;
                    this.animations.computeIfPresent(pose, (p, an) -> {
                        boolean mf = this.mustFinishPoses.contains(p);
                        an.forEach(a -> san.addPlay((IAnimation)a, mf));
                        if (mf) {
                            this.mustFinishPoses.remove(p);
                        }
                        return san.getAll();
                    });
                    break;
                }
                case "g": {
                    this.gesturesMap.computeIfPresent(nm[1], (k, gs) -> {
                        gs.animation.forEach(a -> san.addPlay((IAnimation)a, gs.mustFinish));
                        gs.animation = san.getAll();
                        gs.mustFinish = false;
                        return gs;
                    });
                    break;
                }
            }
        }
    }

    public void addPose(IPose pose, Animation anim, boolean finish) {
        this.animations.computeIfAbsent(pose, __ -> new ArrayList()).add(anim);
        if (finish) {
            this.mustFinishPoses.add(pose);
        }
    }

    public void addCustomPose(Pose pose, int gid) {
        this.customPoses.put(pose.pose.getName(), pose);
        if (gid != -1) {
            this.poseGid.put(pose.pose, gid);
        }
    }

    public void addGesture(Gesture g, int gid) {
        if (g.type.isStaged()) {
            this.stageGestures.add(g);
        } else {
            this.gesturesMap.put(g.name, g);
            if (g.type.isLayer()) {
                this.layerToId.put(g, this.layerToId.size() + 2);
            }
            if (gid != -1) {
                g.gid = gid;
            }
        }
    }

    public void register() {
        this.finishLoading();
        HashMap groups = new HashMap();
        Stream.concat(this.gesturesMap.values().stream(), this.customPoses.values().stream()).sorted(Comparator.comparingInt(IPoseGesture::getOrder)).map(g -> {
            if (g instanceof Gesture && ((Gesture)g).group != null) {
                String k = ((Gesture)g).group;
                Group gr = (Group)groups.get(k);
                if (gr == null) {
                    gr = new Group(k);
                    groups.put(k, gr);
                    gr.add((Gesture)g);
                    return gr;
                }
                gr.add((Gesture)g);
                return null;
            }
            return g;
        }).filter(e -> e != null).collect(Collectors.toList()).forEach(g -> g.register(this));
        byte[] sync = new byte[this.layerToId.size() + 2];
        this.layerToId.forEach((g, i) -> {
            sync[i.intValue()] = g.defVal;
        });
        this.reg.setParams(new ParameterDetails(sync, new byte[0]));
        this.animations.forEach((p, an) -> {
            AnimationTrigger t = new AnimationTrigger(this.reg, Collections.singleton(p), p instanceof VanillaPose ? (VanillaPose)p : null, (List<IAnimation>)an, true, this.mustFinishPoses.contains(p));
            this.reg.register(t);
        });
    }

    public static class Gesture
    implements IPoseGesture {
        public final AnimationType type;
        public List<IAnimation> animation;
        public boolean isLoop;
        public String name;
        public byte defVal;
        public int order;
        public boolean isProperty;
        public boolean command;
        public boolean layerCtrl;
        public boolean mustFinish;
        public String group;
        public int gid;
        public byte maxValue;
        public boolean interpolateVal;
        public boolean hidden;

        public Gesture(AnimationType type, List<IAnimation> animation, String name, boolean isLoop, int order, boolean mustFinish) {
            this.type = type;
            this.animation = animation;
            this.name = name;
            this.isLoop = isLoop;
            this.order = order;
            this.mustFinish = mustFinish;
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        @Override
        public void register(LegacyAnimationParser reg) {
            switch (this.type) {
                case GESTURE: {
                    CustomPoseGestureButtonData data = new CustomPoseGestureButtonData(false);
                    data.setName(this.name);
                    data.layerCtrl = this.layerCtrl;
                    data.command = this.command;
                    data.id = this.gid;
                    data.hidden = this.hidden;
                    if (this.layerCtrl) {
                        data.gid = this.gid;
                    }
                    if (!this.isLoop) {
                        int len = this.animation.stream().mapToInt(a -> a.getDuration(AnimationEngine.AnimationMode.PLAYER)).max().orElse(-1);
                        data.gestureTimeout = len == -1 ? -1 : (int)Math.ceil((float)len / 50.0f) + 5;
                    }
                    data.setDef(reg.def);
                    reg.reg.register(data);
                    reg.reg.register(new AnimationTrigger.GestureTrigger(reg.reg, Collections.singleton(VanillaPose.GLOBAL), this.animation, this.gid, this.gid, this.isLoop, this.mustFinish));
                    break;
                }
                case LAYER: {
                    BoolParameterToggleButtonData dt = new BoolParameterToggleButtonData();
                    dt.setName(this.name);
                    dt.command = this.command;
                    dt.isProperty = this.isProperty;
                    dt.parameter = reg.layerToId.get(this);
                    dt.mask = 1;
                    dt.hidden = this.hidden;
                    dt.setDef(reg.def);
                    reg.reg.register(dt);
                    reg.reg.register(new AnimationTrigger.LayerTrigger(reg.reg, Collections.singleton(VanillaPose.GLOBAL), this.animation, dt.parameter, 1, true, this.mustFinish));
                    break;
                }
                case VALUE_LAYER: {
                    ValueParameterButtonData dt = new ValueParameterButtonData();
                    dt.setName(this.name);
                    dt.command = this.command;
                    dt.isProperty = this.isProperty;
                    dt.parameter = reg.layerToId.get(this);
                    dt.maxValue = this.maxValue == 0 ? 255 : Byte.toUnsignedInt(this.maxValue);
                    dt.hidden = this.hidden;
                    dt.setDef(reg.def);
                    reg.reg.register(dt);
                    reg.reg.register(new AnimationTrigger.ValueTrigger(reg.reg, Collections.singleton(VanillaPose.GLOBAL), this.animation, dt.parameter, this.maxValue == 0 ? true : this.interpolateVal));
                    break;
                }
            }
        }
    }

    public static class Pose
    implements IPoseGesture {
        private CustomPose pose;
        public boolean hidden;

        public Pose(CustomPose pose) {
            this.pose = pose;
        }

        @Override
        public int getOrder() {
            return this.pose.order;
        }

        @Override
        public void register(LegacyAnimationParser reg) {
            CustomPoseGestureButtonData data = new CustomPoseGestureButtonData(true);
            data.setName(this.pose.getId());
            data.layerCtrl = this.pose.layerCtrl;
            data.command = this.pose.command;
            data.hidden = this.hidden;
            int id = reg.poseGid.get(this.pose);
            if (this.pose.layerCtrl) {
                data.gid = id;
            }
            data.id = id;
            data.setDef(reg.def);
            reg.reg.register(data);
        }
    }

    private static interface IPoseGesture {
        public int getOrder();

        public void register(LegacyAnimationParser var1);
    }

    private static class Group
    implements IPoseGesture {
        private List<Gesture> gs = new ArrayList<Gesture>();
        private String id;
        private int order = Integer.MIN_VALUE;

        public Group(String id) {
            this.id = id;
        }

        public void add(Gesture g) {
            this.gs.add(g);
        }

        @Override
        public int getOrder() {
            if (this.order == Integer.MIN_VALUE) {
                this.order = this.gs.stream().mapToInt(Gesture::getOrder).max().orElse(0);
            }
            return this.order;
        }

        @Override
        public void register(LegacyAnimationParser reg) {
            LegacyDropdownButtonData dt = new LegacyDropdownButtonData();
            dt.setName(this.id);
            dt.command = this.gs.stream().anyMatch(g -> g.command);
            dt.isProperty = this.gs.stream().anyMatch(g -> g.isProperty);
            dt.setDef(reg.def);
            for (Gesture g2 : this.gs) {
                int l = reg.layerToId.get(g2);
                reg.reg.register(new AnimationTrigger.LayerTrigger(reg.reg, Collections.singleton(VanillaPose.GLOBAL), g2.animation, l, 1, true, g2.mustFinish));
                dt.register(g2.name, l);
            }
            reg.reg.register(dt);
        }
    }
}

