/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.builtin;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpl.util.ItemSlot;
import com.tom.cpm.shared.model.builtin.IItemModel;
import com.tom.cpm.shared.model.builtin.SimpleModel;
import com.tom.cpm.shared.model.render.BoxRender;
import com.tom.cpm.shared.model.render.Mesh;

public class ItemModel
extends SimpleModel
implements IItemModel {
    private final String texture;
    private Mesh mesh;
    private IItemModel.ItemRenderTransform[] renderTransform;

    public ItemModel(String texture, IItemModel.ItemRenderTransform[] renderTransform) {
        this.texture = texture;
        this.renderTransform = renderTransform;
        this.mesh = BoxRender.createTexturedExtruded(new Vec3f(), new Vec3f(16.0f, 16.0f, 1.0f), new Vec3f(1.0f, 1.0f, 1.0f), 0.0f, 0, 0, 1, 16, 16);
    }

    @Override
    public void render(MatrixStack stack, VertexBuffer buf) {
        this.mesh.draw(stack, buf, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void render(MatrixStack stack, VertexBuffer buf, ItemSlot inSlot) {
        stack.push();
        boolean flag = inSlot == ItemSlot.LEFT_HAND;
        stack.rotate(Vec3f.POSITIVE_X.getDegreesQuaternion(-90.0f));
        stack.rotate(Vec3f.POSITIVE_Y.getDegreesQuaternion(180.0f));
        stack.translate((float)(flag ? -1 : 1) / 16.0f, 0.125, -0.625);
        if (this.renderTransform.length == 1) {
            this.renderTransform[0].apply(stack);
        } else {
            this.renderTransform[flag ? 1 : 0].apply(stack);
            if (flag) {
                stack.rotate(Vec3f.POSITIVE_Y.getDegreesQuaternion(180.0f));
            }
        }
        stack.translate(-0.5, -0.5, 0.0);
        this.render(stack, buf);
        stack.pop();
    }

    @Override
    public String getTexture() {
        return this.texture;
    }
}

